/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.net.HttpConnectionUtils;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.net.JdkProxyCustomizer;
import com.intellij.util.net.ProxyAuthentication;
import com.intellij.util.net.ProxyConfiguration;
import com.intellij.util.net.ProxyUtils;
import com.intellij.util.net.internal.ProxyMigrationService;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@State(name="HttpConfigurable", category=SettingsCategory.SYSTEM, exportable=true, storages={@Storage(value="proxy.settings.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
public class HttpConfigurable
implements PersistentStateComponent<HttpConfigurable>,
Disposable {
    private static final Logger LOG = Logger.getInstance(HttpConfigurable.class);
    private static final Path PROXY_CREDENTIALS_FILE = PathManager.getOptionsDir().resolve("proxy.settings.pwd");
    @Deprecated(forRemoval=true)
    public boolean USE_HTTP_PROXY;
    @Deprecated(forRemoval=true)
    public boolean USE_PROXY_PAC;
    @Deprecated(forRemoval=true)
    public boolean PROXY_TYPE_IS_SOCKS;
    @Deprecated(forRemoval=true)
    public String PROXY_HOST;
    @Deprecated(forRemoval=true)
    public int PROXY_PORT = 80;
    @Deprecated(forRemoval=true)
    public String PROXY_EXCEPTIONS;
    @Deprecated(forRemoval=true)
    public boolean USE_PAC_URL;
    @Deprecated(forRemoval=true)
    public String PAC_URL;
    @Deprecated(forRemoval=true)
    public volatile boolean PROXY_AUTHENTICATION;
    @Deprecated(forRemoval=true)
    public boolean KEEP_PROXY_PASSWORD;
    @Deprecated(forRemoval=true)
    public transient String LAST_ERROR;
    @Deprecated(forRemoval=true)
    public volatile transient boolean AUTHENTICATION_CANCELLED;
    private final Map<CommonProxy.HostInfo, ProxyInfo> myGenericPasswords = new HashMap<CommonProxy.HostInfo, ProxyInfo>();
    private final Set<CommonProxy.HostInfo> myGenericCancelled = new HashSet<CommonProxy.HostInfo>();
    private final transient Object myLock = new Object();
    private final transient PropertiesEncryptionSupport myEncryptionSupport = new PropertiesEncryptionSupport((Key)new SecretKeySpec(new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99}, "AES"));
    private final transient NotNullLazyValue<Properties> myProxyCredentials = NotNullLazyValue.createValue(() -> {
        try {
            if (!Files.exists(PROXY_CREDENTIALS_FILE, new LinkOption[0])) {
                return new Properties();
            }
            return this.myEncryptionSupport.load(PROXY_CREDENTIALS_FILE);
        }
        catch (Throwable th) {
            LOG.info(th);
            return new Properties();
        }
    });

    public static HttpConfigurable getInstance() {
        return (HttpConfigurable)ApplicationManager.getApplication().getService(HttpConfigurable.class);
    }

    @Deprecated
    public static boolean editConfigurable(@Nullable JComponent parent) {
        return HttpProxyConfigurable.editConfigurable(parent);
    }

    @NotNull
    public HttpConfigurable getState() {
        CommonProxy.isInstalledAssertion();
        HttpConfigurable state = new HttpConfigurable();
        XmlSerializerUtil.copyBean((Object)this, (Object)state);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(state);
        HttpConfigurable httpConfigurable = state;
        if (httpConfigurable == null) {
            HttpConfigurable.$$$reportNull$$$0(0);
        }
        return httpConfigurable;
    }

    public void initializeComponent() {
        if (ProxyMigrationService.getInstance().isNewUser()) {
            this.switchDefaultForNewUser();
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ProxySelector getOnlyBySettingsSelector() {
        ProxySelector proxySelector = JdkProxyCustomizer.getInstance().getOriginalProxySelector();
        if (proxySelector == null) {
            HttpConfigurable.$$$reportNull$$$0(1);
        }
        return proxySelector;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPasswords(@NotNull HttpConfigurable to) {
        if (to == null) {
            HttpConfigurable.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            to.myGenericPasswords.values().removeIf(it -> !it.isStore());
        }
    }

    public void loadState(@NotNull HttpConfigurable state) {
        if (state == null) {
            HttpConfigurable.$$$reportNull$$$0(3);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isGenericPasswordCanceled(@NotNull String host, int port) {
        if (host == null) {
            HttpConfigurable.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myGenericCancelled.contains(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void removeGenericPasswordCancellation(@NotNull String host, int port) {
        if (host == null) {
            HttpConfigurable.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.remove(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void clearGenericCancellations() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void setGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.add(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public PasswordAuthentication getGenericPassword(@NotNull String host, int port) {
        ProxyInfo proxyInfo;
        if (host == null) {
            HttpConfigurable.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myGenericPasswords.isEmpty()) {
                return null;
            }
            proxyInfo = this.myGenericPasswords.get(new CommonProxy.HostInfo(null, host, port));
        }
        if (proxyInfo == null) {
            return null;
        }
        return new PasswordAuthentication(proxyInfo.getUsername(), HttpConfigurable.decode(String.valueOf(proxyInfo.getPasswordCrypt())).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public void putGenericPassword(String host, int port, @NotNull PasswordAuthentication authentication, boolean remember) {
        if (authentication == null) {
            HttpConfigurable.$$$reportNull$$$0(7);
        }
        PasswordAuthentication coded = new PasswordAuthentication(authentication.getUserName(), HttpConfigurable.encode(String.valueOf(authentication.getPassword())).toCharArray());
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.put(new CommonProxy.HostInfo(null, host, port), new ProxyInfo(remember, coded.getUserName(), String.valueOf(coded.getPassword())));
        }
    }

    @Deprecated(forRemoval=true)
    @Transient
    @Nullable
    public String getProxyLogin() {
        return this.getSecure("proxy.login");
    }

    @Deprecated(forRemoval=true)
    @Transient
    public void setProxyLogin(String login) {
        this.storeSecure("proxy.login", login);
    }

    @Deprecated(forRemoval=true)
    @Transient
    @Nullable
    public String getPlainProxyPassword() {
        return this.getSecure("proxy.password");
    }

    @Deprecated(forRemoval=true)
    @Transient
    public void setPlainProxyPassword(String password) {
        this.storeSecure("proxy.password", password);
    }

    private static String decode(String value2) {
        return new String(Base64.getDecoder().decode(value2), StandardCharsets.UTF_8);
    }

    private static String encode(String password) {
        return Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated(forRemoval=true)
    public PasswordAuthentication getGenericPromptedAuthentication(@Nls String prefix, @NlsSafe String host, @Nls String prompt, int port, boolean remember) {
        Credentials credentials = ProxyAuthentication.getInstance().getPromptedAuthentication(prompt, host, port);
        return HttpConfigurable.credentialsToPasswordAuth(credentials);
    }

    private static PasswordAuthentication credentialsToPasswordAuth(Credentials credentials) {
        if (!CredentialAttributesKt.isFulfilled(credentials)) {
            return null;
        }
        return new PasswordAuthentication(credentials.getUserName(), Objects.requireNonNull(credentials.getPassword()).toCharArray());
    }

    @Deprecated(forRemoval=true)
    public PasswordAuthentication getPromptedAuthentication(String host, @Nls String prompt) {
        Credentials credentials = ProxyAuthentication.getInstance().getPromptedAuthentication(prompt, host, this.PROXY_PORT);
        return HttpConfigurable.credentialsToPasswordAuth(credentials);
    }

    @Deprecated(forRemoval=true)
    public void prepareURL(@NotNull String url) throws IOException {
        if (url == null) {
            HttpConfigurable.$$$reportNull$$$0(8);
        }
        HttpConnectionUtils.prepareUrl(url);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public URLConnection openConnection(@NotNull String location) throws IOException {
        if (location == null) {
            HttpConfigurable.$$$reportNull$$$0(9);
        }
        URLConnection uRLConnection = HttpConnectionUtils.openConnection(location);
        if (uRLConnection == null) {
            HttpConfigurable.$$$reportNull$$$0(10);
        }
        return uRLConnection;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        if (location == null) {
            HttpConfigurable.$$$reportNull$$$0(11);
        }
        HttpURLConnection httpURLConnection = HttpConnectionUtils.openHttpConnection(location);
        if (httpURLConnection == null) {
            HttpConfigurable.$$$reportNull$$$0(12);
        }
        return httpURLConnection;
    }

    @Deprecated(forRemoval=true)
    public boolean isHttpProxyEnabledForUrl(@Nullable String url) {
        if (!this.USE_HTTP_PROXY) {
            return false;
        }
        URI uri = url != null ? VfsUtil.toUri((String)url) : null;
        return uri == null || !this.isProxyException(uri.getHost());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<Pair<String, String>> getJvmProperties(boolean withAutodetection, @Nullable URI uri) {
        ArrayList<Pair<String, String>> result2;
        block11: {
            List proxies;
            block9: {
                boolean putCredentials;
                block10: {
                    if (!this.USE_HTTP_PROXY && !this.USE_PROXY_PAC) {
                        List<Pair<String, String>> list = Collections.emptyList();
                        if (list == null) {
                            HttpConfigurable.$$$reportNull$$$0(13);
                        }
                        return list;
                    }
                    if (uri != null && this.isProxyException(uri)) {
                        List<Pair<String, String>> list = Collections.emptyList();
                        if (list == null) {
                            HttpConfigurable.$$$reportNull$$$0(14);
                        }
                        return list;
                    }
                    result2 = new ArrayList<Pair<String, String>>();
                    if (!this.USE_HTTP_PROXY) break block9;
                    boolean bl = putCredentials = this.KEEP_PROXY_PASSWORD && StringUtil.isNotEmpty((String)this.getProxyLogin());
                    if (!this.PROXY_TYPE_IS_SOCKS) break block10;
                    result2.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)this.PROXY_HOST));
                    result2.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                    if (putCredentials) {
                        result2.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.username", (Object)this.getProxyLogin()));
                        result2.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.password", (Object)this.getPlainProxyPassword()));
                    }
                    break block11;
                }
                result2.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)this.PROXY_HOST));
                result2.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                result2.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)this.PROXY_HOST));
                result2.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                if (!putCredentials) break block11;
                result2.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.username", (Object)this.getProxyLogin()));
                result2.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.password", (Object)this.getPlainProxyPassword()));
                break block11;
            }
            if (withAutodetection && uri != null && !(proxies = CommonProxy.getInstance().select(uri)).isEmpty()) {
                for (Proxy proxy : proxies) {
                    SocketAddress address;
                    if (!HttpConfigurable.isRealProxy(proxy) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    if (Proxy.Type.SOCKS.equals((Object)proxy.type())) {
                        result2.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)inetSocketAddress.getHostString()));
                        result2.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                        continue;
                    }
                    result2.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)inetSocketAddress.getHostString()));
                    result2.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                    result2.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)inetSocketAddress.getHostString()));
                    result2.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                }
            }
        }
        ArrayList<Pair<String, String>> arrayList = result2;
        if (arrayList == null) {
            HttpConfigurable.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    public boolean isProxyException(URI uri) {
        String uriHost = uri.getHost();
        return this.isProxyException(uriHost);
    }

    @Contract(value="null -> false")
    private boolean isProxyException(@Nullable String uriHost) {
        if (StringUtil.isEmptyOrSpaces((String)uriHost) || StringUtil.isEmptyOrSpaces((String)this.PROXY_EXCEPTIONS)) {
            return false;
        }
        return ProxyConfiguration.buildProxyExceptionsMatcher(this.PROXY_EXCEPTIONS).test(uriHost);
    }

    @Deprecated(forRemoval=true)
    public static boolean isRealProxy(@NotNull Proxy proxy) {
        if (proxy == null) {
            HttpConfigurable.$$$reportNull$$$0(16);
        }
        return ProxyUtils.isRealProxy(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void clearGenericPasswords() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.clear();
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public void removeGeneric(@NotNull CommonProxy.HostInfo info) {
        if (info == null) {
            HttpConfigurable.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.remove(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean isGenericPasswordRemembered(@NotNull String host, int port) {
        if (host == null) {
            HttpConfigurable.$$$reportNull$$$0(18);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myGenericPasswords.isEmpty()) {
                return false;
            }
            ProxyInfo proxyInfo = this.myGenericPasswords.get(new CommonProxy.HostInfo(null, host, port));
            if (proxyInfo == null) {
                return false;
            }
            return proxyInfo.myStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                return props.getProperty(key, null);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSecure(String key, @Nullable String value2) {
        if (value2 == null) {
            this.removeSecure(key);
            return;
        }
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.setProperty(key, value2);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.remove(key);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private void switchDefaultForNewUser() {
        if (!this.USE_HTTP_PROXY && !this.USE_PROXY_PAC && !this.USE_PAC_URL && StringUtil.isEmpty((String)this.PAC_URL)) {
            this.USE_PROXY_PAC = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/HttpConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authentication";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyBySettingsSelector";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/HttpConfigurable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "openConnection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "openHttpConnection";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctPasswords";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGenericPasswordCanceled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeGenericPasswordCancellation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGenericPassword";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putGenericPassword";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareURL";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openConnection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openHttpConnection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRealProxy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeGeneric";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isGenericPasswordRemembered";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    private static class ProxyInfo {
        public boolean myStore;
        public String myUsername;
        public String myPasswordCrypt;

        ProxyInfo() {
        }

        ProxyInfo(boolean store, String username, String passwordCrypt) {
            this.myStore = store;
            this.myUsername = username;
            this.myPasswordCrypt = passwordCrypt;
        }

        public boolean isStore() {
            return this.myStore;
        }

        public void setStore(boolean store) {
            this.myStore = store;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPasswordCrypt() {
            return this.myPasswordCrypt;
        }

        public void setPasswordCrypt(String passwordCrypt) {
            this.myPasswordCrypt = passwordCrypt;
        }
    }
}

