/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.carets.RemoteCaret;
import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterService;
import com.intellij.cwm.plugin.common.carets.RemoteCaretRenderingUtil;
import com.intellij.cwm.plugin.common.carets.RemoteCaretTooltipRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HintHint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager;", "", "<init>", "()V", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "REMOTE_CARET_GROUP", "Lcom/intellij/codeInsight/hint/TooltipGroup;", "showUserTooltip", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "timeout", "", "doShowUserTooltip", "Companion", "MyMouseEventListener", "intellij.cwm.plugin.common"})
public final class RemoteCaretTooltipManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue = new MergingUpdateQueue("RemoteCaretTooltipProvider", 100, true, null, null, null, false, 112, null);
    @NotNull
    private final TooltipGroup REMOTE_CARET_GROUP = new TooltipGroup("Remote carets tooltips", 10);
    public static final int REMOTE_CARET_TOOLTIP_TIMEOUT = 2000;

    public final void showUserTooltip(@NotNull Editor editor, @NotNull RemoteCaret caret, int timeout) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.mergingUpdateQueue.queue(Update.Companion.create((Object)caret, () -> RemoteCaretTooltipManager.showUserTooltip$lambda$0(this, editor, caret, timeout)));
    }

    public static /* synthetic */ void showUserTooltip$default(RemoteCaretTooltipManager remoteCaretTooltipManager, Editor editor, RemoteCaret remoteCaret, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        remoteCaretTooltipManager.showUserTooltip(editor, remoteCaret, n);
    }

    private final void doShowUserTooltip(Editor editor, RemoteCaret caret, int timeout) {
        if (!caret.isValid()) {
            return;
        }
        double scale = JBUIScale.scale((float)1.0f);
        Rectangle2D.Double pinRectangle = RemoteCaretRenderingUtil.INSTANCE.calculatePinRectangle(caret, scale);
        Point editorPoint = new Point((int)pinRectangle.x, (int)pinRectangle.getMaxY());
        HintHint hintHint = new HintHint(editor, editorPoint);
        RemoteCaretTooltipRenderer tooltipRenderer = new RemoteCaretTooltipRenderer(caret, timeout);
        TooltipController.getInstance().showTooltip(editor, hintHint.getTargetPoint().getPoint(), (TooltipRenderer)tooltipRenderer, false, this.REMOTE_CARET_GROUP, hintHint);
    }

    static /* synthetic */ void doShowUserTooltip$default(RemoteCaretTooltipManager remoteCaretTooltipManager, Editor editor, RemoteCaret remoteCaret, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        remoteCaretTooltipManager.doShowUserTooltip(editor, remoteCaret, n);
    }

    private static final void showUserTooltip$lambda$0(RemoteCaretTooltipManager this$0, Editor $editor, RemoteCaret $caret, int $timeout) {
        this$0.doShowUserTooltip($editor, $caret, $timeout);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager;", "REMOTE_CARET_TOOLTIP_TIMEOUT", "", "intellij.cwm.plugin.common"})
    @SourceDebugExtension(value={"SMAP\nRemoteCaretTooltipManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCaretTooltipManager.kt\ncom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,165:1\n42#2,3:166\n*S KotlinDebug\n*F\n+ 1 RemoteCaretTooltipManager.kt\ncom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager$Companion\n*L\n30#1:166,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteCaretTooltipManager getInstance() {
            boolean $i$f$service = false;
            Class<RemoteCaretTooltipManager> serviceClass$iv = RemoteCaretTooltipManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RemoteCaretTooltipManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipManager$MyMouseEventListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "getTargetOffset", "", "event", "intellij.cwm.plugin.common"})
    public static final class MyMouseEventListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = e.getEditor();
            EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
            if (editorEx == null) {
                return;
            }
            EditorEx editor2 = editorEx;
            Project project = editor2.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            int offset = this.getTargetOffset(e);
            if (offset == -1) {
                return;
            }
            RemoteCaret remoteCaret = RemoteCaretHighlighterService.Companion.getInstance(project2).findRemoteCaret(offset, (Editor)editor2);
            if (remoteCaret == null) {
                return;
            }
            RemoteCaret remoteCaret2 = remoteCaret;
            RemoteCaretTooltipManager tooltipManager = Companion.getInstance();
            tooltipManager.showUserTooltip((Editor)editor2, remoteCaret2, 2000);
        }

        private final int getTargetOffset(EditorMouseEvent event) {
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Point point = event.getMouseEvent().getPoint();
            if (editor2 instanceof EditorEx && editor2.getProject() != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().getModifiers() == 0 && editor2.offsetToPoint2D(event.getOffset()).distance(point) < (double)JBUIScale.scale((int)30) && ((EditorEx)editor2).getFoldingModel().getFoldingPlaceholderAt(point) == null) {
                return event.getOffset();
            }
            return -1;
        }
    }
}

