/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceFinder;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\n\u001a\u00020\u0001*\u0004\u0018\u00010\u0003H\u0000\u00a8\u0006\u000b"}, d2={"isCompiledCellClassDeclaration", "", "element", "Lcom/intellij/psi/PsiElement;", "isFromJVMDeclaration", "tryResolveCompiledDeclarationInNotebook", "scope", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "adjustElement", "psiElement", "isIdentifier", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nfindUsagesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findUsagesHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/find/FindUsagesHandlerKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,182:1\n66#2,2:183\n*S KotlinDebug\n*F\n+ 1 findUsagesHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/find/FindUsagesHandlerKt\n*L\n148#1:183,2\n*E\n"})
public final class FindUsagesHandlerKt {
    public static final boolean isCompiledCellClassDeclaration(@Nullable PsiElement element) {
        CharSequence charSequence;
        Object object = element;
        return object != null && (object = object.getContainingFile()) != null && (object = object.getVirtualFile()) != null && (object = object.getName()) != null ? new Regex("Line_.+\\.class").matches(charSequence = (CharSequence)object) : false;
    }

    public static final boolean isFromJVMDeclaration(@Nullable PsiElement element) {
        Object object = element;
        return object != null && (object = object.getContainingFile()) != null && (object = object.getVirtualFile()) != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)".class", (boolean)false, (int)2, null) : false;
    }

    @Nullable
    public static final PsiElement tryResolveCompiledDeclarationInNotebook(@NotNull PsiElement element, @NotNull JupyterFile scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!FindUsagesHandlerKt.isCompiledCellClassDeclaration(element)) {
            return null;
        }
        Ref.ObjectRef ans = new Ref.ObjectRef();
        ActionsKt.runReadAction(() -> FindUsagesHandlerKt.tryResolveCompiledDeclarationInNotebook$lambda$0(scope, ans, element));
        return (PsiElement)ans.element;
    }

    @NotNull
    public static final PsiElement adjustElement(@NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Ref.ObjectRef curElement = new Ref.ObjectRef();
        if (psiElement instanceof KtPrimaryConstructor || psiElement instanceof KtObjectDeclaration) {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtClass.class, (boolean)true);
            if (ktClass == null || (ktClass = ktClass.getNameIdentifier()) == null) {
                ktClass = psiElement;
            }
            return ktClass;
        }
        if (psiElement instanceof PsiNameIdentifierOwner) {
            PsiElement psiElement3 = ((PsiNameIdentifierOwner)psiElement).getNameIdentifier();
            if (psiElement3 == null) {
                psiElement3 = psiElement;
            }
            return psiElement3;
        }
        if (!(psiElement instanceof PsiIdentifier)) {
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Ref.ObjectRef<PsiElement>)curElement){
                final /* synthetic */ Ref.ObjectRef<PsiElement> $curElement;
                {
                    this.$curElement = $curElement;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (this.$curElement.element == null && FindUsagesHandlerKt.isIdentifier(element)) {
                        this.$curElement.element = element;
                    }
                    super.visitElement(element);
                }
            });
        }
        if ((psiElement2 = (PsiElement)curElement.element) == null) {
            psiElement2 = psiElement;
        }
        return psiElement2;
    }

    public static final boolean isIdentifier(@Nullable PsiElement $this$isIdentifier) {
        Object object = PsiTreeUtilKt.getElementType((PsiElement)$this$isIdentifier);
        return object != null && (object = object.getDebugName()) != null ? ((String)object).equals("IDENTIFIER") : false;
    }

    private static final Unit tryResolveCompiledDeclarationInNotebook$lambda$0(JupyterFile $scope, Ref.ObjectRef $ans, PsiElement $element) {
        List<JupyterPsiCell> targets = UtilKt.getNotebookCells((PsiFile)$scope);
        VirtualFile virtualFile = $scope.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        $ans.element = NotebookReferenceFinder.INSTANCE.tryResolveCompiledDeclaration(UtilKt.toBackedNotebookFile(virtualFile), $element, (Collection<? extends PsiLanguageInjectionHost>)targets);
        return Unit.INSTANCE;
    }
}

