/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B!\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010\u0019\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0096\u0082\u0004J\n\u0010\u001b\u001a\u00020\u0004H\u0096\u0080\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004J\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020!*\u00060\"j\u0002`#H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "", "components", "", "", "isSnapshot", "", "<init>", "(Ljava/util/List;Z)V", "()Z", "major", "getMajor", "()I", "minor", "getMinor", "micro", "getMicro", "build", "getBuild", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "dev", "getDev", "compareTo", "other", "equals", "", "hashCode", "toString", "", "toPyPiVersion", "toMavenVersion", "buildMainVersionPart", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "api"})
public final class KotlinKernelVersion
implements Comparable<KotlinKernelVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> components;
    private final boolean isSnapshot;
    private final int major;
    private final int minor;
    private final int micro;
    @Nullable
    private final Integer build;
    @Nullable
    private final Integer dev;
    public static final char SEP = '.';
    public static final char DEV_SEP = '-';
    @NotNull
    public static final String DEV_PREFIX = "dev";
    @NotNull
    private static final Comparator<String> STRING_VERSION_COMPARATOR = KotlinKernelVersion::STRING_VERSION_COMPARATOR$lambda$0;

    private KotlinKernelVersion(List<Integer> components, boolean isSnapshot) {
        this.components = components;
        this.isSnapshot = isSnapshot;
        this.major = ((Number)this.components.get(0)).intValue();
        this.minor = ((Number)this.components.get(1)).intValue();
        this.micro = ((Number)this.components.get(2)).intValue();
        this.build = (Integer)CollectionsKt.getOrNull(this.components, (int)3);
        this.dev = (Integer)CollectionsKt.getOrNull(this.components, (int)4);
    }

    /* synthetic */ KotlinKernelVersion(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(list, bl);
    }

    public final boolean isSnapshot() {
        return this.isSnapshot;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    @Nullable
    public final Integer getBuild() {
        return this.build;
    }

    @Nullable
    public final Integer getDev() {
        return this.dev;
    }

    @Override
    public int compareTo(@NotNull KotlinKernelVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = KotlinKernelVersion.Companion.maxSize(this.components, other.components);
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)CollectionsKt.getOrNull(this.components, (int)i);
            int thisC = n2 != null ? n2 : -1;
            Integer n3 = (Integer)CollectionsKt.getOrNull(other.components, (int)i);
            int otherC = n3 != null ? n3 : -1;
            int compareRes = Intrinsics.compare((int)thisC, (int)otherC);
            if (compareRes == 0) continue;
            return compareRes;
        }
        return this.isSnapshot && !other.isSnapshot ? -1 : (!this.isSnapshot && other.isSnapshot ? 1 : 0);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KotlinKernelVersion && Intrinsics.areEqual(this.components, ((KotlinKernelVersion)other).components) && this.isSnapshot == ((KotlinKernelVersion)other).isSnapshot;
    }

    public int hashCode() {
        int result2 = ((Object)this.components).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isSnapshot);
        return result2;
    }

    @NotNull
    public String toString() {
        return this.toPyPiVersion();
    }

    @NotNull
    public final String toPyPiVersion() {
        StringBuilder stringBuilder;
        StringBuilder $this$toPyPiVersion_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.buildMainVersionPart($this$toPyPiVersion_u24lambda_u240);
        Integer n = this.build;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl2 = false;
            $this$toPyPiVersion_u24lambda_u240.append('.');
            $this$toPyPiVersion_u24lambda_u240.append(this.build);
            Integer n3 = this.dev;
            if (n3 != null) {
                Integer n4 = n3;
                int it2 = ((Number)n4).intValue();
                boolean bl3 = false;
                $this$toPyPiVersion_u24lambda_u240.append('.');
                $this$toPyPiVersion_u24lambda_u240.append(DEV_PREFIX);
                $this$toPyPiVersion_u24lambda_u240.append(this.dev);
            }
        }
        if (this.isSnapshot) {
            $this$toPyPiVersion_u24lambda_u240.append("+SNAPSHOT");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String toMavenVersion() {
        StringBuilder stringBuilder;
        StringBuilder $this$toMavenVersion_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.buildMainVersionPart($this$toMavenVersion_u24lambda_u240);
        Integer n = this.build;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl2 = false;
            $this$toMavenVersion_u24lambda_u240.append('-');
            $this$toMavenVersion_u24lambda_u240.append(this.build);
            Integer n3 = this.dev;
            if (n3 != null) {
                Integer n4 = n3;
                int it2 = ((Number)n4).intValue();
                boolean bl3 = false;
                $this$toMavenVersion_u24lambda_u240.append('-');
                $this$toMavenVersion_u24lambda_u240.append(this.dev);
            }
        }
        if (this.isSnapshot) {
            $this$toMavenVersion_u24lambda_u240.append("-SNAPSHOT");
        }
        return stringBuilder.toString();
    }

    private final void buildMainVersionPart(StringBuilder $this$buildMainVersionPart) {
        $this$buildMainVersionPart.append(this.major);
        $this$buildMainVersionPart.append('.');
        $this$buildMainVersionPart.append(this.minor);
        $this$buildMainVersionPart.append('.');
        $this$buildMainVersionPart.append(this.micro);
    }

    private static final int STRING_VERSION_COMPARATOR$lambda$0(String str1, String str2) {
        Intrinsics.checkNotNull((Object)str1);
        KotlinKernelVersion kotlinKernelVersion = Companion.fromMavenVersion(str1);
        if (kotlinKernelVersion == null) {
            kotlinKernelVersion = Companion.from(str1);
        }
        KotlinKernelVersion v1 = kotlinKernelVersion;
        Intrinsics.checkNotNull((Object)str2);
        KotlinKernelVersion kotlinKernelVersion2 = Companion.fromMavenVersion(str2);
        if (kotlinKernelVersion2 == null) {
            kotlinKernelVersion2 = Companion.from(str2);
        }
        KotlinKernelVersion v2 = kotlinKernelVersion2;
        return v1 != null && v2 != null ? v1.compareTo(v2) : (v1 != null ? 1 : (v2 != null ? -1 : str1.compareTo(str2)));
    }

    public /* synthetic */ KotlinKernelVersion(List components, boolean isSnapshot, DefaultConstructorMarker $constructor_marker) {
        this(components, isSnapshot);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000e\u001a\u00020\b*\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\bJG\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0002J \u0010\u001f\u001a\u00020\u00142\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030!H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\b0\nj\b\u0012\u0004\u0012\u00020\b`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion$Companion;", "", "<init>", "()V", "SEP", "", "DEV_SEP", "DEV_PREFIX", "", "STRING_VERSION_COMPARATOR", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getSTRING_VERSION_COMPARATOR", "()Ljava/util/Comparator;", "toMaybeUnspecifiedString", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "from", "string", "fromMavenVersion", "major", "", "minor", "micro", "build", "dev", "isSnapshot", "", "(IIILjava/lang/Integer;Ljava/lang/Integer;Z)Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "validateComponents", "components", "", "maxSize", "a", "", "b", "parseVersionComponents", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion$Companion$VersionComponents;", "version", "snapshotSuffix", "VersionComponents", "api"})
    @SourceDebugExtension(value={"SMAP\nKotlinKernelVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinKernelVersion.kt\norg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1786#2,3:215\n*S KotlinDebug\n*F\n+ 1 KotlinKernelVersion.kt\norg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion$Companion\n*L\n192#1:215,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<String> getSTRING_VERSION_COMPARATOR() {
            return STRING_VERSION_COMPARATOR;
        }

        @NotNull
        public final String toMaybeUnspecifiedString(@Nullable KotlinKernelVersion $this$toMaybeUnspecifiedString) {
            Object object = $this$toMaybeUnspecifiedString;
            if (object == null || (object = ((KotlinKernelVersion)object).toString()) == null) {
                object = "unspecified";
            }
            return object;
        }

        @Nullable
        public final KotlinKernelVersion from(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            VersionComponents versionComponents = this.parseVersionComponents(string, "+SNAPSHOT");
            List<String> components = versionComponents.component1();
            boolean isSnapshot = versionComponents.component2();
            int n = components.size();
            if (!(3 <= n ? n < 6 : false)) {
                return null;
            }
            List intComponents = new ArrayList();
            for (int i = 0; i < 3; ++i) {
                Integer n2 = StringsKt.toIntOrNull((String)components.get(i));
                if (n2 == null) {
                    return null;
                }
                intComponents.add(Integer.valueOf(n2));
            }
            if (components.size() >= 4) {
                Integer n3 = StringsKt.toIntOrNull((String)components.get(3));
                if (n3 == null) {
                    return null;
                }
                intComponents.add(Integer.valueOf(n3));
                if (components.size() >= 5) {
                    String devComponent = components.get(4);
                    if (!StringsKt.startsWith$default((String)devComponent, (String)KotlinKernelVersion.DEV_PREFIX, (boolean)false, (int)2, null)) {
                        return null;
                    }
                    Integer n4 = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)devComponent, (CharSequence)KotlinKernelVersion.DEV_PREFIX));
                    if (n4 == null) {
                        return null;
                    }
                    int devInt = n4;
                    intComponents.add(devInt);
                }
            }
            if (!this.validateComponents(intComponents)) {
                return null;
            }
            return new KotlinKernelVersion(intComponents, isSnapshot, null);
        }

        @Nullable
        public final KotlinKernelVersion fromMavenVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            VersionComponents versionComponents = this.parseVersionComponents(string, "-SNAPSHOT");
            List<String> components = versionComponents.component1();
            boolean isSnapshot = versionComponents.component2();
            if (components.size() != 3) {
                return null;
            }
            List intComponents = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                Integer n = StringsKt.toIntOrNull((String)components.get(i));
                if (n == null) {
                    return null;
                }
                intComponents.add(Integer.valueOf(n));
            }
            String lastComponent = components.get(2);
            Object object = new char[]{'-'};
            List lastIntComponents = StringsKt.split$default((CharSequence)lastComponent, (char[])object, (boolean)false, (int)0, (int)6, null);
            object = lastIntComponents.iterator();
            while (object.hasNext()) {
                String component = (String)object.next();
                Integer n = StringsKt.toIntOrNull((String)component);
                if (n == null) {
                    return null;
                }
                intComponents.add(Integer.valueOf(n));
            }
            if (!this.validateComponents(intComponents)) {
                return null;
            }
            return new KotlinKernelVersion(intComponents, isSnapshot, null);
        }

        @Nullable
        public final KotlinKernelVersion from(int major, int minor, int micro, @Nullable Integer build, @Nullable Integer dev, boolean isSnapshot) {
            List components;
            List list;
            List $this$from_u24lambda_u240 = list = (List)new ArrayList();
            boolean bl = false;
            $this$from_u24lambda_u240.add(major);
            $this$from_u24lambda_u240.add(minor);
            $this$from_u24lambda_u240.add(micro);
            Integer n = build;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                $this$from_u24lambda_u240.add(build);
                Integer n2 = dev;
                if (n2 != null) {
                    int it2 = ((Number)n2).intValue();
                    boolean bl3 = false;
                    $this$from_u24lambda_u240.add(dev);
                }
            }
            if (!this.validateComponents(components = list)) {
                return null;
            }
            return new KotlinKernelVersion(components, isSnapshot, null);
        }

        public static /* synthetic */ KotlinKernelVersion from$default(Companion companion, int n, int n2, int n3, Integer n4, Integer n5, boolean bl, int n6, Object object) {
            if ((n6 & 8) != 0) {
                n4 = null;
            }
            if ((n6 & 0x10) != 0) {
                n5 = null;
            }
            if ((n6 & 0x20) != 0) {
                bl = false;
            }
            return companion.from(n, n2, n3, n4, n5, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean validateComponents(List<Integer> components) {
            boolean bl;
            int n = components.size();
            if (3 > n) return false;
            if (n >= 6) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Iterable $this$all$iv = components;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                int it = ((Number)element$iv).intValue();
                boolean bl3 = false;
                if (it < 0) return false;
                bl = true;
            } while (bl);
            return false;
        }

        private final int maxSize(Collection<?> a, Collection<?> b) {
            return a.size() > b.size() ? a.size() : b.size();
        }

        private final VersionComponents parseVersionComponents(String version, String snapshotSuffix) {
            boolean isSnapshot = StringsKt.endsWith$default((String)version, (String)snapshotSuffix, (boolean)false, (int)2, null);
            char[] cArray = new char[]{'.'};
            List components = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)version, (CharSequence)snapshotSuffix), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            return new VersionComponents(components, isSnapshot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion$Companion$VersionComponents;", "", "components", "", "", "isSnapshot", "", "<init>", "(Ljava/util/List;Z)V", "getComponents", "()Ljava/util/List;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "api"})
        private static final class VersionComponents {
            @NotNull
            private final List<String> components;
            private final boolean isSnapshot;

            public VersionComponents(@NotNull List<String> components, boolean isSnapshot) {
                Intrinsics.checkNotNullParameter(components, (String)"components");
                this.components = components;
                this.isSnapshot = isSnapshot;
            }

            @NotNull
            public final List<String> getComponents() {
                return this.components;
            }

            public final boolean isSnapshot() {
                return this.isSnapshot;
            }

            @NotNull
            public final List<String> component1() {
                return this.components;
            }

            public final boolean component2() {
                return this.isSnapshot;
            }

            @NotNull
            public final VersionComponents copy(@NotNull List<String> components, boolean isSnapshot) {
                Intrinsics.checkNotNullParameter(components, (String)"components");
                return new VersionComponents(components, isSnapshot);
            }

            public static /* synthetic */ VersionComponents copy$default(VersionComponents versionComponents, List list, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    list = versionComponents.components;
                }
                if ((n & 2) != 0) {
                    bl = versionComponents.isSnapshot;
                }
                return versionComponents.copy(list, bl);
            }

            @NotNull
            public String toString() {
                return "VersionComponents(components=" + this.components + ", isSnapshot=" + this.isSnapshot + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.components).hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.isSnapshot);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VersionComponents)) {
                    return false;
                }
                VersionComponents versionComponents = (VersionComponents)other;
                if (!Intrinsics.areEqual(this.components, versionComponents.components)) {
                    return false;
                }
                return this.isSnapshot == versionComponents.isSnapshot;
            }
        }
    }
}

