/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.types.ChoiceKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;
import org.jetbrains.kotlinx.jupyter.common.ReplLineMagic;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplPreprocessingException;
import org.jetbrains.kotlinx.jupyter.magics.BasicMagicsHandler;
import org.jetbrains.kotlinx.jupyter.magics.MagicsHandler;
import org.jetbrains.kotlinx.jupyter.magics.UnhandledMagicException;
import org.jetbrains.kotlinx.jupyter.magics.contexts.CommandHandlingMagicHandlerContext;
import org.jetbrains.kotlinx.jupyter.magics.contexts.ContextUtilKt;
import org.jetbrains.kotlinx.jupyter.magics.contexts.MagicHandlerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0004J\u001e\u0010\u0016\u001a\u00020\u00102\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00100\u0018H\u0004J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000eH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/BasicMagicsHandler;", "Lorg/jetbrains/kotlinx/jupyter/magics/MagicsHandler;", "context", "Lorg/jetbrains/kotlinx/jupyter/magics/contexts/MagicHandlerContext;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/magics/contexts/MagicHandlerContext;)V", "getContext", "()Lorg/jetbrains/kotlinx/jupyter/magics/contexts/MagicHandlerContext;", "commandHandlingContext", "Lorg/jetbrains/kotlinx/jupyter/magics/contexts/CommandHandlingMagicHandlerContext;", "getCommandHandlingContext", "()Lorg/jetbrains/kotlinx/jupyter/magics/contexts/CommandHandlingMagicHandlerContext;", "callbackMap", "", "Lorg/jetbrains/kotlinx/jupyter/common/ReplLineMagic;", "Lkotlin/Function0;", "", "getCallbackMap", "()Ljava/util/Map;", "canHandle", "", "magic", "handleSingleOptionalFlag", "action", "Lkotlin/Function1;", "handle", "magicText", "", "tryIgnoreErrors", "parseOnly", "Companion", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nBasicMagicsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicMagicsHandler.kt\norg/jetbrains/kotlinx/jupyter/magics/BasicMagicsHandler\n+ 2 ContextUtil.kt\norg/jetbrains/kotlinx/jupyter/magics/contexts/ContextUtilKt\n*L\n1#1,103:1\n9#2:104\n6#2,6:105\n*S KotlinDebug\n*F\n+ 1 BasicMagicsHandler.kt\norg/jetbrains/kotlinx/jupyter/magics/BasicMagicsHandler\n*L\n22#1:104\n22#1:105,6\n*E\n"})
public abstract class BasicMagicsHandler
implements MagicsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MagicHandlerContext context;
    @NotNull
    private final CommandHandlingMagicHandlerContext commandHandlingContext;
    @NotNull
    private final Map<ReplLineMagic, Function0<Unit>> callbackMap;

    public BasicMagicsHandler(@NotNull MagicHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MagicHandlerContext $this$requireContext$iv = this.context = context;
        boolean $i$f$requireContext = false;
        MagicHandlerContext $this$getContext$iv$iv = $this$requireContext$iv;
        boolean $i$f$getContext = false;
        Object t = ContextUtilKt.getContext($this$getContext$iv$iv, Reflection.getOrCreateKotlinClass(CommandHandlingMagicHandlerContext.class));
        if (t == null) {
            boolean bl = false;
            String string = "Context " + Reflection.getOrCreateKotlinClass(CommandHandlingMagicHandlerContext.class).getSimpleName() + " is required for " + $this$requireContext$iv;
            throw new IllegalArgumentException(string.toString());
        }
        this.commandHandlingContext = (CommandHandlingMagicHandlerContext)t;
        this.callbackMap = MapsKt.emptyMap();
    }

    @NotNull
    protected final MagicHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final CommandHandlingMagicHandlerContext getCommandHandlingContext() {
        return this.commandHandlingContext;
    }

    @NotNull
    protected Map<ReplLineMagic, Function0<Unit>> getCallbackMap() {
        return this.callbackMap;
    }

    protected final boolean canHandle(@NotNull ReplLineMagic magic) {
        Intrinsics.checkNotNullParameter((Object)((Object)magic), (String)"magic");
        return this.getCallbackMap().containsKey((Object)magic);
    }

    protected final void handleSingleOptionalFlag(@NotNull Function1<? super Boolean, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CliktCommand.parse$default(new CliktCommand(action){
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            private final ReadOnlyProperty arg$delegate;
            final /* synthetic */ Function1<Boolean, Unit> $action;
            {
                this.$action = $action;
                super(null, null, null, false, false, null, null, false, false, 511, null);
                this.arg$delegate = BasicMagicsHandler.Companion.nullableFlag(this).provideDelegate(this, $$delegatedProperties[0]);
            }

            public final Boolean getArg() {
                return (Boolean)this.arg$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            public void run() {
                this.$action.invoke((Object)this.getArg());
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{new PropertyReference1Impl(handleSingleOptionalFlag.1.class, "arg", "getArg()Ljava/lang/Boolean;", 0)};
                $$delegatedProperties = kPropertyArray;
            }
        }, this.commandHandlingContext.argumentsList(), null, 2, null);
    }

    @Override
    public void handle(@NotNull String magicText, boolean tryIgnoreErrors, boolean parseOnly) {
        Intrinsics.checkNotNullParameter((Object)magicText, (String)"magicText");
        try {
            ReplLineMagic magic;
            ReplLineMagic replLineMagic;
            String arg;
            char[] cArray = new char[]{' '};
            List parts = StringsKt.split$default((CharSequence)magicText, (char[])cArray, (boolean)false, (int)2, (int)2, null);
            String keyword = (String)parts.get(0);
            String string = arg = ((Collection)parts).size() > 1 ? (String)parts.get(1) : null;
            if (parseOnly) {
                replLineMagic = null;
            } else {
                ReplEnum.CodeInsightValue<ReplLineMagic> codeInsightValue = ReplLineMagic.Companion.valueOfOrNull(keyword);
                replLineMagic = magic = codeInsightValue != null ? codeInsightValue.getValue() : null;
            }
            if (magic == null && !parseOnly && !tryIgnoreErrors) {
                throw new ReplPreprocessingException("Unknown line magic keyword: '" + keyword + "'", null, 2, null);
            }
            if (magic != null && !this.canHandle(magic)) {
                throw new UnhandledMagicException(magic, this);
            }
            this.commandHandlingContext.setArg(arg);
            this.commandHandlingContext.setTryIgnoreErrors(tryIgnoreErrors);
            this.commandHandlingContext.setParseOnly(parseOnly);
            if (magic != null) {
                this.handle(magic);
            }
        }
        catch (Exception e) {
            if (e instanceof UnhandledMagicException) {
                throw e;
            }
            throw new ReplPreprocessingException("Failed to process '%" + magicText + "' command. " + e.getMessage(), e);
        }
    }

    protected final void handle(@NotNull ReplLineMagic magic) {
        Intrinsics.checkNotNullParameter((Object)((Object)magic), (String)"magic");
        Function0<Unit> function0 = this.getCallbackMap().get((Object)magic);
        if (function0 == null) {
            throw new UnhandledMagicException(magic, this);
        }
        Function0<Unit> callback = function0;
        callback.invoke();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/BasicMagicsHandler$Companion;", "", "<init>", "()V", "nullableFlag", "Lcom/github/ajalt/clikt/parameters/arguments/ProcessedArgument;", "", "Lcom/github/ajalt/clikt/core/CliktCommand;", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcessedArgument<Boolean, Boolean> nullableFlag(@NotNull CliktCommand $this$nullableFlag) {
            Intrinsics.checkNotNullParameter((Object)$this$nullableFlag, (String)"<this>");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"on", (Object)true), TuplesKt.to((Object)"off", (Object)false)};
            return ArgumentKt.optional(ChoiceKt.choice$default(ArgumentKt.argument$default($this$nullableFlag, null, null, null, null, 15, null), MapsKt.mapOf((Pair[])pairArray), false, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

