/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging.comms.server;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.messaging.CommCloseMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsgMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpenMessage;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.comms.CommCommunicationFacility;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J0\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/comms/server/ServerCommCommunicationFacility;", "Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommCommunicationFacility;", "communicationFacility", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;)V", "contextMessage", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "getContextMessage", "()Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "sendCommOpen", "", "commId", "", "targetName", "data", "Lkotlinx/serialization/json/JsonObject;", "metadata", "Lkotlinx/serialization/json/JsonElement;", "buffers", "", "", "sendCommMessage", "sendCommClose", "processCallbacks", "action", "Lkotlin/Function0;", "shared-compiler"})
public final class ServerCommCommunicationFacility
implements CommCommunicationFacility {
    @NotNull
    private final JupyterCommunicationFacility communicationFacility;

    public ServerCommCommunicationFacility(@NotNull JupyterCommunicationFacility communicationFacility) {
        Intrinsics.checkNotNullParameter((Object)communicationFacility, (String)"communicationFacility");
        this.communicationFacility = communicationFacility;
    }

    @Nullable
    public RawMessage getContextMessage() {
        return this.communicationFacility.getMessageFactory().getContextMessage();
    }

    public void sendCommOpen(@NotNull String commId, @NotNull String targetName, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        JupyterCommunicationFacilityKt.sendReplyMessageToIoPub(this.communicationFacility, MessageType.COMM_OPEN, new CommOpenMessage(commId, targetName, data), metadata, buffers);
    }

    public void sendCommMessage(@NotNull String commId, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        JupyterCommunicationFacilityKt.sendReplyMessageToIoPub(this.communicationFacility, MessageType.COMM_MSG, new CommMsgMessage(commId, data), metadata, buffers);
    }

    public void sendCommClose(@NotNull String commId, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        JupyterCommunicationFacilityKt.sendReplyMessageToIoPub(this.communicationFacility, MessageType.COMM_CLOSE, new CommCloseMessage(commId, data), metadata, buffers);
    }

    public void processCallbacks(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        JupyterCommunicationFacilityKt.doWrappedInBusyIdle(this.communicationFacility, action);
    }
}

