/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.RefactoringUiService;
import com.intellij.refactoring.RefactoringUsageCollector;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance(BaseRefactoringProcessor.class);
    private static boolean PREVIEW_IN_TESTS = true;
    protected final Project myProject;
    @NotNull
    protected final SearchScope myRefactoringScope;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;
    private UsageView myUsageView;

    protected BaseRefactoringProcessor(@NotNull Project project) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(1);
        }
        this(project, (SearchScope)GlobalSearchScope.projectScope((Project)project), prepareSuccessfulCallback);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @NotNull SearchScope refactoringScope, @Nullable Runnable prepareSuccessfulCallback) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(2);
        }
        if (refactoringScope == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
        this.myRefactoringScope = refactoringScope;
    }

    @ApiStatus.Internal
    public Runnable getPrepareSuccessfulSwingThreadCallback() {
        return this.myPrepareSuccessfulSwingThreadCallback;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] var1);

    @ApiStatus.OverrideOnly
    protected abstract UsageInfo @NotNull [] findUsages();

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(4);
        }
    }

    @ApiStatus.OverrideOnly
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(5);
        }
        this.prepareSuccessful();
        return true;
    }

    @ApiStatus.OverrideOnly
    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(6);
        }
        return this.myIsPreviewUsages;
    }

    @ApiStatus.Internal
    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    protected Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor) {
        if (ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnloadedModuleDescription> unloadedModulesInUseScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (PsiElement element : descriptor.getElements()) {
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            unloadedModulesInUseScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return unloadedModulesInUseScope;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    @RequiresEdt
    @RequiresWriteLock
    protected abstract void performRefactoring(UsageInfo @NotNull [] var1);

    @NlsContexts.Command
    @NotNull
    protected abstract String getCommandName();

    @RequiresEdt
    protected void doRun() {
        boolean isPreview;
        ThreadingAssertions.assertEventDispatchThread();
        if (!PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocumentsUnderProgress()) {
            return;
        }
        Ref refUsages = new Ref();
        Ref refErrorLanguage = new Ref();
        Ref refProcessCanceled = new Ref();
        Ref anyException = new Ref();
        Ref indexNotReadyException = new Ref();
        DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
        Runnable findUsagesRunnable = () -> {
            try {
                refUsages.set((Object)((UsageInfo[])ReadAction.compute(this::findUsages)));
            }
            catch (UnknownReferenceTypeException e) {
                refErrorLanguage.set((Object)e.getElementLanguage());
            }
            catch (ProcessCanceledException e) {
                refProcessCanceled.set((Object)e);
            }
            catch (IndexNotReadyException e) {
                indexNotReadyException.set((Object)Boolean.TRUE);
            }
            catch (Throwable e) {
                anyException.set((Object)Boolean.TRUE);
                LOG.error(e);
            }
        };
        long findUsagesStart = System.currentTimeMillis();
        boolean isProgressFinished = ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message("progress.text"), true, this.myProject);
        long findUsagesDuration = System.currentTimeMillis() - findUsagesStart;
        RefactoringUsageCollector.USAGES_SEARCHED.log(this.getClass(), (Object)(!isProgressFinished ? 1 : 0), (Object)findUsagesDuration);
        if (!isProgressFinished) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            MessagesService.getInstance().showErrorDialog(this.myProject, RefactoringBundle.message("unsupported.refs.found", ((Language)refErrorLanguage.get()).getDisplayName()), RefactoringBundle.message("error.title"));
            return;
        }
        if (!indexNotReadyException.isNull() || DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotificationForFunctionality(RefactoringBundle.message("refactoring.dumb.mode.notification"), DumbModeBlockedFunctionality.Refactoring);
            return;
        }
        if (!refProcessCanceled.isNull()) {
            IllegalStateException exception = new IllegalStateException((Throwable)refProcessCanceled.get());
            LOG.error("PCE was not expected here", (Throwable)exception);
            MessagesService.getInstance().showErrorDialog(this.myProject, RefactoringBundle.message("refactoring.index.corruption.notifiction"), RefactoringBundle.message("error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + String.valueOf(this);
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor = this.createUsageViewDescriptor(usages);
        boolean bl = isPreview = this.isPreviewUsages(usages) || !this.computeUnloadedModulesFromUseScope(descriptor).isEmpty();
        if (!isPreview) {
            boolean bl2 = isPreview = !this.ensureElementsWritable(usages, descriptor) || UsageViewUtil.hasReadOnlyUsages((UsageInfo[])usages);
            if (isPreview) {
                RefactoringUiService.getInstance().setStatusBarInfo(this.myProject, RefactoringBundle.message("readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    @TestOnly
    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || Boolean.getBoolean("ide.performance.skip.refactoring.dialogs")) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join((Object[])usages, UsageInfo::toString, (String)", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(elements, true);
        Factory factory = () -> new UsageInfoSearcherAdapter(){

            public void generate(@NotNull Processor<? super Usage> processor) {
                if (processor == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i = 0; i < elements.length; ++i) {
                        elements2[i] = targets[i].getElement();
                    }
                    BaseRefactoringProcessor.this.refreshElements(elements);
                });
                this.processUsages(processor, BaseRefactoringProcessor.this.myProject);
            }

            protected UsageInfo @NotNull [] findUsages() {
                UsageInfo[] usageInfoArray = BaseRefactoringProcessor.this.findUsages();
                if (usageInfoArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return usageInfoArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "generate";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.showUsageView(viewDescriptor, (Factory<? extends UsageSearcher>)factory, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(UsageInfo @NotNull [] usages, @NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(8);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(9);
        }
        ReferenceOpenHashSet elements = new ReferenceOpenHashSet();
        for (UsageInfo usage : usages) {
            PsiElement element;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element = usage.getElement()) == null) continue;
            elements.add(element);
        }
        elements.addAll(this.getElementsToWrite(descriptor));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements);
    }

    private static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(11);
        }
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements);
        return CommonRefactoringUtil.checkReadOnlyStatus(project, psiElements);
    }

    public void executeEx(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(12);
        }
        this.execute(usages);
    }

    @ApiStatus.OverrideOnly
    protected void execute(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(13);
        }
        long executeStart = System.currentTimeMillis();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
            this.doRefactoring(usageInfos);
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            }
            SuggestedRefactoringProvider.getInstance(this.myProject).reset();
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
        long executeDuration = System.currentTimeMillis() - executeStart;
        RefactoringUsageCollector.EXECUTED.log(this.getClass(), (Object)executeDuration);
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        if (undoConfirmationPolicy == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(14);
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor, Usage @NotNull [] usages) {
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(15);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(16);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message("usageView.tabText"));
        presentation.setTargetsNodeText(descriptor.getProcessedElementsHeader());
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message("usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet<PsiFile> codeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> nonCodeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> dynamicUsagesCodeFiles = new HashSet<PsiFile>();
        for (Usage usage : usages) {
            PsiElementUsage elementUsage;
            PsiElement element;
            if (!(usage instanceof PsiElementUsage) || (element = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            if (usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().isDynamicUsage()) {
                ++dynamicUsagesCount;
                dynamicUsagesCodeFiles.add(containingFile);
                continue;
            }
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
                continue;
            }
            ++codeUsageCount;
            codeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        presentation.setCodeUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.code", (Object[])new Object[0]), descriptor.getCodeReferencesText(codeUsageCount, codeFiles.size())}));
        presentation.setNonCodeUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.non.code", (Object[])new Object[0]), descriptor.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size())}));
        presentation.setDynamicUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.dynamic", (Object[])new Object[0]), descriptor.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())}));
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(17);
        }
        return usageViewPresentation;
    }

    public static boolean processConflicts(@NotNull Project project, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(18);
        }
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(19);
        }
        if (conflicts.isEmpty()) {
            return true;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ConflictsInTestsException.isTestIgnore()) {
                return true;
            }
            throw new ConflictsInTestsException(conflicts.values());
        }
        ConflictsDialogBase conflictsDialog = RefactoringUiService.getInstance().createConflictsDialog(project, conflicts, null, true, true);
        return conflictsDialog.showAndGet();
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull Factory<? extends UsageSearcher> factory, UsageInfo @NotNull [] usageInfos) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(20);
        }
        if (factory == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(21);
        }
        if (usageInfos == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(22);
        }
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(initialElements, true);
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), RefactoringBundle.message("refactoring.preprocess.usages.progress"), true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        if (this.myUsageView == null) {
            this.myUsageView = viewManager.showUsages((UsageTarget[])targets, usages, presentation, factory);
            this.customizeUsagesView(viewDescriptor, this.myUsageView);
        } else {
            this.myUsageView.removeUsagesBulk((Collection)this.myUsageView.getUsages());
            ((UsageViewEx)this.myUsageView).appendUsagesInBulk(Arrays.asList(usages));
        }
        Set<UnloadedModuleDescription> unloadedModules = this.computeUnloadedModulesFromUseScope(viewDescriptor);
        if (!unloadedModules.isEmpty()) {
            this.myUsageView.appendUsage((Usage)new UnknownUsagesInUnloadedModules(unloadedModules));
        }
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(23);
        }
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(24);
        }
        Runnable refactoringRunnable = () -> {
            Set usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY);
            if (this.ensureElementsWritable(infos, viewDescriptor)) {
                this.execute(infos);
            }
        };
        String canNotMakeString = RefactoringBundle.message("usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable, canNotMakeString);
        usageView.setRerunAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRefactoringProcessor.this.run();
            }
        });
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable, @NotNull String canNotMakeString) {
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(25);
        }
        if (refactoringRunnable == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(26);
        }
        if (canNotMakeString == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(27);
        }
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message("usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        if (usageInfoSet == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(28);
        }
        Iterator<UsageInfo> iterator = usageInfoSet.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            PsiElement element = usageInfo.getElement();
            if (element != null && this.isToBeChanged(usageInfo)) continue;
            iterator.remove();
        }
        String commandName = this.getCommandName();
        LocalHistoryAction action = LocalHistory.getInstance().startAction(commandName);
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(UsageInfo.EMPTY_ARRAY);
        String refactoringId = this.getRefactoringId();
        try {
            ApplicationEx app;
            if (refactoringId != null) {
                RefactoringEventData data = this.getBeforeData();
                if (data != null) {
                    data.addUsages(Arrays.asList(writableUsageInfos));
                }
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, data);
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance(this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = () -> {
                PsiElement[] psiElementArray;
                PsiElement primaryElement;
                RefactoringEventData data = (RefactoringEventData)((Object)((Object)ReadAction.compute(() -> this.getBeforeData())));
                Object[] elements = data != null ? (PsiElement[])data.getUserData(RefactoringEventData.PSI_ELEMENT_ARRAY_KEY) : null;
                PsiElement psiElement = primaryElement = data != null ? (PsiElement)data.getUserData(RefactoringEventData.PSI_ELEMENT_KEY) : null;
                if (elements != null) {
                    psiElementArray = (PsiElement[])ArrayUtil.append((Object[])elements, (Object)primaryElement);
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = primaryElement;
                }
                PsiElement[] allElements = psiElementArray;
                for (RefactoringHelper helper : RefactoringHelper.EP_NAME.getExtensionList()) {
                    Object operation = ReadAction.compute(() -> helper.prepareOperation(writableUsageInfos, ContainerUtil.filter((Object[])allElements, e -> e != null)));
                    preparedData.put(helper, operation);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, RefactoringBundle.message("refactoring.prepare.progress"), false, this.myProject);
            if (refactoringId != null) {
                UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)new UndoRefactoringAction(this.myProject, refactoringId));
            }
            if (!(app = ApplicationManagerEx.getApplicationEx()).runWriteActionWithCancellableProgressInDispatchThread(commandName, this.myProject, null, indicator -> this.performRefactoring(writableUsageInfos))) {
                return;
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                RefactoringHelper refactoringHelper = (RefactoringHelper)e.getKey();
                Object operation = e.getValue();
                refactoringHelper.performOperation(this.myProject, operation);
            }
            this.myTransaction.commit();
            if (!app.runWriteActionWithCancellableProgressInDispatchThread(commandName, this.myProject, null, indicator -> this.performPsiSpoilingRefactoring())) {
                return;
            }
        }
        finally {
            if (refactoringId != null) {
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, this.getAfterData(writableUsageInfos));
            }
            action.finish();
            this.myUsageView = null;
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            RefactoringUiService.getInstance().setStatusBarInfo(this.myProject, RefactoringBundle.message("statusBar.refactoring.result", count));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            RefactoringUiService.getInstance().setStatusBarInfo(this.myProject, RefactoringBundle.message("statusBar.noUsages"));
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(29);
        }
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                ApplicationManager.getApplication().invokeAndWait(this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (RuntimeException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public final void run() {
        Runnable runnable;
        Runnable baseRunnable = () -> {
            try (AccessToken ignored = SlowOperations.startSection((String)"action.perform");){
                this.doRun();
            }
        };
        Runnable runnable2 = runnable = this.shouldDisableAccessChecks() ? () -> NonProjectFileWritingAccessProvider.disableChecksDuring(baseRunnable) : baseRunnable;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ThreadingAssertions.assertWriteIntentReadAccess();
            runnable.run();
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", (Throwable)new Exception());
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean shouldDisableAccessChecks() {
        return false;
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(30);
        }
        if (!conflicts.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Boolean.getBoolean("ide.performance.skip.refactoring.dialogs"))) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialogBase conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, conflicts.values());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialogBase prepareConflictsDialog(@NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(31);
        }
        ConflictsDialogBase conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        ConflictsDialogBase conflictsDialogBase = conflictsDialog;
        if (conflictsDialogBase == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(32);
        }
        return conflictsDialogBase;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NonNls
    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialogBase createConflictsDialog(@NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(34);
        }
        ConflictsDialogBase conflictsDialogBase = RefactoringUiService.getInstance().createConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true);
        if (conflictsDialogBase == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(35);
        }
        return conflictsDialogBase;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(36);
        }
        List<PsiElement> list = Arrays.asList(descriptor.getElements());
        if (list == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 17, 32, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringScope";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 15: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: 
            case 17: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 19: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewDescriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringRunnable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canNotMakeString";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoSet";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConflictsDialog";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictsDialog";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureElementsWritable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeEx";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 17: 
            case 32: 
            case 35: 
            case 37: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processConflicts";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "customizeUsagesView";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addDoRefactoringAction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isToBeChanged";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showConflicts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "prepareConflictsDialog";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 17, 32, 35, 37 -> new IllegalStateException(string);
        };
    }

    public static final class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<String> messages) {
            if (messages == null) {
                ConflictsInTestsException.$$$reportNull$$$0(0);
            }
            this.messages = messages;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        @TestOnly
        public static <T extends Throwable> void withIgnoredConflicts(@NotNull ThrowableRunnable<T> r) throws T {
            if (r == null) {
                ConflictsInTestsException.$$$reportNull$$$0(1);
            }
            try {
                myTestIgnore = true;
                r.run();
            }
            finally {
                myTestIgnore = false;
            }
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result = new ArrayList<String>(this.messages);
            for (int i = 0; i < this.messages.size(); ++i) {
                result.set(i, ((String)result.get(i)).replaceAll("<[^>]+>", ""));
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ConflictsInTestsException.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public String getMessage() {
            List result = ContainerUtil.sorted(this.messages);
            return StringUtil.join((Collection)result, (String)"\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withIgnoredConflicts";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        UndoRefactoringAction(@NotNull Project project, @NotNull String refactoringId) {
            if (project == null) {
                UndoRefactoringAction.$$$reportNull$$$0(0);
            }
            if (refactoringId == null) {
                UndoRefactoringAction.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRefactoringId = refactoringId;
        }

        public void undo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(this.myRefactoringId);
        }

        public void redo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).redoRefactoring(this.myRefactoringId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refactoringId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UndoRefactoringAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            if (elementLanguage == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(0);
            }
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        Language getElementLanguage() {
            Language language = this.myElementLanguage;
            if (language == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(1);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementLanguage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

