/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.kubernetes.api.settings.KubernetesConfigFileManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "saveConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStoredConfigFiles", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupStoredConfigFiles", "", "configs", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesConfigFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n1915#2,2:119\n13#3:121\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager\n*L\n100#1:119,2\n20#1:121\n*E\n"})
public final class KubernetesConfigFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CONFIG_DIR = ".idea/kubernetes/configs";
    private static final DateTimeFormatter DATE_FORMAT;

    public KubernetesConfigFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveConfigFile(@NotNull String content, @NotNull Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof saveConfigFile.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesConfigFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveConfigFile(null, (Continuation<? super VirtualFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                configDirFile = new Ref.ObjectRef();
                configFile = new Ref.ObjectRef();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)content);
                $continuation.L$1 = configDirFile;
                $continuation.L$2 = configFile;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(this, (Ref.ObjectRef<File>)configDirFile, (Ref.ObjectRef<File>)configFile, content, null){
                    int label;
                    final /* synthetic */ KubernetesConfigFileManager this$0;
                    final /* synthetic */ Ref.ObjectRef<File> $configDirFile;
                    final /* synthetic */ Ref.ObjectRef<File> $configFile;
                    final /* synthetic */ String $content;
                    {
                        this.this$0 = $receiver;
                        this.$configDirFile = $configDirFile;
                        this.$configFile = $configFile;
                        this.$content = $content;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                String string = KubernetesConfigFileManager.access$getProject$p(this.this$0).getBasePath();
                                if (string == null) {
                                    throw new IOException("Project base path is null");
                                }
                                String projectBasePath = string;
                                String configDirPath = projectBasePath + "/.idea/kubernetes/configs";
                                this.$configDirFile.element = new File(configDirPath);
                                if (!((File)this.$configDirFile.element).exists()) {
                                    ((File)this.$configDirFile.element).mkdirs();
                                }
                                String timestamp = LocalDateTime.now().format(KubernetesConfigFileManager.access$getDATE_FORMAT$cp());
                                String random = StringsKt.padStart((String)String.valueOf(RangesKt.random((IntRange)new IntRange(1, 999), (Random)((Random)Random.Default))), (int)3, (char)'0');
                                String fileName = "kubeconfig_" + timestamp + "_" + random + ".yaml";
                                this.$configFile.element = new File((File)this.$configDirFile.element, fileName);
                                FilesKt.writeText$default((File)((File)this.$configFile.element), (String)this.$content, null, (int)2, null);
                                return this.$configFile.element;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var7_5) goto lbl23
lbl22:
                // 1 sources

                return var7_5;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                configFile = (Ref.ObjectRef)$continuation.L$2;
                configDirFile = (Ref.ObjectRef)$continuation.L$1;
                content = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)configDirFile.element);
                    var3_6 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)configFile.element);
                }
                catch (IOException e) {
                    KubernetesConfigFileManager.LOG.warn("Failed to save config file", (Throwable)e);
                    var3_6 = null;
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getStoredConfigFiles(@NotNull Continuation<? super List<? extends VirtualFile>> $completion) {
        if (!($completion instanceof getStoredConfigFiles.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesConfigFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getStoredConfigFiles((Continuation<? super List<? extends VirtualFile>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends VirtualFile>>, Object>(this, null){
                    int label;
                    final /* synthetic */ KubernetesConfigFileManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$filterTo$iv$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                String string = KubernetesConfigFileManager.access$getProject$p(this.this$0).getBasePath();
                                if (string == null) {
                                    return CollectionsKt.emptyList();
                                }
                                String projectBasePath = string;
                                String configDirPath = projectBasePath + "/.idea/kubernetes/configs";
                                File configDirFile = new File(configDirPath);
                                if (!configDirFile.exists()) {
                                    return CollectionsKt.emptyList();
                                }
                                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configDirFile);
                                if (virtualFile == null) {
                                    return CollectionsKt.emptyList();
                                }
                                VirtualFile configDir = virtualFile;
                                VirtualFile[] virtualFileArray = configDir.getChildren();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                                Object[] $this$filter$iv = virtualFileArray;
                                boolean $i$f$filter = false;
                                Object[] objectArray = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (void element$iv$iv : $this$filterTo$iv$iv) {
                                    VirtualFile it = (VirtualFile)element$iv$iv;
                                    boolean bl = false;
                                    if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"yaml") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"yml"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends VirtualFile>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var6_4) goto lbl18
lbl17:
                // 1 sources

                return var6_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var2_5 = (List)v0;
                }
                catch (Exception e) {
                    KubernetesConfigFileManager.LOG.warn("Failed to get stored config files", (Throwable)e);
                    return CollectionsKt.emptyList();
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object cleanupStoredConfigFiles(@NotNull Set<? extends VirtualFile> configs, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cleanupStoredConfigFiles.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesConfigFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cleanupStoredConfigFiles(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = configs;
                $continuation.label = 1;
                v0 = this.getStoredConfigFiles((Continuation<? super List<? extends VirtualFile>>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                configs = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((storedFiles = (List)v0).isEmpty()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configs);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)storedFiles);
                $continuation.label = 2;
                v1 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, cleanupStoredConfigFiles$lambda$0(java.util.List java.util.Set com.intellij.kubernetes.api.settings.KubernetesConfigFileManager ), ()Lkotlin/Unit;)((List)storedFiles, (Set)configs, (KubernetesConfigFileManager)this), (Continuation)$continuation);
                ** if (v1 != var6_5) goto lbl34
lbl33:
                // 1 sources

                return var6_5;
lbl34:
                // 1 sources

                ** GOTO lbl45
            }
            case 2: {
                storedFiles = (List)$continuation.L$1;
                configs = (Set)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Exception e) {
                    KubernetesConfigFileManager.LOG.warn("Failed to cleanup stored config files", (Throwable)e);
                }
lbl45:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit cleanupStoredConfigFiles$lambda$0(List $storedFiles, Set $configs, KubernetesConfigFileManager this$0) {
        Iterable $this$forEach$iv = $storedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl = false;
            if ($configs.contains(file)) continue;
            try {
                file.delete((Object)this$0);
                LOG.info("Removed unused config file: " + file.getPath());
            }
            catch (IOException e) {
                LOG.warn("Failed to remove config file: " + file.getPath(), (Throwable)e);
            }
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final KubernetesConfigFileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesConfigFileManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ DateTimeFormatter access$getDATE_FORMAT$cp() {
        return DATE_FORMAT;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesConfigFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CONFIG_DIR", "", "DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesConfigFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,118:1\n30#2,2:119\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion\n*L\n25#1:119,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesConfigFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesConfigFileManager> serviceClass$iv = KubernetesConfigFileManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesConfigFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

