/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.connectivity.dataSource.BasicDataSourceManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbCustomTypeImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbForeignKeyImpl;
import com.intellij.database.psi.DbIndexImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbObjectAttributeImpl;
import com.intellij.database.psi.DbObjectImpl;
import com.intellij.database.psi.DbOperatorImpl;
import com.intellij.database.psi.DbPackageImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutineImpl;
import com.intellij.database.psi.DbSchemaChildImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.DbTableKeyImpl;
import com.intellij.database.psi.DbTableTypeImpl;
import com.intellij.database.psi.DbTriggerImpl;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.psi.ModelNameIndexImpl;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class DbDataSourceImpl
extends DbElementImpl<RawDataSource>
implements DbDataSource {
    private static final Key<Object> LAST_DS_INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");
    private final Project myProject;
    private final BasicDataSourceManager<RawDataSource> myManager;
    private final SynchronizedClearableLazy<Pair<DatabaseDialectEx, Language>> myDialects;
    private final Map<DasObject, DbElement> myElements;
    private final Map<ObjectPath, List<DasObject>> myQNames;
    private final SimpleModificationTracker myTracker;

    public DbDataSourceImpl(@NotNull Project project, @NotNull RawDataSource dataSource, @NotNull DataSourceManager<RawDataSource> manager) {
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DbDataSourceImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DbDataSourceImpl.$$$reportNull$$$0(2);
        }
        super(dataSource);
        this.myDialects = new SynchronizedClearableLazy(this::calcDialects);
        this.myElements = CollectionFactory.createConcurrentWeakKeyWeakValueIdentityMap();
        this.myQNames = ConcurrentFactoryMap.create(this::findElementImpl, ContainerUtil::createConcurrentSoftValueMap);
        this.myTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myManager = (BasicDataSourceManager)manager;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTracker;
        if (simpleModificationTracker == null) {
            DbDataSourceImpl.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public boolean isLoading() {
        return this.myManager.isLoading((RawDataSource)this.myDelegate);
    }

    @NotNull
    public Promise<?> getLoadingPromise() {
        Promise<?> promise = this.myManager.getLoadingPromise((RawDataSource)this.myDelegate);
        if (promise == null) {
            DbDataSourceImpl.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    public RawDataSource getDelegateDataSource() {
        RawDataSource rawDataSource = (RawDataSource)this.myDelegate;
        if (rawDataSource == null) {
            DbDataSourceImpl.$$$reportNull$$$0(5);
        }
        return rawDataSource;
    }

    public boolean isQuoted() {
        return true;
    }

    public boolean isValid() {
        if (this.getProject().isDisposed()) {
            return false;
        }
        long current = DbPsiFacade.getInstance((Project)this.getProject()).getModificationCount();
        if (current == this.myTransactionalVersion) {
            return true;
        }
        if (!this.myManager.containsDataSource((RawDataSource)this.getDelegate())) {
            return false;
        }
        this.myTransactionalVersion = current;
        return true;
    }

    public void clearCaches() {
        this.myQNames.clear();
        this.myDialects.drop();
        Throwable trace = new Throwable("DbDataSource.clearCaches");
        LAST_DS_INVALIDATION_TRACE.set((UserDataHolder)this, (Object)trace);
        if (!this.isValid()) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)this, (Object)trace);
        }
        this.myTracker.incModificationCount();
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = ((RawDataSource)this.myDelegate).getDbms();
        if (dbms == null) {
            DbDataSourceImpl.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @Nullable
    public Version getVersion() {
        return ((RawDataSource)this.myDelegate).getVersion();
    }

    @NotNull
    public DataSourceManager<RawDataSource> getDbManager() {
        BasicDataSourceManager<RawDataSource> basicDataSourceManager = this.myManager;
        if (basicDataSourceManager == null) {
            DbDataSourceImpl.$$$reportNull$$$0(7);
        }
        return basicDataSourceManager;
    }

    @Override
    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl dbDataSourceImpl = this;
        if (dbDataSourceImpl == null) {
            DbDataSourceImpl.$$$reportNull$$$0(8);
        }
        return dbDataSourceImpl;
    }

    @Nullable
    public String getComment() {
        return ((RawDataSource)this.myDelegate).getComment();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getQueryLanguage();
        if (language == null) {
            DbDataSourceImpl.$$$reportNull$$$0(9);
        }
        return language;
    }

    public boolean isWritable() {
        RawDataSource dataSource = this.getDataSource().getDelegateDataSource();
        return !(dataSource instanceof DatabaseConnectionPoint) || !((DatabaseConnectionPoint)dataSource).isReadOnly();
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((RawDataSource)this.myDelegate).getName();
        if (string == null) {
            DbDataSourceImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public DbElement getParent() {
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            DbDataSourceImpl.$$$reportNull$$$0(11);
        }
        this.myManager.renameDataSource((RawDataSource)this.getDelegate(), name);
        return this;
    }

    @NotNull
    public String getUniqueId() {
        String string = ((RawDataSource)this.myDelegate).getUniqueId();
        if (string == null) {
            DbDataSourceImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = ((RawDataSource)this.myDelegate).getDatabaseVersion();
        if (nameVersion == null) {
            DbDataSourceImpl.$$$reportNull$$$0(13);
        }
        return nameVersion;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            DbDataSourceImpl.$$$reportNull$$$0(14);
        }
        return objectKind;
    }

    @Nullable
    public Icon getBaseIcon() {
        return ((RawDataSource)this.myDelegate).getIcon(0);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.getBaseIcon();
    }

    public PsiFile getContainingFile() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(15);
        }
        return project;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return ((RawDataSource)this.myDelegate).getConnectionConfig();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        this.checkValid();
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)((Pair)this.myDialects.getValue()).first;
        if (databaseDialectEx == null) {
            DbDataSourceImpl.$$$reportNull$$$0(16);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Language getQueryLanguage() {
        this.checkValid();
        Language language = (Language)((Pair)this.myDialects.getValue()).second;
        if (language == null) {
            DbDataSourceImpl.$$$reportNull$$$0(17);
        }
        return language;
    }

    @Nullable
    public Language getCachedQueryLanguage() {
        return this.myDialects.isInitialized() ? (Language)((Pair)this.myDialects.getValue()).second : null;
    }

    @Nullable
    public Language getPushedQueryLanguage() {
        return this.myManager.getPushedQueryLanguage((RawDataSource)this.myDelegate);
    }

    @NotNull
    private Pair<DatabaseDialectEx, Language> calcDialects() {
        Language ql = (Language)ObjectUtils.notNull((Object)this.myManager.getQueryLanguage((RawDataSource)this.getDelegate()), (Object)SqlDialects.getGenericDialect());
        DatabaseDialectEx db = (DatabaseDialectEx)ObjectUtils.notNull((Object)this.myManager.getDatabaseDialect((RawDataSource)this.getDelegate()), (Object)DatabaseDialects.getGenericDialect());
        Pair pair = Pair.create((Object)db, (Object)ql);
        if (pair == null) {
            DbDataSourceImpl.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    public DasModel getModel() {
        this.checkValid();
        DasModel dasModel = Objects.requireNonNull((RawDataSource)this.getDelegate()).getModel();
        if (dasModel == null) {
            DbDataSourceImpl.$$$reportNull$$$0(19);
        }
        return dasModel;
    }

    public <S> Function<DasObject, S> mapper() {
        return s -> this.findElement((DasObject)s);
    }

    private List<DasObject> findElementImpl(ObjectPath key) {
        return (List)QNameUtil.findByPath((Project)this.getProject(), (DasModel)this.getModel(), (ObjectPath)key, p2 -> JBIterable.from((Iterable)this.myQNames.get(p2))).addAllTo((Collection)new SmartList());
    }

    @Contract(value="null->null")
    public DbElement findElement(@Nullable DasObject o) {
        if (o == null || o instanceof DbElement) {
            return (DbElement)o;
        }
        if (!((RawDataSource)this.myDelegate).getModel().contains(o)) {
            return null;
        }
        if (o instanceof BasicRoot) {
            return this;
        }
        return this.myElements.computeIfAbsent(o, this::createDbElement);
    }

    @NotNull
    private DbElement createDbElement(@NotNull DasObject dasElement) {
        DbDataSourceImpl parent;
        if (dasElement == null) {
            DbDataSourceImpl.$$$reportNull$$$0(20);
        }
        ObjectKind kind = dasElement.getKind();
        DasObject dasParent = dasElement.getDasParent();
        DbDataSourceImpl dbDataSourceImpl = parent = dasParent == null ? this : this.findElement(dasParent);
        DbObjectImpl element = DbImplUtilCore.isNamespace((ObjectKind)kind) ? new DbNamespaceImpl(parent, dasElement) : (dasElement instanceof DasUserDefinedType ? (kind == ObjectKind.TABLE_TYPE ? new DbTableTypeImpl(parent, (DasUserDefinedType)dasElement) : new DbCustomTypeImpl(parent, (DasUserDefinedType)dasElement)) : (dasElement instanceof DasRoutine ? new DbRoutineImpl(parent, (DasRoutine)dasElement) : (dasElement instanceof DasOperator ? new DbOperatorImpl(parent, (DasOperator)dasElement) : (dasElement instanceof DasTable ? new DbTableImpl(parent, (DasTable)dasElement) : (kind == ObjectKind.COLUMN && dasElement instanceof DasColumn && parent instanceof DbTable ? new DbColumnImpl((DbTable)parent, (DasColumn)dasElement) : (kind == ObjectKind.COLUMN && dasElement instanceof DasTypedObject ? new DbObjectAttributeImpl(parent, (DasTypedObject)dasElement) : (kind == ObjectKind.OBJECT_ATTRIBUTE && dasElement instanceof DasTypedObject ? new DbObjectAttributeImpl(parent, (DasTypedObject)dasElement) : (kind == ObjectKind.KEY && dasElement instanceof DasTableKey && parent instanceof DbTable ? new DbTableKeyImpl((DbTable)parent, (DasTableKey)dasElement) : (kind == ObjectKind.FOREIGN_KEY && dasElement instanceof DasForeignKey && parent instanceof DbTable ? new DbForeignKeyImpl((DbTable)parent, (DasForeignKey)dasElement) : (kind == ObjectKind.INDEX && dasElement instanceof DasIndex && parent instanceof DbTable ? new DbIndexImpl((DbTable)parent, (DasIndex)dasElement) : (kind == ObjectKind.PACKAGE ? new DbPackageImpl(parent, dasElement) : ((kind == ObjectKind.RULE || kind == ObjectKind.TRIGGER) && dasElement instanceof DasTrigger && parent instanceof DbTable ? new DbTriggerImpl((DbTable)parent, (DasTrigger)dasElement) : (dasElement instanceof DasSynonym ? new DbSynonymImpl(parent, (DasSynonym)dasElement) : (dasElement instanceof DasSchemaChild ? new DbSchemaChildImpl(parent, (DasSchemaChild)dasElement) : new DbObjectImpl<DasObject, DbDataSourceImpl>(parent, dasElement)))))))))))))));
        DbNamespaceImpl dbNamespaceImpl = element;
        if (dbNamespaceImpl == null) {
            DbDataSourceImpl.$$$reportNull$$$0(21);
        }
        return dbNamespaceImpl;
    }

    @Nullable
    public DbElement findElement(@NotNull ObjectPath path) {
        if (path == null) {
            DbDataSourceImpl.$$$reportNull$$$0(22);
        }
        this.checkValid();
        DasObject o = (DasObject)ContainerUtil.getFirstItem(this.myQNames.get(path));
        return o == null ? null : this.findElement(o);
    }

    @NotNull
    public JBIterable<DasObject> findObjects(@NotNull ObjectPath path) {
        if (path == null) {
            DbDataSourceImpl.$$$reportNull$$$0(23);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)this.myQNames.get(path));
        if (jBIterable == null) {
            DbDataSourceImpl.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<DbElement> findChildren(@NotNull DbElement element) {
        JBIterable children;
        if (element == null) {
            DbDataSourceImpl.$$$reportNull$$$0(25);
        }
        this.checkValid();
        Object delegate = element.getDelegate();
        if (element == this) {
            children = this.getModel().getModelRoots();
        } else if (delegate instanceof DasObject) {
            children = ((DasObject)delegate).getDasChildren(null);
        } else {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbDataSourceImpl.$$$reportNull$$$0(26);
            }
            return jBIterable;
        }
        JBIterable jBIterable = children.map(o -> this.findElement((DasObject)o));
        if (jBIterable == null) {
            DbDataSourceImpl.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    boolean isValidImpl(DbObjectImpl<?, ?> e) {
        long count = DbPsiFacade.getInstance((Project)this.getProject()).getModificationCount();
        if (e.myTransactionalVersion == count) {
            return true;
        }
        if (this.isValid()) {
            DasModel model = ((RawDataSource)this.getDelegate()).getModel();
            DasObject delegate = (DasObject)e.getDelegate();
            if (this.isValid(delegate) && model.contains(delegate)) {
                e.myTransactionalVersion = count;
                return true;
            }
        }
        if (PsiInvalidElementAccessException.getInvalidationTrace(e) == null) {
            PsiInvalidElementAccessException.setInvalidationTrace(e, (Object)LAST_DS_INVALIDATION_TRACE.get((UserDataHolder)this));
        }
        return false;
    }

    private boolean isValid(DasObject delegate) {
        BasicModElement basic = (BasicModElement)ObjectUtils.tryCast((Object)delegate, BasicModElement.class);
        if (basic != null) {
            return !basic.isDropped();
        }
        if (!(delegate instanceof BasicNode)) {
            return true;
        }
        return ((DvTreeStructureService)this.getProject().getService(DvTreeStructureService.class)).isValid((BasicNode)delegate);
    }

    @NotNull
    public ModelNameIndex getNameIndex() {
        DasModel model = this.getModel();
        ModelNameIndex modelNameIndex = model instanceof BaseModel ? ((BaseModel)model).getNameIndex() : ModelNameIndexImpl.EMPTY_INDEX;
        if (modelNameIndex == null) {
            DbDataSourceImpl.$$$reportNull$$$0(28);
        }
        return modelNameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 21, 24, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDialects";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildren";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDbElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 21, 24, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

