/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.search.PolySymbolSearchTarget;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.VueScopeElementSymbol;
import org.jetbrains.vuejs.model.source.VueCompositionContainer;
import org.jetbrains.vuejs.web.PolySymbolsUtilsKt;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H&J(\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H&J\u0010\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000%H&R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006&\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/vuejs/model/VueNamedComponent;", "Lorg/jetbrains/vuejs/model/VueComponent;", "Lorg/jetbrains/vuejs/model/VueScopeElementSymbol;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getPresentation", "()Lcom/intellij/platform/backend/presentation/TargetPresentation;", "searchTarget", "Lcom/intellij/polySymbols/search/PolySymbolSearchTarget;", "getSearchTarget", "()Lcom/intellij/polySymbols/search/PolySymbolSearchTarget;", "priority", "Lcom/intellij/polySymbols/PolySymbol$Priority;", "getPriority", "()Lcom/intellij/polySymbols/PolySymbol$Priority;", "delegate", "getDelegate", "()Lorg/jetbrains/vuejs/model/VueComponent;", "withVueProximity", "proximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "get", "T", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.vuejs.backend"})
public interface VueNamedComponent
extends VueComponent,
VueScopeElementSymbol {
    @NotNull
    default public PolySymbolKind getKind() {
        return VueSymbolQueryConfiguratorKt.getVUE_COMPONENTS();
    }

    @NotNull
    default public TargetPresentation getPresentation() {
        Object[] objectArray = new Object[]{this.getName()};
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(VueBundle.message((String)"vue.documentation.type.component", (Object[])objectArray)).icon(this.getIcon()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    default public PolySymbolSearchTarget getSearchTarget() {
        return PolySymbolSearchTarget.Companion.create((PolySymbol)this);
    }

    @Nullable
    default public PolySymbol.Priority getPriority() {
        VueModelVisitor.Proximity proximity = this.getVueProximity();
        return proximity != null ? PolySymbolsUtilsKt.asPolySymbolPriority(proximity) : null;
    }

    @Nullable
    public VueComponent getDelegate();

    @Override
    @NotNull
    public VueNamedComponent withVueProximity(@NotNull VueModelVisitor.Proximity var1);

    @Override
    @Nullable
    default public <T> T get(@NotNull PolySymbolProperty<T> property) {
        Object object;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        PolySymbolProperty<T> polySymbolProperty = property;
        if (Intrinsics.areEqual(polySymbolProperty, VueSymbolQueryConfiguratorKt.getPROP_VUE_PROXIMITY())) {
            VueModelVisitor.Proximity proximity = this.getVueProximity();
            Intrinsics.checkNotNull((Object)((Object)proximity), (String)"null cannot be cast to non-null type T of org.jetbrains.vuejs.model.VueNamedComponent.get");
            object = (Object)proximity;
        } else {
            object = Intrinsics.areEqual(polySymbolProperty, VueSymbolQueryConfiguratorKt.getPROP_VUE_COMPOSITION_COMPONENT()) ? (Object)VueCompositionContainer.Companion.isCompositionAppComponent(this) : null;
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project var1);

    @NotNull
    public Pointer<? extends VueNamedComponent> createPointer();
}

