/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.model.Pointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueFilter;
import org.jetbrains.vuejs.model.VueGlobalImpl;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.VueScopeElementSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceFilter;", "Lorg/jetbrains/vuejs/model/VueFilter;", "name", "", "originalSource", "Lcom/intellij/psi/PsiElement;", "vueProximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;)V", "getName", "()Ljava/lang/String;", "getVueProximity", "()Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "source", "getSource", "()Lcom/intellij/psi/PsiElement;", "withVueProximity", "Lorg/jetbrains/vuejs/model/VueScopeElementSymbol;", "proximity", "createPointer", "Lcom/intellij/model/Pointer;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueSourceFilter
implements VueFilter {
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement originalSource;
    @Nullable
    private final VueModelVisitor.Proximity vueProximity;

    public VueSourceFilter(@NotNull String name, @NotNull PsiElement originalSource, @Nullable VueModelVisitor.Proximity vueProximity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        this.name = name;
        this.originalSource = originalSource;
        this.vueProximity = vueProximity;
    }

    public /* synthetic */ VueSourceFilter(String string, PsiElement psiElement, VueModelVisitor.Proximity proximity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            proximity = null;
        }
        this(string, psiElement, proximity);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public VueModelVisitor.Proximity getVueProximity() {
        return this.vueProximity;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return VueGlobalImpl.Companion.getParents(this);
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        PsiElement psiElement = this.originalSource;
        PsiReference psiReference = psiElement instanceof PsiReference ? (PsiReference)psiElement : null;
        if (psiReference == null || (psiReference = psiReference.resolve()) == null) {
            psiReference = this.originalSource;
        }
        return psiReference;
    }

    @Override
    @NotNull
    public VueScopeElementSymbol withVueProximity(@NotNull VueModelVisitor.Proximity proximity) {
        Intrinsics.checkNotNullParameter((Object)((Object)proximity), (String)"proximity");
        return new VueSourceFilter(this.getName(), this.originalSource, proximity);
    }

    @NotNull
    public Pointer<VueSourceFilter> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer originalSourcePtr = SmartPointersKt.createSmartPointer((PsiElement)this.originalSource);
        return () -> VueSourceFilter.createPointer$lambda$0(name, originalSourcePtr);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final PsiElement component2() {
        return this.originalSource;
    }

    @Nullable
    public final VueModelVisitor.Proximity component3() {
        return this.vueProximity;
    }

    @NotNull
    public final VueSourceFilter copy(@NotNull String name, @NotNull PsiElement originalSource, @Nullable VueModelVisitor.Proximity vueProximity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        return new VueSourceFilter(name, originalSource, vueProximity);
    }

    public static /* synthetic */ VueSourceFilter copy$default(VueSourceFilter vueSourceFilter, String string, PsiElement psiElement, VueModelVisitor.Proximity proximity, int n, Object object) {
        if ((n & 1) != 0) {
            string = vueSourceFilter.name;
        }
        if ((n & 2) != 0) {
            psiElement = vueSourceFilter.originalSource;
        }
        if ((n & 4) != 0) {
            proximity = vueSourceFilter.vueProximity;
        }
        return vueSourceFilter.copy(string, psiElement, proximity);
    }

    @NotNull
    public String toString() {
        return "VueSourceFilter(name=" + this.name + ", originalSource=" + this.originalSource + ", vueProximity=" + this.vueProximity + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.originalSource.hashCode();
        result = result * 31 + (this.vueProximity == null ? 0 : this.vueProximity.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VueSourceFilter)) {
            return false;
        }
        VueSourceFilter vueSourceFilter = (VueSourceFilter)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)vueSourceFilter.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalSource, (Object)vueSourceFilter.originalSource)) {
            return false;
        }
        return this.vueProximity == vueSourceFilter.vueProximity;
    }

    private static final VueSourceFilter createPointer$lambda$0(String $name, SmartPsiElementPointer $originalSourcePtr) {
        PsiElement psiElement = $originalSourcePtr.dereference();
        if (psiElement == null) {
            return null;
        }
        return new VueSourceFilter($name, psiElement, null, 4, null);
    }
}

