/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.model.Pointer;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueSlot;
import org.jetbrains.vuejs.types.VueSourceSlotScopeType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0082\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceSlot;", "Lorg/jetbrains/vuejs/model/VueSlot;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "name", "", "source", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/xml/XmlTag;)V", "getName", "()Ljava/lang/String;", "getSource", "()Lcom/intellij/psi/xml/XmlTag;", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "intellij.vuejs.backend"})
final class VueSourceSlot
implements VueSlot,
PsiSourcedPolySymbol {
    @NotNull
    private final String name;
    @NotNull
    private final XmlTag source;

    public VueSourceSlot(@NotNull String name, @NotNull XmlTag source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.name = name;
        this.source = source;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public XmlTag getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public JSType getType() {
        return (JSType)new VueSourceSlotScopeType(this.getSource(), this.getName());
    }

    @NotNull
    public Pointer<VueSourceSlot> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer sourcePtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.getSource()));
        return () -> VueSourceSlot.createPointer$lambda$0(sourcePtr, name);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceSlot && Intrinsics.areEqual((Object)((VueSourceSlot)other).getName(), (Object)this.getName()) && Intrinsics.areEqual((Object)((VueSourceSlot)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSource().hashCode();
        return result;
    }

    private static final VueSourceSlot createPointer$lambda$0(SmartPsiElementPointer $sourcePtr, String $name) {
        XmlTag xmlTag = (XmlTag)$sourcePtr.dereference();
        if (xmlTag == null) {
            return null;
        }
        XmlTag source = xmlTag;
        return new VueSourceSlot($name, source);
    }
}

