/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildProgressObservable;
import com.intellij.build.BuildViewProblemsService;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0017B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager;", "Lcom/intellij/build/ViewManager;", "Lcom/intellij/build/BuildProgressListener;", "Lcom/intellij/build/BuildProgressObservable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "isConsoleEnabledByDefault", "", "isBuildContentView", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "onEvent", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemRunConfigurationViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemRunConfigurationViewManager.kt\ncom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n30#2,2:46\n13#3:48\n*S KotlinDebug\n*F\n+ 1 ExternalSystemRunConfigurationViewManager.kt\ncom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager\n*L\n24#1:46,2\n43#1:48\n*E\n"})
public final class ExternalSystemRunConfigurationViewManager
implements ViewManager,
BuildProgressListener,
BuildProgressObservable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DisposableWrapperList<BuildProgressListener> listeners;
    @NotNull
    private static final Logger logger;

    public ExternalSystemRunConfigurationViewManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.listeners = new DisposableWrapperList();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<BuildViewProblemsService> serviceClass$iv = BuildViewProblemsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((BuildViewProblemsService)object).listenToBuildView((BuildProgressObservable)this);
    }

    public boolean isConsoleEnabledByDefault() {
        return true;
    }

    public boolean isBuildContentView() {
        return false;
    }

    public void addListener(@NotNull BuildProgressListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.listeners.add((Object)listener2, disposable);
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterator iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BuildProgressListener listener2 = (BuildProgressListener)iterator2.next();
            try {
                listener2.onEvent(buildId, event);
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExternalSystemRunConfigurationViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ExternalSystemRunConfigurationViewManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

