/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.notification.NotificationType;
import org.jetbrains.annotations.NotNull;

public enum NotificationCategory {
    ERROR(4),
    INFO(3),
    SIMPLE(1),
    WARNING(5);

    private final int myValue;

    private NotificationCategory(int value) {
        this.myValue = value;
    }

    public int getMessageCategory() {
        return this.myValue;
    }

    @NotNull
    public NotificationType getNotificationType() {
        NotificationType notificationType = NotificationCategory.convert(this);
        if (notificationType == null) {
            NotificationCategory.$$$reportNull$$$0(0);
        }
        return notificationType;
    }

    public static NotificationType convert(NotificationCategory notificationCategory) {
        return switch (notificationCategory.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NotificationType.ERROR;
            case 1, 2 -> NotificationType.INFORMATION;
            case 3 -> NotificationType.WARNING;
        };
    }

    public static NotificationCategory convert(NotificationType notificationType) {
        return switch (notificationType) {
            case NotificationType.INFORMATION -> INFO;
            case NotificationType.WARNING -> WARNING;
            case NotificationType.ERROR -> ERROR;
            default -> SIMPLE;
        };
    }

    public static NotificationCategory convert(int type) {
        return switch (type) {
            case 4 -> ERROR;
            case 5 -> WARNING;
            case 2, 3, 6 -> INFO;
            case 1 -> SIMPLE;
            default -> SIMPLE;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationCategory", "getNotificationType"));
    }
}

