/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.entities.source.Angular2SourceUtil;
import org.angular2.inspections.quickfixes.Angular2FixesFactory;
import org.angular2.inspections.quickfixes.CreateComponentFieldIntentionAction;
import org.angular2.inspections.quickfixes.CreateComponentMethodIntentionAction;
import org.angular2.inspections.quickfixes.CreateComponentSignalIntentionAction;
import org.angular2.inspections.quickfixes.CreateDirectiveOutputIntentionAction;
import org.angular2.lang.expr.Angular2ExprDialect;
import org.angular2.lang.expr.psi.Angular2Action;
import org.angular2.lang.expr.psi.Angular2EmbeddedExpression;
import org.angular2.lang.expr.psi.Angular2PipeReferenceExpression;
import org.angular2.signals.Angular2SignalUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/angular2/inspections/Angular2UnresolvedReferenceErrorUpdater;", "Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater;", "<init>", "()V", "updateError", "", "info", "Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater$ErrorInfo;", "node", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "resolveResults", "", "Lcom/intellij/psi/ResolveResult;", "isTypeContext", "", "(Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater$ErrorInfo;Lcom/intellij/lang/javascript/psi/JSReferenceExpression;[Lcom/intellij/psi/ResolveResult;Z)V", "addCreateFromUsageFixesInAngularExpression", "expression", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.angular.backend"})
@SourceDebugExtension(value={"SMAP\nAngular2UnresolvedReferenceErrorUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Angular2UnresolvedReferenceErrorUpdater.kt\norg/angular2/inspections/Angular2UnresolvedReferenceErrorUpdater\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,73:1\n66#2,2:74\n*S KotlinDebug\n*F\n+ 1 Angular2UnresolvedReferenceErrorUpdater.kt\norg/angular2/inspections/Angular2UnresolvedReferenceErrorUpdater\n*L\n64#1:74,2\n*E\n"})
public final class Angular2UnresolvedReferenceErrorUpdater
implements JSUnresolvedReferenceErrorUpdater {
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, @NotNull ResolveResult[] resolveResults, boolean isTypeContext) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
        if (node instanceof Angular2PipeReferenceExpression) {
            ((JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl)info).removeIf(Angular2UnresolvedReferenceErrorUpdater::updateError$lambda$0);
            SmartList myFixes = new SmartList();
            Angular2FixesFactory.addUnresolvedDeclarationFixes((PsiElement)node, (List)myFixes);
            ((JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl)info).addAll((Collection)myFixes);
        } else if (node.getLanguage() instanceof Angular2ExprDialect) {
            List quickFixes = new ArrayList();
            if (resolveResults.length == 0 && this.addCreateFromUsageFixesInAngularExpression(node, quickFixes) && !isTypeContext) {
                ((JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl)info).removeIf(Angular2UnresolvedReferenceErrorUpdater::updateError$lambda$1);
            }
            info.addAll((Collection)quickFixes);
        }
    }

    private final boolean addCreateFromUsageFixesInAngularExpression(JSReferenceExpression expression, List<? super LocalQuickFix> quickFixes) {
        JSExpression qualifier = expression.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            TypeScriptClass componentClass = Angular2SourceUtil.findComponentClass((PsiElement)expression);
            if (componentClass != null && expression.getReferenceName() != null) {
                if (expression.getParent() instanceof JSCallExpression) {
                    quickFixes.add((LocalQuickFix)new CreateComponentMethodIntentionAction(expression));
                    if (Angular2SignalUtils.INSTANCE.supportsSignals((PsiElement)componentClass)) {
                        quickFixes.add((LocalQuickFix)new CreateComponentSignalIntentionAction(expression));
                    }
                } else {
                    quickFixes.add((LocalQuickFix)new CreateComponentFieldIntentionAction(expression));
                    PsiElement $this$parentOfType_u24default$iv = (PsiElement)expression;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, Angular2EmbeddedExpression.class, (boolean)true) instanceof Angular2Action) {
                        String string = expression.getReferenceName();
                        Intrinsics.checkNotNull((Object)string);
                        quickFixes.add((LocalQuickFix)new CreateDirectiveOutputIntentionAction(expression, string));
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static final boolean updateError$lambda$0(LocalQuickFix it) {
        return true;
    }

    private static final boolean updateError$lambda$1(LocalQuickFix it) {
        return it instanceof BaseCreateFix;
    }
}

