/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014JP\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010&*\u00020 H\u0002J&\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "likePredicate", "columnRef", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "getBestLikeOp", "Lcom/intellij/database/data/types/domain/LikeOpType;", "wantedLikeOp", "getIndices", "", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "c", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "table", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "getMode", "Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "SASIIndexMode", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassPredicatesHelper.kt\ncom/intellij/database/dialects/cassandra/CassPredicatesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n777#2:128\n873#2,2:129\n*S KotlinDebug\n*F\n+ 1 CassPredicatesHelper.kt\ncom/intellij/database/dialects/cassandra/CassPredicatesHelper\n*L\n74#1:128\n74#1:129,2\n*E\n"})
public final class CassPredicatesHelper
extends BasePredicatesHelper {
    public CassPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return super.equalsPredicate(column, value, op, quote, version, null);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!DbImplUtilCore.getDatabaseDialect((Dbms)this.getDbms()).getLikeSupport(version).isSupported(inUpdate)) {
            return null;
        }
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        Domain domain2 = domain;
        if (!(domain2 != null ? domain2.supports(OperationKt.LIKE_OPERATION) : false)) {
            return null;
        }
        LikeOpType likeOp = this.getBestLikeOp(columnRef, op.getLikeType());
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (PredicateOperation)op, arg_0 -> CassPredicatesHelper.likePredicate$lambda$0(columnRef, likeOp, value, this, arg_0));
    }

    private final LikeOpType getBestLikeOp(ColumnRef columnRef, LikeOpType wantedLikeOp) {
        BasicTableOrViewColumn dasColumn = PredicatesUtilKt.toBasicColumn((ColumnRef)columnRef);
        if (dasColumn == null) {
            return LikeOpType.MATCHES;
        }
        BasicTableOrViewColumn basicTableOrViewColumn = dasColumn;
        CassTableColumn cassTableColumn = basicTableOrViewColumn instanceof CassTableColumn ? (CassTableColumn)basicTableOrViewColumn : null;
        if (cassTableColumn == null) {
            return LikeOpType.MATCHES;
        }
        CassTableColumn column = cassTableColumn;
        CassTable cassTable = column.getTable();
        if (cassTable == null) {
            return LikeOpType.MATCHES;
        }
        CassTable t = cassTable;
        Collection<CassIndex> indices = this.getIndices(column, t);
        Object bestOp = LikeOpType.MATCHES;
        for (CassIndex index : indices) {
            Object currentBestOp;
            Object object = this.getMode(index);
            if (object == null || (object = object.getBestOp()) == null || (object = (LikeOpType)object.get(wantedLikeOp)) == null) {
                object = LikeOpType.MATCHES;
            }
            if ((currentBestOp = object) == wantedLikeOp) {
                return wantedLikeOp;
            }
            if (currentBestOp.compareTo((Enum)bestOp) >= 0) continue;
            bestOp = currentBestOp;
        }
        return bestOp;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CassIndex> getIndices(CassTableColumn c, CassTable table) {
        void $this$filterTo$iv$iv;
        ModNamingFamily<? extends CassIndex> modNamingFamily = table.getIndices();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getIndices(...)");
        Iterable $this$filter$iv = (Iterable)modNamingFamily;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CassIndex index = (CassIndex)element$iv$iv;
            boolean bl = false;
            if (!(index.getColumns().size() == 1 && Intrinsics.areEqual((Object)c.getName(), (Object)index.getColumns().get(0).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SASIIndexMode getMode(CassIndex $this$getMode) {
        if (!Intrinsics.areEqual((Object)$this$getMode.getClassName(), (Object)"org.apache.cassandra.index.sasi.SASIIndex")) {
            return null;
        }
        String string = $this$getMode.getOptions();
        if (string == null) {
            return SASIIndexMode.PREFIX;
        }
        String options = string;
        return StringUtil.containsIgnoreCase((String)options, (String)"'mode': 'contains'") ? SASIIndexMode.CONTAINS : (StringUtil.containsIgnoreCase((String)options, (String)"'mode': 'sparse'") ? SASIIndexMode.SPARSE : SASIIndexMode.PREFIX);
    }

    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null || (domain2 = domain2.getLogicType()) == null) {
            return null;
        }
        Domain type = domain2;
        return type == LogicalType.UUID || type == LogicalType.TEXT_UUID ? new FormatTester(false, false, CassPredicatesHelper::getFormatTester$lambda$0) : super.getFormatTester(columnRef, domain, version);
    }

    private static final Unit likePredicate$lambda$0(ColumnRef $columnRef, LikeOpType $likeOp, PredicateValue $value, CassPredicatesHelper this$0, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)$columnRef).space();
        DdlBuilder ddlBuilder = $likeOp == LikeOpType.MATCHES ? builder.symbol("=").space() : builder.keyword("LIKE").space();
        PredicatesUtilKt.value((DdlBuilder)builder, (PredicateValue)$value, (ColumnRef)$columnRef, (Dbms)this$0.getDbms(), (DbImplUtilCore.StringLiteralDecorator)$likeOp.getDecorator());
        return Unit.INSTANCE;
    }

    private static final FormatTestResult getFormatTester$lambda$0(String value) {
        FormatTestResult formatTestResult;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            formatTestResult = UUID.fromString(value) != null ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
        }
        catch (IllegalArgumentException e) {
            formatTestResult = FormatTestResult.NOT_MATCHED;
        }
        return formatTestResult;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "", "bestOp", "", "Lcom/intellij/database/data/types/domain/LikeOpType;", "<init>", "(Ljava/lang/String;ILjava/util/Map;)V", "getBestOp", "()Ljava/util/Map;", "PREFIX", "CONTAINS", "SPARSE", "intellij.database.dialects.cassandra"})
    private static final class SASIIndexMode
    extends Enum<SASIIndexMode> {
        @NotNull
        private final Map<LikeOpType, LikeOpType> bestOp;
        public static final /* enum */ SASIIndexMode PREFIX;
        public static final /* enum */ SASIIndexMode CONTAINS;
        public static final /* enum */ SASIIndexMode SPARSE;
        private static final /* synthetic */ SASIIndexMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SASIIndexMode(Map<LikeOpType, ? extends LikeOpType> bestOp) {
            this.bestOp = bestOp;
        }

        @NotNull
        public final Map<LikeOpType, LikeOpType> getBestOp() {
            return this.bestOp;
        }

        public static SASIIndexMode[] values() {
            return (SASIIndexMode[])$VALUES.clone();
        }

        public static SASIIndexMode valueOf(String value) {
            return Enum.valueOf(SASIIndexMode.class, value);
        }

        @NotNull
        public static EnumEntries<SASIIndexMode> getEntries() {
            return $ENTRIES;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.STARTS_WITH), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.STARTS_WITH), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)};
            PREFIX = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            pairArray = new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.CONTAINS), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.CONTAINS), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.ENDS_WITH), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)};
            CONTAINS = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            pairArray = new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)};
            SPARSE = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            $VALUES = sASIIndexModeArray = new SASIIndexMode[]{SASIIndexMode.PREFIX, SASIIndexMode.CONTAINS, SASIIndexMode.SPARSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

