/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.types;

import com.intellij.database.dialects.hivebase.types.HiveListType;
import com.intellij.database.dialects.hivebase.types.HiveMapType;
import com.intellij.database.dialects.hivebase.types.HiveStructType;
import com.intellij.database.dialects.hivebase.types.HiveTypeSystemKt;
import com.intellij.database.dialects.hivebase.types.HiveUnionType;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\f\u0010\u0011\u001a\u00020\t*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\t*\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J)\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\b\b\u0000\u0010\u0019*\u00020\u00012\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001bH\u0082\bJ!\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0082\bJ\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u0014\u0010&\u001a\u0006\u0012\u0002\b\u00030'*\u0006\u0012\u0002\b\u00030'H\u0002J\u0006\u0010(\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/hivebase/types/TypeParser;", "", "spec", "", "<init>", "(Ljava/lang/String;)V", "pos", "", "isEof", "", "()Z", "skipSpaces", "", "consume", "token", "token1", "token2", "isIdentStart", "", "isIdentPart", "consumeId", "consumeNumber", "default", "parseCommaList", "", "T", "parser", "Lkotlin/Function0;", "tryParseComplexType", "Lcom/intellij/database/types/DasType;", "prefix", "parseArrayType", "parseMapType", "parseUnionType", "parseStructType", "parseStructField", "Lcom/intellij/database/model/DasTypedObject;", "parsePrimitive", "parseTail", "Lcom/intellij/database/types/DasBuiltinType;", "parse", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/TypeParser\n*L\n1#1,325:1\n220#1,12:326\n220#1,12:338\n235#1,8:350\n235#1,8:358\n235#1,8:366\n235#1,8:374\n*S KotlinDebug\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/TypeParser\n*L\n261#1:326,12\n265#1:338,12\n319#1:350,8\n320#1:358,8\n321#1:366,8\n322#1:374,8\n*E\n"})
final class TypeParser {
    @NotNull
    private final String spec;
    private int pos;

    public TypeParser(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = ((Object)StringsKt.trim((CharSequence)spec)).toString();
    }

    public final boolean isEof() {
        return this.pos >= this.spec.length();
    }

    private final void skipSpaces() {
        while (!this.isEof() && CharsKt.isWhitespace((char)this.spec.charAt(this.pos))) {
            int n = this.pos;
            this.pos = n + 1;
        }
    }

    private final boolean consume(String token) {
        if (StringsKt.startsWith((String)this.spec, (String)token, (int)this.pos, (boolean)true)) {
            this.pos += token.length();
            return true;
        }
        return false;
    }

    private final boolean consume(String token1, String token2) {
        int current = this.pos;
        if (!this.consume(token1)) {
            return false;
        }
        this.skipSpaces();
        if (this.consume(token2)) {
            return true;
        }
        this.pos = current;
        return false;
    }

    private final boolean isIdentStart(char $this$isIdentStart) {
        char c = Character.toLowerCase($this$isIdentStart);
        return ('a' <= c ? c < '{' : false) || $this$isIdentStart == '_';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIdentPart(char $this$isIdentPart) {
        if (this.isIdentStart($this$isIdentPart)) return true;
        if ('0' > $this$isIdentPart) return false;
        if ($this$isIdentPart >= ':') return false;
        return true;
    }

    private final String consumeId() {
        if (this.isEof()) {
            return null;
        }
        int start = this.pos;
        if (!this.isIdentStart(this.spec.charAt(this.pos))) {
            return null;
        }
        int n = this.pos;
        this.pos = n + 1;
        while (!this.isEof() && this.isIdentPart(this.spec.charAt(this.pos))) {
            n = this.pos;
            this.pos = n + 1;
        }
        String string = this.spec.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final int consumeNumber(int n) {
        int start = this.pos;
        while (!this.isEof()) {
            int n2 = this.spec.charAt(this.pos);
            boolean bl = 48 <= n2 ? n2 < 58 : false;
            if (!bl) break;
            n2 = this.pos;
            this.pos = n2 + 1;
        }
        String string = this.spec.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String consumed = string;
        return ((CharSequence)consumed).length() > 0 ? Integer.parseInt(consumed) : n;
    }

    private final <T> List<T> parseCommaList(Function0<? extends T> parser) {
        boolean $i$f$parseCommaList = false;
        SmartList arguments = new SmartList();
        while (!this.isEof() && this.spec.charAt(this.pos) != '>') {
            int current = this.pos;
            Object[] objectArray = new Object[]{parser.invoke()};
            UtilKt.addAllIfNotNull((List)((List)arguments), (Object[])objectArray);
            this.skipSpaces();
            if (this.consume(",")) {
                this.skipSpaces();
                continue;
            }
            if (current != this.pos) continue;
            break;
        }
        return (List)arguments;
    }

    private final DasType tryParseComplexType(String prefix, Function0<? extends DasType> parser) {
        boolean $i$f$tryParseComplexType = false;
        if (this.consume(prefix, "<")) {
            this.skipSpaces();
            DasType type = (DasType)parser.invoke();
            this.skipSpaces();
            this.consume(">");
            return type;
        }
        return null;
    }

    private final DasType parseArrayType() {
        return (DasType)new HiveListType(this.parse());
    }

    private final DasType parseMapType() {
        DasType dasType;
        DasType keyType = this.parse();
        this.skipSpaces();
        if (this.consume(",")) {
            this.skipSpaces();
            dasType = this.parse();
        } else {
            dasType = (DasType)DasTypeSystemBase.UNKNOWN;
        }
        DasType valueType = dasType;
        this.skipSpaces();
        return (DasType)new HiveMapType(keyType, valueType);
    }

    private final DasType parseUnionType() {
        TypeParser this_$iv = this;
        boolean $i$f$parseCommaList = false;
        SmartList arguments$iv = new SmartList();
        while (!this_$iv.isEof() && this_$iv.spec.charAt(this_$iv.pos) != '>') {
            int current$iv = this_$iv.pos;
            Object[] objectArray = new Object[1];
            int n = 0;
            Object[] objectArray2 = objectArray;
            List list = (List)arguments$iv;
            boolean bl = false;
            DasType dasType = this.parse();
            objectArray2[n] = dasType;
            UtilKt.addAllIfNotNull((List)list, (Object[])objectArray);
            this_$iv.skipSpaces();
            if (this_$iv.consume(",")) {
                this_$iv.skipSpaces();
                continue;
            }
            if (current$iv != this_$iv.pos) continue;
        }
        List list = (List)arguments$iv;
        return (DasType)new HiveUnionType(list);
    }

    private final DasType parseStructType() {
        TypeParser this_$iv = this;
        boolean $i$f$parseCommaList = false;
        SmartList arguments$iv = new SmartList();
        while (!this_$iv.isEof() && this_$iv.spec.charAt(this_$iv.pos) != '>') {
            int current$iv = this_$iv.pos;
            Object[] objectArray = new Object[1];
            int n = 0;
            Object[] objectArray2 = objectArray;
            List list = (List)arguments$iv;
            boolean bl = false;
            DasTypedObject dasTypedObject = this.parseStructField();
            objectArray2[n] = dasTypedObject;
            UtilKt.addAllIfNotNull((List)list, (Object[])objectArray);
            this_$iv.skipSpaces();
            if (this_$iv.consume(",")) {
                this_$iv.skipSpaces();
                continue;
            }
            if (current$iv != this_$iv.pos) continue;
        }
        Iterable iterable = (List)arguments$iv;
        return (DasType)new HiveStructType(iterable);
    }

    private final DasTypedObject parseStructField() {
        String string = this.consumeId();
        if (string == null) {
            return null;
        }
        String id = string;
        this.skipSpaces();
        this.consume(":");
        this.skipSpaces();
        DasType type = this.parse();
        return new DasTypedObject(id, type){
            final /* synthetic */ String $id;
            final /* synthetic */ DasType $type;
            {
                this.$id = $id;
                this.$type = $type;
            }

            public boolean isNotNull() {
                return false;
            }

            public Void getDefault() {
                return null;
            }

            public String getName() {
                return this.$id;
            }

            public ObjectKind getKind() {
                return ObjectKind.COLUMN;
            }

            public boolean isQuoted() {
                return false;
            }

            public DasType getDasType() {
                return this.$type;
            }
        };
    }

    private final DasType parsePrimitive() {
        String string = this.consumeId();
        if (string == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        String id = string;
        Map map = HiveTypeSystemKt.access$getCaseInsensitiveTypes$p();
        String string2 = id.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        DasBuiltinType builtin = (DasBuiltinType)map.get(string2);
        if (builtin != null) {
            return (DasType)this.parseTail(builtin);
        }
        return (DasType)DasSimpleBuiltinType.Companion.of$default((DasSimpleBuiltinType.Companion)DasSimpleBuiltinType.Companion, (String)id, null, (int)2, null);
    }

    private final DasBuiltinType<?> parseTail(DasBuiltinType<?> $this$parseTail) {
        int size = -1;
        int scale = 0;
        if (this.consume("(")) {
            this.skipSpaces();
            size = this.consumeNumber(size);
            this.skipSpaces();
            if (this.consume(",")) {
                this.skipSpaces();
                scale = this.consumeNumber(scale);
                this.skipSpaces();
            }
            this.consume(")");
        }
        return HiveTypeSystemKt.access$adjust($this$parseTail, size, scale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DasType parse() {
        DasType dasType;
        DasType dasType2;
        void this_$iv;
        TypeParser typeParser = this;
        Object prefix$iv = "ARRAY";
        boolean $i$f$tryParseComplexType = false;
        if (super.consume((String)prefix$iv, "<")) {
            super.skipSpaces();
            boolean bl = false;
            DasType type$iv = this.parseArrayType();
            super.skipSpaces();
            super.consume(">");
            dasType2 = type$iv;
        } else {
            dasType2 = dasType = null;
        }
        if (dasType2 == null) {
            DasType dasType3;
            void this_$iv2;
            prefix$iv = this;
            Object prefix$iv2 = "MAP";
            boolean $i$f$tryParseComplexType2 = false;
            if (super.consume((String)prefix$iv2, "<")) {
                super.skipSpaces();
                boolean bl = false;
                DasType type$iv = this.parseMapType();
                super.skipSpaces();
                super.consume(">");
                dasType3 = type$iv;
            } else {
                dasType3 = dasType = null;
            }
            if (dasType3 == null) {
                DasType dasType4;
                void this_$iv3;
                prefix$iv2 = this;
                Object prefix$iv3 = "UNIONTYPE";
                boolean $i$f$tryParseComplexType3 = false;
                if (super.consume((String)prefix$iv3, "<")) {
                    super.skipSpaces();
                    boolean bl = false;
                    DasType type$iv = this.parseUnionType();
                    super.skipSpaces();
                    super.consume(">");
                    dasType4 = type$iv;
                } else {
                    dasType4 = dasType = null;
                }
                if (dasType4 == null) {
                    DasType dasType5;
                    void this_$iv4;
                    prefix$iv3 = this;
                    String prefix$iv4 = "STRUCT";
                    boolean $i$f$tryParseComplexType4 = false;
                    if (super.consume(prefix$iv4, "<")) {
                        super.skipSpaces();
                        boolean bl = false;
                        DasType type$iv = this.parseStructType();
                        super.skipSpaces();
                        super.consume(">");
                        dasType5 = type$iv;
                    } else {
                        dasType5 = dasType = null;
                    }
                    if (dasType5 == null) {
                        dasType = this.parsePrimitive();
                    }
                }
            }
        }
        return dasType;
    }
}

