/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse.psi;

import com.intellij.database.dialects.clickhouse.types.CHouseDateTime64Type;
import com.intellij.database.dialects.clickhouse.types.CHouseDateTimeType;
import com.intellij.database.dialects.clickhouse.types.CHouseTypeSystem;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlBuiltinTypeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/clickhouse/psi/CHouseBuiltinTypeElementImpl;", "Lcom/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "parseBuiltinTypeBase", "Lcom/intellij/database/types/DasType;", "adjustType", "Lcom/intellij/database/types/DasBuiltinType;", "dasType", "adjustDateTimeType", "Lcom/intellij/database/dialects/clickhouse/types/CHouseDateTimeType;", "adjustDateTime64Type", "Lcom/intellij/database/dialects/clickhouse/types/CHouseDateTime64Type;", "intellij.database.dialects.clickhouse"})
@SourceDebugExtension(value={"SMAP\nCHouseBuiltinTypeElementImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseBuiltinTypeElementImpl.kt\ncom/intellij/sql/dialects/clickhouse/psi/CHouseBuiltinTypeElementImpl\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,60:1\n275#2:61\n275#2:62\n*S KotlinDebug\n*F\n+ 1 CHouseBuiltinTypeElementImpl.kt\ncom/intellij/sql/dialects/clickhouse/psi/CHouseBuiltinTypeElementImpl\n*L\n47#1:61\n53#1:62\n*E\n"})
public final class CHouseBuiltinTypeElementImpl
extends SqlBuiltinTypeElementImpl {
    public CHouseBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Nullable
    protected DasType parseBuiltinTypeBase() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof SqlReferenceExpression) {
            return (DasType)CHouseTypeSystem.caseSensitiveTypes.get(((SqlReferenceExpression)firstChild).getText());
        }
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)this)).filter(arg_0 -> CHouseBuiltinTypeElementImpl.parseBuiltinTypeBase$lambda$1(CHouseBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$0, arg_0)).takeWhile(arg_0 -> CHouseBuiltinTypeElementImpl.parseBuiltinTypeBase$lambda$3(CHouseBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"takeWhile(...)");
        JBIterable keywords = jBIterable;
        String name2 = CollectionsKt.joinToString$default((Iterable)((Iterable)keywords), (CharSequence)" ", null, null, (int)0, null, CHouseBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$4, (int)30, null);
        String string = name2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        DasBuiltinType dasBuiltinType = CHouseTypeSystem.caseInsensitiveTypes.get(string);
        if (dasBuiltinType == null) {
            return null;
        }
        DasBuiltinType dasType = dasBuiltinType;
        if (!Intrinsics.areEqual((Object)((DasTypeClass)dasType.getTypeClass()).getName(), (Object)name2)) {
            dasType = DasTypeUtilsKt.withName(dasType, (String)name2);
        }
        return (DasType)dasType;
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType<?> dasType) {
        Intrinsics.checkNotNullParameter(dasType, (String)"dasType");
        if (dasType instanceof CHouseDateTimeType) {
            return this.adjustDateTimeType((CHouseDateTimeType)dasType);
        }
        if (dasType instanceof CHouseDateTime64Type) {
            return this.adjustDateTime64Type((CHouseDateTime64Type)dasType);
        }
        return super.adjustType(dasType);
    }

    private final CHouseDateTimeType adjustDateTimeType(CHouseDateTimeType dasType) {
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlStringLiteralExpression.class);
        if (sqlStringLiteralExpression == null) {
            return dasType;
        }
        SqlStringLiteralExpression timeZoneLiteral = sqlStringLiteralExpression;
        return dasType.copy(timeZoneLiteral.getValue());
    }

    private final CHouseDateTime64Type adjustDateTime64Type(CHouseDateTime64Type dasType) {
        int precision = this.getIntAttribute();
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        SqlStringLiteralExpression timeZoneLiteral = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlStringLiteralExpression.class);
        if (precision == -1 && timeZoneLiteral == null) {
            return dasType;
        }
        SqlStringLiteralExpression sqlStringLiteralExpression = timeZoneLiteral;
        return dasType.copy(precision != -1 ? precision : dasType.getPrecision(), sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : dasType.getTimeZone());
    }

    private static final boolean parseBuiltinTypeBase$lambda$0(PsiElement it) {
        return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment);
    }

    private static final boolean parseBuiltinTypeBase$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean parseBuiltinTypeBase$lambda$2(PsiElement it) {
        return it instanceof SqlReferenceExpression || PsiTreeUtilKt.getElementType((PsiElement)it) instanceof SqlKeywordTokenType;
    }

    private static final boolean parseBuiltinTypeBase$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence parseBuiltinTypeBase$lambda$4(PsiElement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

