/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse.psi;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlJoinExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTableTypeOverride;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0018\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/dialects/clickhouse/psi/CHouseJoinExpression;", "Lcom/intellij/sql/psi/impl/SqlJoinExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "calcType", "Lcom/intellij/sql/psi/SqlTableType;", "end", "Lcom/intellij/psi/PsiElement;", "calcJoinType", "forAsterisk", "", "intellij.database.dialects.clickhouse"})
public final class CHouseJoinExpression
extends SqlJoinExpressionImpl {
    public CHouseJoinExpression(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    protected SqlTableType calcType(@Nullable PsiElement end) {
        return this.calcJoinType(end, false);
    }

    @NotNull
    public final SqlTableType calcJoinType(@Nullable PsiElement end, boolean forAsterisk) {
        PsiElement lastToCheck = this.getLastToCheck(end);
        SqlExpression lOperand = this.getLOperand();
        DasType lType = SqlJoinExpressionImpl.getTypeLateralAware((SqlExpression)lOperand, (PsiElement)lastToCheck, (PsiElement)end);
        SqlTableType sqlTableType = lType instanceof SqlTableType ? (SqlTableType)lType : null;
        if (sqlTableType == null) {
            sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        }
        SqlTableType expressionType = sqlTableType;
        Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
        int n = expressionType.getColumnCount();
        for (int i = 0; i < n; ++i) {
            indices.put((Object)expressionType.getColumnName(i), i + 1);
        }
        if (!Intrinsics.areEqual((Object)lOperand, (Object)lastToCheck)) {
            for (PsiElement child = lOperand.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof SqlExpression) {
                    DasType dasType = SqlJoinExpressionImpl.getDasTypeLateralAware((SqlExpression)((SqlExpression)child), (PsiElement)lastToCheck, (PsiElement)end);
                    SqlTableType nextType = SqlTableTypeBase.ensureTableType((DasType)dasType, (PsiElement)child, (PsiElement)((PsiElement)this));
                    SqlTableType append = forAsterisk ? null : nextType;
                    for (int i = nextType.getColumnCount() - 1; -1 < i; --i) {
                        int base = indices.getInt((Object)nextType.getColumnName(i));
                        if (base == 0) continue;
                        expressionType = SqlTableTypeOverride.override((SqlTableType)expressionType, (int)(base - 1), (SqlTableType)nextType, (int)i);
                        if (append == null) continue;
                        append = SubtractedSqlTableTypeImpl.subtract((SqlTableType)append, (int)i);
                    }
                    if (append != null) {
                        int sz = expressionType.getColumnCount();
                        expressionType = expressionType.add(append);
                        int n2 = append.getColumnCount();
                        for (int i = 0; i < n2; ++i) {
                            indices.put((Object)append.getColumnName(i), sz + i + 1);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)child, (Object)lastToCheck)) break;
            }
        }
        SqlTableType sqlTableType2 = expressionType;
        Intrinsics.checkNotNull((Object)sqlTableType2);
        return sqlTableType2;
    }
}

