/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Command;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.impl.GraphBackupRealizersCommand;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DUndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphUndoServiceImpl
implements GraphUndoService {
    @NotNull
    private static final Key<Boolean> GRAPH_UNDO_DISABLED = Key.create((String)"com.intellij.openapi.graph.impl.GraphUndoServiceImpl.GRAPH_UNDO_DISABLED");

    private static boolean j(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(0);
        }
        return graphBuilder.getUserData(GRAPH_UNDO_DISABLED) == Boolean.TRUE;
    }

    private static void h(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(1);
        }
        graphBuilder.putUserData(GRAPH_UNDO_DISABLED, Boolean.TRUE);
    }

    private static void U(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(2);
        }
        graphBuilder.putUserData(GRAPH_UNDO_DISABLED, Boolean.FALSE);
    }

    @Override
    @NotNull
    public Graph2DUndoManager setupUndoManagerFor(final @NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphUndoServiceImpl.U(3);
        }
        Graph2DUndoManager graph2DUndoManager = GraphManager.getGraphManager().createGraph2DUndoManager(builder.getGraph());
        graph2DUndoManager.setViewContainer(builder.getView());
        graph2DUndoManager.setMaximumUndoDepth(UndoManagerImpl.getDocumentUndoLimit());
        graph2DUndoManager.addUndoListener(new Graph2DUndoManager.UndoListener(){

            @Override
            public void commandAdded(Command command) {
                if (command == null || GraphUndoServiceImpl.j(builder) || BaseGraphStructureViewBuilder.isLocalViewBuilder(builder)) {
                    return;
                }
                Project project = builder.getProject();
                WriteCommandAction.writeCommandAction((Project)project).withName(GraphBundle.message("graph.builder.default.command.name", new Object[0])).run(() -> {
                    GraphUndoServiceImpl.j(builder);
                    Document[] documentArray = GraphUndoServiceImpl.j(builder);
                    if (documentArray.length == 0) {
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    } else {
                        CommandProcessor.getInstance().addAffectedDocuments(project, documentArray);
                    }
                });
            }
        });
        Graph2DUndoManager graph2DUndoManager2 = graph2DUndoManager;
        if (graph2DUndoManager2 == null) {
            GraphUndoServiceImpl.U(4);
        }
        return graph2DUndoManager2;
    }

    private static Document @NotNull [] j(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(5);
        }
        Document[] documentArray = (Document[])Optional.ofNullable((FileEditor)graphBuilder.getUserData(GraphDataKeys.GRAPH_FILE_EDITOR)).map(fileEditor -> (DocumentReferenceProvider)ObjectUtils.tryCast((Object)fileEditor, DocumentReferenceProvider.class)).map(documentReferenceProvider -> documentReferenceProvider.getDocumentReferences()).stream().flatMap(collection -> collection.stream().map(documentReference -> documentReference.getDocument())).filter(document -> document != null).toArray(Document[]::new);
        if (documentArray == null) {
            GraphUndoServiceImpl.U(6);
        }
        return documentArray;
    }

    @RequiresWriteLock
    private static void j(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(7);
        }
        ThreadingAssertions.assertWriteAccess();
        UndoManager.getInstance((Project)graphBuilder.getProject()).undoableActionPerformed((UndoableAction)new MyUndoableAction(graphBuilder.getUndoManager()));
    }

    @RequiresWriteLock
    @NotNull
    private Pair<Runnable, Runnable> j(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull Consumer<? super Runnable> consumer, @NotNull Consumer<? super Runnable> consumer2) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(8);
        }
        if (consumer == null) {
            GraphUndoServiceImpl.U(9);
        }
        if (consumer2 == null) {
            GraphUndoServiceImpl.U(10);
        }
        ThreadingAssertions.assertWriteAccess();
        Graph2D graph2D = graphBuilder.getGraph();
        graph2D.firePreEvent();
        GraphUndoServiceImpl.h(graphBuilder);
        Pair<Runnable, Runnable> pair = this.backupRealizers(graphBuilder, graph2D.nodes(), graph2D.edges(), consumer, consumer2);
        GraphUndoServiceImpl.U(graphBuilder);
        Pair<Runnable, Runnable> pair2 = pair;
        if (pair2 == null) {
            GraphUndoServiceImpl.U(11);
        }
        return pair2;
    }

    @Override
    public void performPositionsOnlyChangingAction(@NotNull GraphBuilder<?, ?> builder, @Nls @NotNull String commandName, final @NotNull BiConsumer<? super Runnable, ? super Runnable> action, @NotNull Consumer<? super Runnable> onUndo, @NotNull Consumer<? super Runnable> onRedo) {
        if (builder == null) {
            GraphUndoServiceImpl.U(12);
        }
        if (commandName == null) {
            GraphUndoServiceImpl.U(13);
        }
        if (action == null) {
            GraphUndoServiceImpl.U(14);
        }
        if (onUndo == null) {
            GraphUndoServiceImpl.U(15);
        }
        if (onRedo == null) {
            GraphUndoServiceImpl.U(16);
        }
        final Pair pair = (Pair)WriteAction.compute(() -> this.j(builder, onUndo, onRedo));
        action.accept((Runnable)pair.getFirst(), (Runnable)pair.getSecond());
        WriteCommandAction.writeCommandAction((Project)builder.getProject()).withName(commandName).run(() -> this.j(builder, new Command(){

            @Override
            public void execute() {
                action.accept(pair.getFirst(), pair.getSecond());
            }

            @Override
            public void undo() {
            }

            @Override
            public void redo() {
            }
        }));
    }

    @RequiresWriteLock
    private void j(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull Command command) {
        if (graphBuilder == null) {
            GraphUndoServiceImpl.U(17);
        }
        if (command == null) {
            GraphUndoServiceImpl.U(18);
        }
        ThreadingAssertions.assertWriteAccess();
        this.undoableActionPerformed(graphBuilder, command);
        graphBuilder.getGraph().firePostEvent();
    }

    @Override
    @NotNull
    public Pair<Runnable, Runnable> backupRealizers(@NotNull GraphBuilder<?, ?> builder, @NotNull NodeCursor nodeCursor, @NotNull EdgeCursor edgeCursor, @NotNull Consumer<? super Runnable> onUndo, @NotNull Consumer<? super Runnable> onRedo) {
        if (builder == null) {
            GraphUndoServiceImpl.U(19);
        }
        if (nodeCursor == null) {
            GraphUndoServiceImpl.U(20);
        }
        if (edgeCursor == null) {
            GraphUndoServiceImpl.U(21);
        }
        if (onUndo == null) {
            GraphUndoServiceImpl.U(22);
        }
        if (onRedo == null) {
            GraphUndoServiceImpl.U(23);
        }
        Graph2DUndoManager graph2DUndoManager = builder.getUndoManager();
        GraphBackupRealizersCommand graphBackupRealizersCommand = new GraphBackupRealizersCommand(builder, nodeCursor, edgeCursor, graph2DUndoManager.isSelectionStateAdjusting(), onUndo, onRedo);
        graph2DUndoManager.push(graphBackupRealizersCommand);
        Pair pair = Pair.create(graphBackupRealizersCommand::recordUndoRealizers, graphBackupRealizersCommand::recordRedoRealizers);
        if (pair == null) {
            GraphUndoServiceImpl.U(24);
        }
        return pair;
    }

    private static /* synthetic */ void U(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 4, 6, 11, 24 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/GraphUndoServiceImpl";
                break;
            }
            case 9: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUndo";
                break;
            }
            case 10: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRedo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCursor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeCursor";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/GraphUndoServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setupUndoManagerFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "beforePositionsOnlyChangingActionPerformed";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "backupRealizers";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoDisabledFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "disableUndoFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enableUndoFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupUndoManagerFor";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedDocuments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "undoableActionPerformed";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforePositionsOnlyChangingActionPerformed";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performPositionsOnlyChangingAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "afterPositionsOnlyChangingActionPerformed";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "backupRealizers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 11, 24 -> new IllegalStateException(string);
        };
    }

    private static final class MyUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final Graph2DUndoManager graphUndoManager;

        private MyUndoableAction(@NotNull Graph2DUndoManager manager) {
            if (manager == null) {
                MyUndoableAction.j(0);
            }
            this.graphUndoManager = manager;
        }

        public void undo() {
            this.graphUndoManager.undo();
            ((Graph2D)this.graphUndoManager.getActiveGraph()).updateViews();
        }

        public void redo() {
            this.graphUndoManager.redo();
            ((Graph2D)this.graphUndoManager.getActiveGraph()).updateViews();
        }

        private static /* synthetic */ void j(int n10) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/graph/impl/GraphUndoServiceImpl$MyUndoableAction", "<init>"));
        }
    }
}

