/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.diagnostic.Checks;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YDimension;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphNodeRealizerService {
    @NotNull
    private static final Key<NodeCellRenderer> NODE_CELL_RENDERER_KEY = Key.create((String)"com.intellij.openapi.graph.services.GraphNodeRealizerService.NODE_CELL_RENDERER_KEY");
    @NotNull
    private static final GraphNodeRealizerService INSTANCE = new GraphNodeRealizerService();

    @NotNull
    public static GraphNodeRealizerService getInstance() {
        GraphNodeRealizerService graphNodeRealizerService = INSTANCE;
        if (graphNodeRealizerService == null) {
            GraphNodeRealizerService.j(0);
        }
        return graphNodeRealizerService;
    }

    private GraphNodeRealizerService() {
    }

    public boolean areRealizersEqual(@Nullable NodeRealizer a2, @Nullable NodeRealizer b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null || a2.getClass() != b2.getClass()) {
            return false;
        }
        return a2.getHeight() == b2.getHeight() && a2.getWidth() == b2.getWidth() && a2.getX() == b2.getX() && a2.getY() == b2.getY() && a2.isSelected() == b2.isSelected() && a2.isVisible() == b2.isVisible();
    }

    @Nullable
    public <T> T getUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey) {
        Object object;
        if (dataKey == null) {
            GraphNodeRealizerService.j(1);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            return (T)((MyCloneableUserDataHolder)object).getCopyableUserData(dataKey);
        }
        return null;
    }

    public <T> void putUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey, T data) {
        Object object;
        if (dataKey == null) {
            GraphNodeRealizerService.j(2);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            ((MyCloneableUserDataHolder)object).putCopyableUserData(dataKey, data);
            return;
        }
        Checks.fail((Object)("Given node realizer doesn't support user data: " + String.valueOf(nodeRealizer)));
    }

    private static void j(@NotNull GenericNodeRealizer genericNodeRealizer) {
        if (genericNodeRealizer == null) {
            GraphNodeRealizerService.j(3);
        }
        MyCloneableUserDataHolder myCloneableUserDataHolder = new MyCloneableUserDataHolder();
        genericNodeRealizer.setUserData(myCloneableUserDataHolder);
    }

    @Nullable
    public NodeCellRenderer getNodeCellRenderer(@Nullable NodeRealizer nodeRealizer) {
        return this.getUserData(nodeRealizer, NODE_CELL_RENDERER_KEY);
    }

    @NotNull
    public GenericNodeRealizer createGenericNodeRealizer(@NotNull @NonNls String configurationKey, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (configurationKey == null) {
            GraphNodeRealizerService.j(4);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.j(5);
        }
        GraphNodeRealizerService.j(configurationKey, nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer(configurationKey);
        GraphNodeRealizerService.j(genericNodeRealizer);
        this.putUserData(genericNodeRealizer, NODE_CELL_RENDERER_KEY, nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer2 = genericNodeRealizer;
        if (genericNodeRealizer2 == null) {
            GraphNodeRealizerService.j(6);
        }
        return genericNodeRealizer2;
    }

    private static void j(@NotNull @NonNls String string, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (string == null) {
            GraphNodeRealizerService.j(7);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.j(8);
        }
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createFastNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        map.put(GenericNodeRealizer.UserDataHandler.class, new MyUserDataHandler());
        map.put(GenericNodeRealizer.GenericSizeConstraintProvider.class, new MySizeConstraintProvider());
        factory.addConfiguration(string, map);
    }

    private static /* synthetic */ void j(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKey";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCellRenderer";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericNodeRealizer";
                break;
            }
        }
        switch (n10) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupUserDataHolderFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGenericNodeRealizer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "associateDefaultRealizerConfigsWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCloneableUserDataHolder
    extends UserDataHolderBase
    implements Cloneable {
        private MyCloneableUserDataHolder() {
        }

        public MyCloneableUserDataHolder clone() {
            return (MyCloneableUserDataHolder)super.clone();
        }
    }

    private static final class MyUserDataHandler
    implements GenericNodeRealizer.UserDataHandler {
        private MyUserDataHandler() {
        }

        @Override
        public void storeUserData(NodeRealizer _nodeRealizer, Object _o, ObjectOutputStream _objectOutputStream) throws IOException {
        }

        @Override
        @Nullable
        public Object readUserData(NodeRealizer _nodeRealizer, ObjectInputStream _objectInputStream) throws IOException {
            return null;
        }

        @Override
        @Nullable
        public Object copyUserData(NodeRealizer source, Object userData, NodeRealizer dest) {
            Object object;
            if (source instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)source).getUserData()) instanceof MyCloneableUserDataHolder) {
                return ((MyCloneableUserDataHolder)object).clone();
            }
            return null;
        }
    }

    private static final class MySizeConstraintProvider
    implements GenericNodeRealizer.GenericSizeConstraintProvider {
        private MySizeConstraintProvider() {
        }

        @Override
        public YDimension getMinimumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.j(realizer)).map(jComponent -> MySizeConstraintProvider.j(jComponent.getMinimumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(0.0, 0.0));
        }

        @Override
        public YDimension getMaximumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.j(realizer)).map(jComponent -> MySizeConstraintProvider.j(jComponent.getMaximumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(2.147483647E9, 2.147483647E9));
        }

        @Nullable
        private static JComponent j(NodeRealizer nodeRealizer) {
            NodeCellRenderer nodeCellRenderer = GraphNodeRealizerService.getInstance().getNodeCellRenderer(nodeRealizer);
            if (nodeCellRenderer != null) {
                return nodeCellRenderer.getNodeCellRendererComponent((Graph2DView)((Graph2D)nodeRealizer.getNode().getGraph()).getCurrentView(), nodeRealizer, null, nodeRealizer.isSelected());
            }
            return null;
        }

        @NotNull
        private static YDimension j(@NotNull Dimension dimension) {
            if (dimension == null) {
                MySizeConstraintProvider.j(0);
            }
            YDimension yDimension = GraphManager.getGraphManager().createYDimension(dimension.getWidth(), dimension.getHeight());
            if (yDimension == null) {
                MySizeConstraintProvider.j(1);
            }
            return yDimension;
        }

        private static /* synthetic */ void j(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n10) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dimension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapToYDimension";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapToYDimension";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n10) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

