/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphSelectionService {
    @NotNull
    private static final GraphSelectionService INSTANCE = new GraphSelectionService();
    @GuardedBy(value="this")
    @NotNull
    private final Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> myOneTimeSelectionCallbacks = new HashMap();
    @NotNull
    private final Set<GraphBuilder<?, ?>> myGraphBuilderWithSuppressedSelection = Collections.synchronizedSet(new HashSet());

    @NotNull
    public static GraphSelectionService getInstance() {
        GraphSelectionService graphSelectionService = INSTANCE;
        if (graphSelectionService == null) {
            GraphSelectionService.j(0);
        }
        return graphSelectionService;
    }

    private GraphSelectionService() {
    }

    public boolean anyNodeOrEdgeSelected(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.j(1);
        }
        return this.hasSelectedNodes(graph) || this.hasSelectedEdges(graph);
    }

    public boolean hasSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.j(2);
        }
        return graph.selectedNodes().ok();
    }

    public void forEachSelectedNode(@NotNull Graph2D graph, @NotNull Consumer<? super Node> consumer) {
        if (graph == null) {
            GraphSelectionService.j(3);
        }
        if (consumer == null) {
            GraphSelectionService.j(4);
        }
        NodeCursor nodeCursor = graph.selectedNodes();
        while (nodeCursor.ok()) {
            consumer.accept(nodeCursor.node());
            nodeCursor.next();
        }
    }

    public <N> void forEachSelectedModelNode(@NotNull GraphBuilder<N, ?> builder, @NotNull Consumer<? super N> consumer) {
        if (builder == null) {
            GraphSelectionService.j(5);
        }
        if (consumer == null) {
            GraphSelectionService.j(6);
        }
        NodeCursor nodeCursor = builder.getGraph().selectedNodes();
        while (nodeCursor.ok()) {
            N n10 = builder.getNodeObject(nodeCursor.node());
            if (n10 != null) {
                consumer.accept(n10);
            }
            nodeCursor.next();
        }
    }

    @NotNull
    public List<Node> getSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.j(7);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeCursor nodeCursor = graph.selectedNodes();
        while (nodeCursor.ok()) {
            arrayList.add(nodeCursor.node());
            nodeCursor.next();
        }
        ArrayList<Node> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphSelectionService.j(8);
        }
        return arrayList2;
    }

    @NotNull
    public <N> List<N> getSelectedModelNodes(@NotNull GraphBuilder<N, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(9);
        }
        ArrayList<N> arrayList = new ArrayList<N>();
        NodeCursor nodeCursor = builder.getGraph().selectedNodes();
        while (nodeCursor.ok()) {
            N n10 = builder.getNodeObject(nodeCursor.node());
            if (n10 != null) {
                arrayList.add(n10);
            }
            nodeCursor.next();
        }
        ArrayList<N> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphSelectionService.j(10);
        }
        return arrayList2;
    }

    @Nullable
    public Node getSingleSelectedNode(@NotNull Graph2D graph) {
        NodeCursor nodeCursor;
        if (graph == null) {
            GraphSelectionService.j(11);
        }
        if ((nodeCursor = graph.selectedNodes()).ok()) {
            Node node = nodeCursor.node();
            nodeCursor.next();
            if (!nodeCursor.ok()) {
                return node;
            }
        }
        return null;
    }

    @Nullable
    public <N> N getSingleSelectedModelNode(@NotNull GraphBuilder<N, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(12);
        }
        return builder.getNodeObject(this.getSingleSelectedNode(builder.getGraph()));
    }

    public void selectAllNodes(@NotNull Graph2D graph, @NotNull Collection<Node> nodes, boolean state) {
        if (graph == null) {
            GraphSelectionService.j(13);
        }
        if (nodes == null) {
            GraphSelectionService.j(14);
        }
        for (Node node : nodes) {
            graph.setSelected(node, state);
        }
    }

    public <N> void selectAllModelNodes(@NotNull GraphBuilder<N, ?> builder, @NotNull Collection<N> nodes, boolean state) {
        if (builder == null) {
            GraphSelectionService.j(15);
        }
        if (nodes == null) {
            GraphSelectionService.j(16);
        }
        Graph2D graph2D = builder.getGraph();
        for (N n10 : nodes) {
            Node node = builder.getNode(n10);
            if (node == null) continue;
            graph2D.setSelected(node, state);
        }
    }

    public boolean hasSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.j(17);
        }
        return graph.selectedEdges().ok();
    }

    public void forEachSelectedEdge(@NotNull Graph2D graph, @NotNull Consumer<? super Edge> consumer) {
        if (graph == null) {
            GraphSelectionService.j(18);
        }
        if (consumer == null) {
            GraphSelectionService.j(19);
        }
        EdgeCursor edgeCursor = graph.selectedEdges();
        while (edgeCursor.ok()) {
            consumer.accept(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    @NotNull
    public List<Edge> getSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.j(20);
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        EdgeCursor edgeCursor = graph.selectedEdges();
        while (edgeCursor.ok()) {
            arrayList.add(edgeCursor.edge());
            edgeCursor.next();
        }
        ArrayList<Edge> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphSelectionService.j(21);
        }
        return arrayList2;
    }

    @Nullable
    public Edge getSingleSelectedEdge(@NotNull Graph2D graph) {
        EdgeCursor edgeCursor;
        if (graph == null) {
            GraphSelectionService.j(22);
        }
        if ((edgeCursor = graph.selectedEdges()).ok()) {
            Edge edge = edgeCursor.edge();
            edgeCursor.next();
            if (!edgeCursor.ok()) {
                return edge;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOneTimeSelectionCallback(@NotNull GraphBuilder<?, ?> builder, @NotNull Consumer<? super Rectangle> callback) {
        if (builder == null) {
            GraphSelectionService.j(23);
        }
        if (callback == null) {
            GraphSelectionService.j(24);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> map = this.myOneTimeSelectionCallbacks;
        synchronized (map) {
            if (this.myOneTimeSelectionCallbacks.containsKey(builder)) {
                this.myOneTimeSelectionCallbacks.get(builder).add(callback);
            } else {
                ArrayList<Consumer<? super Rectangle>> arrayList = new ArrayList<Consumer<? super Rectangle>>();
                arrayList.add(callback);
                this.myOneTimeSelectionCallbacks.put(builder, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOneTimeSelectionCallbacks(@NotNull GraphBuilder<?, ?> builder, @NotNull Consumer<? super Consumer<? super Rectangle>> processor) {
        if (builder == null) {
            GraphSelectionService.j(25);
        }
        if (processor == null) {
            GraphSelectionService.j(26);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> map = this.myOneTimeSelectionCallbacks;
        synchronized (map) {
            List<Consumer<? super Rectangle>> list = this.myOneTimeSelectionCallbacks.get(builder);
            if (list != null) {
                for (Consumer<? super Rectangle> consumer : list) {
                    processor.accept(consumer);
                }
                list.clear();
            }
        }
    }

    public void suppressSelection(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(27);
        }
        this.myGraphBuilderWithSuppressedSelection.add(builder);
    }

    public void enableSelection(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(28);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder);
    }

    public boolean isSelectionSuppressedFor(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(29);
        }
        return this.myGraphBuilderWithSuppressedSelection.contains(builder);
    }

    public void onGraphBuilderDispose(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.j(30);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder);
        this.myOneTimeSelectionCallbacks.remove(builder);
    }

    private static /* synthetic */ void j(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 3;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelNodes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEdges";
                break;
            }
        }
        switch (n10) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anyNodeOrEdgeSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasSelectedNodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedModelNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModelNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedModelNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectAllNodes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectAllModelNodes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasSelectedEdges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedEdge";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEdges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedEdge";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerOneTimeSelectionCallback";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processAllOneTimeSelectionCallbacks";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "suppressSelection";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "enableSelection";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionSuppressedFor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onGraphBuilderDispose";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalArgumentException(string);
        };
    }
}

