/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view.focusview;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.components.CustomGraphBuilderWheelListener;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.BaseGraphViewControllerMode;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.GraphViewControllerBuilder;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.ModelViewManager;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.focusview.GraphFocusViewProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class BaseGraphFocusView<N, E>
implements GraphFocusViewProvider<N, E> {
    private GraphBuilder<N, E> myModelBuilder;
    private GraphBuilder<N, E> myFocusViewBuilder;
    private ModelViewManager myModelViewManager;
    private FocusViewGraphBuilderUpdater myGraphBuilderUpdater;
    private SimpleModificationTracker myModTrackerOfViewUpdates;

    @NotNull
    protected abstract Graph2D createFocusGraph(@NotNull GraphBuilder<N, E> var1);

    protected abstract void customizeViewSettings(@NotNull Graph2DView var1, @NotNull EditMode var2, @NotNull GraphSettings var3, @NotNull GraphBuilder<N, E> var4);

    @Override
    public void setupAndEnableFocusViewFor(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(0);
        }
        this.myModelBuilder = modelBuilder;
        this.myModelViewManager = ModelViewManager.Statics.getInstance(modelBuilder.getGraph());
        Graph2D graph2D = this.createFocusGraph(modelBuilder);
        Graph2DView graph2DView = this.createFocusView(modelBuilder, graph2D);
        EditMode editMode = this.createEditModeForFocusView(modelBuilder);
        this.myModTrackerOfViewUpdates = new SimpleModificationTracker();
        this.myFocusViewBuilder = this.createAndSetupFocusViewBuilder(modelBuilder, graph2D, graph2DView, editMode);
        this.setupViewControllers(editMode);
        this.updateColors(graph2DView, modelBuilder.getView());
        this.updateFocusViewGraph(Collections.emptyList());
        GraphLayoutService.getInstance().queryLayout(this.myFocusViewBuilder).runAsync().thenRunAsync(() -> this.getGraphViewDisplay(modelBuilder).orElseThrow().setCurrentViewBuilder(this.myFocusViewBuilder), Futures.inEdt());
    }

    @Override
    public void dropCurrentFocusView() {
        if (this.myModelBuilder == null || GraphFocusViewProvider.getActiveFocusViewProviderFor(this.myModelBuilder) != this) {
            return;
        }
        Graph2D graph2D = this.getFocusViewBuilder().getGraph();
        this.getFocusViewManager().removeViewGraph(this.getFocusViewBuilder().getGraph());
        graph2D.clear();
        this.myModelBuilder.removeCustomUpdater(this.myGraphBuilderUpdater);
        this.getGraphViewDisplay(this.myModelBuilder).orElseThrow().setCurrentViewBuilder(this.myModelBuilder);
        this.myModelBuilder.putUserData(ACTIVE_FOCUS_VIEW_PROVIDER_KEY, null);
        this.myModelBuilder = null;
        this.myModelViewManager = null;
        Disposer.dispose(this.myFocusViewBuilder);
        this.myFocusViewBuilder = null;
        this.myGraphBuilderUpdater = null;
        this.myModTrackerOfViewUpdates = null;
    }

    public void dispose() {
        this.dropCurrentFocusView();
    }

    @NotNull
    protected Optional<GraphBuilderDisplay> getGraphViewDisplay(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(1);
        }
        Optional<GraphBuilderDisplay> optional = Optional.ofNullable((BasicGraphPresentationModel)ObjectUtils.tryCast(modelBuilder.getGraphPresentationModel(), BasicGraphPresentationModel.class)).map(basicGraphPresentationModel -> basicGraphPresentationModel.getGraphViewDisplay());
        if (optional == null) {
            BaseGraphFocusView.U(2);
        }
        return optional;
    }

    @NotNull
    protected GraphBuilder<N, E> createAndSetupFocusViewBuilder(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull Graph2D focusViewGraph, @NotNull Graph2DView focusView, @NotNull EditMode editModeForFocusView) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(3);
        }
        if (focusViewGraph == null) {
            BaseGraphFocusView.U(4);
        }
        if (focusView == null) {
            BaseGraphFocusView.U(5);
        }
        if (editModeForFocusView == null) {
            BaseGraphFocusView.U(6);
        }
        FocusViewGraphDataModel focusViewGraphDataModel = new FocusViewGraphDataModel(focusViewGraph);
        FocusViewGraphPresentationModel focusViewGraphPresentationModel = new FocusViewGraphPresentationModel(focusViewGraph);
        GraphBuilder graphBuilder = GraphBuilderFactory.getInstance(modelBuilder.getProject()).createGraphBuilder(focusViewGraph, focusView, focusViewGraphDataModel, focusViewGraphPresentationModel, editModeForFocusView);
        focusViewGraphPresentationModel.setGraphBuilder(graphBuilder);
        graphBuilder.putUserData((Key)GraphDataKeys.MODEL_GRAPH_BUILDER, this.getModelBuilder());
        this.getModelBuilder().putUserData(ACTIVE_FOCUS_VIEW_PROVIDER_KEY, this);
        graphBuilder.initialize();
        this.setupFocusViewModelUpdate(modelBuilder, graphBuilder);
        GraphBuilder graphBuilder2 = graphBuilder;
        if (graphBuilder2 == null) {
            BaseGraphFocusView.U(7);
        }
        return graphBuilder2;
    }

    protected void setupBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BaseGraphFocusView.U(8);
        }
        DefaultBackgroundRenderer defaultBackgroundRenderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        defaultBackgroundRenderer.setColor(UIUtil.getListBackground());
        view.setBackgroundRenderer(defaultBackgroundRenderer);
    }

    @NotNull
    protected Graph2DView createFocusView(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull Graph2D focusViewGraph) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(9);
        }
        if (focusViewGraph == null) {
            BaseGraphFocusView.U(10);
        }
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView(focusViewGraph);
        this.setupBackgroundRenderer(graph2DView);
        graph2DView.setFitContentOnResize(false);
        graph2DView.setScrollBarPolicy(20, 30);
        Graph2DView graph2DView2 = graph2DView;
        if (graph2DView2 == null) {
            BaseGraphFocusView.U(11);
        }
        return graph2DView2;
    }

    protected void updateColors(@NotNull Graph2DView focusView, @NotNull Graph2DView modelView) {
        if (focusView == null) {
            BaseGraphFocusView.U(12);
        }
        if (modelView == null) {
            BaseGraphFocusView.U(13);
        }
        focusView.setGridColor(modelView.getGridColor());
        focusView.setCoarseGridColor(modelView.getCoarseGridColor());
        BaseGraphFocusView.j(modelView.getJComponent(), focusView.getJComponent(), "selectionbox.fillcolor");
        BaseGraphFocusView.j(modelView.getJComponent(), focusView.getJComponent(), "selectionbox.linecolor");
        BaseGraphFocusView.j(modelView.getJComponent(), focusView.getJComponent(), "magnifier.linecolor");
    }

    @NotNull
    protected EditMode createEditModeForFocusView(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(14);
        }
        EditMode editMode = GraphEditModeFactory.getInstance(modelBuilder.getProject()).createEditMode(modelBuilder);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(true);
        editMode.allowResizeNodes(true);
        editMode.allowMoveLabels(false);
        editMode.allowMovePorts(true);
        editMode.allowLabelSelection(true);
        editMode.allowMoveSelection(true);
        editMode.allowMoving(true);
        editMode.allowMovingWithPopup(true);
        editMode.setAdjustScrollBarPolicy(false);
        editMode.showEdgeTips(true);
        editMode.showNodeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            BaseGraphFocusView.U(15);
        }
        return editMode2;
    }

    protected void setupFocusViewModelUpdate(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull GraphBuilder<N, E> focusViewBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.U(16);
        }
        if (focusViewBuilder == null) {
            BaseGraphFocusView.U(17);
        }
        this.myGraphBuilderUpdater = new FocusViewGraphBuilderUpdater();
        modelBuilder.addCustomUpdater(this.myGraphBuilderUpdater);
        focusViewBuilder.addCustomUpdater(this.myGraphBuilderUpdater);
    }

    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode) {
        if (editMode == null) {
            BaseGraphFocusView.U(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(200);
        ((FocusGraphViewControllerBuilder)((FocusGraphViewControllerBuilder)FocusGraphViewControllerBuilder.beginSetupFor(this.myFocusViewBuilder).setEditMode(editMode)).setMagnifierViewMode(magnifierViewMode)).endSetup();
    }

    @NotNull
    public GraphBuilder<N, E> getModelBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myModelBuilder;
        if (graphBuilder == null) {
            BaseGraphFocusView.U(19);
        }
        return graphBuilder;
    }

    @NotNull
    public GraphBuilder<N, E> getFocusViewBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myFocusViewBuilder;
        if (graphBuilder == null) {
            BaseGraphFocusView.U(20);
        }
        return graphBuilder;
    }

    @NotNull
    protected Optional<N> getModelGraphNodeObject(@Nullable Node node2) {
        Optional<Object> optional = Optional.ofNullable(node2).map(node -> this.getModelBuilder().getNodeObject((Node)node)).map(node -> this.getModelBuilder().getNodeObject((Node)node));
        if (optional == null) {
            BaseGraphFocusView.U(21);
        }
        return optional;
    }

    @NotNull
    protected Optional<E> getModelGraphEdgeObject(@Nullable Edge edge2) {
        Optional<Object> optional = Optional.ofNullable(edge2).map(edge -> this.getModelBuilder().getEdgeObject((Edge)edge)).map(edge -> this.getModelBuilder().getEdgeObject((Edge)edge));
        if (optional == null) {
            BaseGraphFocusView.U(22);
        }
        return optional;
    }

    @NotNull
    public JComponent getCanvasComponent() {
        JComponent jComponent = this.myFocusViewBuilder.getView().getJComponent();
        if (jComponent == null) {
            BaseGraphFocusView.U(23);
        }
        return jComponent;
    }

    @NotNull
    public Graph2DView getGraph2DView() {
        Graph2DView graph2DView = this.myFocusViewBuilder.getView();
        if (graph2DView == null) {
            BaseGraphFocusView.U(24);
        }
        return graph2DView;
    }

    @NotNull
    public ModelViewManager getFocusViewManager() {
        ModelViewManager modelViewManager = this.myModelViewManager;
        if (modelViewManager == null) {
            BaseGraphFocusView.U(25);
        }
        return modelViewManager;
    }

    protected void updateFocusViewGraph(@NotNull Collection<?> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            BaseGraphFocusView.U(26);
        }
        this.myModelViewManager.synchronizeModelToViewGraph(this.myFocusViewBuilder.getGraph());
        Map<Object, Node> map = Arrays.stream(this.myFocusViewBuilder.getGraph().getNodeArray()).map(node -> Pair.create(this.getModelGraphNodeObject((Node)node).orElseThrow(), (Object)node)).collect(Collectors.toMap(pair -> pair.first, pair -> pair.first));
        Map<Object, Edge> map2 = Arrays.stream(this.myFocusViewBuilder.getGraph().getEdgeArray()).map(edge -> Pair.create(this.getModelGraphEdgeObject((Edge)edge).orElseThrow(), (Object)edge)).collect(Collectors.toMap(pair -> pair.first, pair -> (Edge)pair.second));
        this.myFocusViewBuilder.updateDataModelWithCustomMapping(map::get, map2::get);
        this.myFocusViewBuilder.queryGraphUpdate().withNodeSizeUpdate(nodesForSizeUpdate.toArray()).run();
    }

    private static void j(@NotNull JComponent jComponent, @NotNull JComponent jComponent2, @NotNull String string) {
        if (jComponent == null) {
            BaseGraphFocusView.U(27);
        }
        if (jComponent2 == null) {
            BaseGraphFocusView.U(28);
        }
        if (string == null) {
            BaseGraphFocusView.U(29);
        }
        jComponent2.putClientProperty(string, jComponent.getClientProperty(string));
    }

    private static /* synthetic */ Node j(Pair pair) {
        return (Node)pair.second;
    }

    private /* synthetic */ Edge j(Edge edge) {
        return this.getFocusViewManager().getModelEdge(edge);
    }

    private /* synthetic */ Node j(Node node) {
        return this.getFocusViewManager().getModelNode(node);
    }

    private static /* synthetic */ void U(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 2, 7, 11, 15, 19, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusViewGraph";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editModeForFocusView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelView";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusViewBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphViewDisplay";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndSetupFocusViewBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditModeForFocusView";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusViewBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphNodeObject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphEdgeObject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph2DView";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusViewManager";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupAndEnableFocusViewFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGraphViewDisplay";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndSetupFocusViewBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupBackgroundRenderer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFocusView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEditModeForFocusView";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupFocusViewModelUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateFocusViewGraph";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyClientProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 11, 15, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    protected final class FocusViewGraphBuilderUpdater
    extends CustomGraphUpdater {
        private boolean myRecursionGuardCheck = false;

        protected FocusViewGraphBuilderUpdater() {
        }

        @Override
        public void update(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Collection<?> nodesForSizeUpdate) {
            if (graph == null) {
                FocusViewGraphBuilderUpdater.U(0);
            }
            if (view == null) {
                FocusViewGraphBuilderUpdater.U(1);
            }
            if (nodesForSizeUpdate == null) {
                FocusViewGraphBuilderUpdater.U(2);
            }
            if (!this.myRecursionGuardCheck) {
                this.myRecursionGuardCheck = true;
                BaseGraphFocusView.this.myModTrackerOfViewUpdates.incModificationCount();
                BaseGraphFocusView.this.updateFocusViewGraph(nodesForSizeUpdate);
            }
            this.myRecursionGuardCheck = false;
        }

        private static /* synthetic */ void U(int n10) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "graph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphBuilderUpdater";
            objectArray[2] = "update";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class FocusViewGraphDataModel
    extends GraphDataModel<N, E> {
        @NotNull
        private final Graph2D myFocusViewGraph;

        public FocusViewGraphDataModel(Graph2D graph) {
            if (graph == null) {
                FocusViewGraphDataModel.U(0);
            }
            this.myFocusViewGraph = graph;
        }

        @Override
        public @Unmodifiable @NotNull Collection<N> getNodes() {
            List list = ContainerUtil.mapNotNull((Object[])this.myFocusViewGraph.getNodeArray(), node -> BaseGraphFocusView.this.getModelGraphNodeObject((Node)node).orElse(null));
            if (list == null) {
                FocusViewGraphDataModel.U(1);
            }
            return list;
        }

        @Override
        public @Unmodifiable @NotNull Collection<E> getEdges() {
            List list = ContainerUtil.mapNotNull((Object[])this.myFocusViewGraph.getEdgeArray(), edge -> BaseGraphFocusView.this.getModelGraphEdgeObject((Edge)edge).orElse(null));
            if (list == null) {
                FocusViewGraphDataModel.U(2);
            }
            return list;
        }

        @Override
        @NotNull
        public N getSourceNode(E edge) {
            Object n10 = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getSourceNode(edge);
            if (n10 == null) {
                FocusViewGraphDataModel.U(3);
            }
            return n10;
        }

        @Override
        @NotNull
        public N getTargetNode(E edge) {
            Object n10 = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getTargetNode(edge);
            if (n10 == null) {
                FocusViewGraphDataModel.U(4);
            }
            return n10;
        }

        @Override
        @NotNull
        public String getNodeName(N node) {
            String string = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getNodeName(node);
            if (string == null) {
                FocusViewGraphDataModel.U(5);
            }
            return string;
        }

        @Override
        @NotNull
        public String getEdgeName(E edge) {
            String string = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getEdgeName(edge);
            if (string == null) {
                FocusViewGraphDataModel.U(6);
            }
            return string;
        }

        @Override
        @Nullable
        public E createEdge(@NotNull N from, @NotNull N to) {
            if (from == null) {
                FocusViewGraphDataModel.U(7);
            }
            if (to == null) {
                FocusViewGraphDataModel.U(8);
            }
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void U(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n10) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphDataModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphDataModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeName";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n10) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected final class FocusViewGraphPresentationModel
    extends BasicGraphPresentationModel<N, E> {
        public FocusViewGraphPresentationModel(Graph graph) {
            if (graph == null) {
                FocusViewGraphPresentationModel.h(0);
            }
            super(graph);
        }

        @Override
        @NotNull
        public NodeRealizer getNodeRealizer(@Nullable N node) {
            NodeRealizer nodeRealizer = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getNodeRealizer(this.getGraphBuilder(), node);
            if (nodeRealizer == null) {
                FocusViewGraphPresentationModel.h(1);
            }
            return nodeRealizer;
        }

        @Override
        @NotNull
        public EdgeRealizer getEdgeRealizer(@Nullable E edge) {
            EdgeRealizer edgeRealizer = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeRealizer(this.getSettings().getCurrentEdgeRealizerProvider(), edge);
            if (edgeRealizer == null) {
                FocusViewGraphPresentationModel.h(2);
            }
            return edgeRealizer;
        }

        @Override
        @Nullable
        public String getNodeTooltip(@Nullable N node) {
            return BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getNodeTooltip(node);
        }

        @Override
        @Nullable
        public String getEdgeTooltip(@Nullable E edge) {
            return BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeTooltip(edge);
        }

        @Override
        @NotNull
        protected DefaultActionGroup getCommonActionGroup() {
            DefaultActionGroup defaultActionGroup = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getPaperActionGroup();
            if (defaultActionGroup == null) {
                FocusViewGraphPresentationModel.h(3);
            }
            return defaultActionGroup;
        }

        @Override
        public EdgeLabel @NotNull [] getEdgeLabels(@Nullable E edge, @NotNull String edgeName) {
            if (edgeName == null) {
                FocusViewGraphPresentationModel.h(4);
            }
            EdgeLabel[] edgeLabelArray = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeLabels(edge, edgeName);
            if (edgeLabelArray == null) {
                FocusViewGraphPresentationModel.h(5);
            }
            return edgeLabelArray;
        }

        @Override
        public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
            if (view == null) {
                FocusViewGraphPresentationModel.h(6);
            }
            if (editMode == null) {
                FocusViewGraphPresentationModel.h(7);
            }
            BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().customizeSettings(view, editMode);
            this.getSettings().setFrom(BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getSettings());
            BaseGraphFocusView.this.customizeViewSettings(view, editMode, this.getSettings(), BaseGraphFocusView.this.getModelBuilder());
        }

        @Override
        public void customizeSettings(@NotNull GraphBuilder<N, E> builder) {
            if (builder == null) {
                FocusViewGraphPresentationModel.h(8);
            }
            BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().customizeSettings(builder);
            BaseGraphFocusView.this.customizeViewSettings(builder.getView(), builder.getEditMode(), this.getSettings(), BaseGraphFocusView.this.getModelBuilder());
        }

        @Override
        public void dispose() {
        }

        @Override
        @NotNull
        public ModificationTracker getModificationTrackerOfViewUpdates() {
            SimpleModificationTracker simpleModificationTracker = BaseGraphFocusView.this.myModTrackerOfViewUpdates;
            if (simpleModificationTracker == null) {
                FocusViewGraphPresentationModel.h(9);
            }
            return simpleModificationTracker;
        }

        private static /* synthetic */ void h(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n10) {
                default -> 3;
                case 1, 2, 3, 5, 9 -> 2;
            }];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphPresentationModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphPresentationModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeRealizer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeRealizer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeLabels";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModificationTrackerOfViewUpdates";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getEdgeLabels";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeSettings";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n10) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 9 -> new IllegalStateException(string);
            };
        }
    }

    protected static final class FocusGraphViewControllerBuilder<N, E>
    extends GraphViewControllerBuilder<FocusGraphViewControllerBuilder<N, E>> {
        private FocusGraphViewControllerBuilder(@NotNull GraphBuilder<N, E> focusViewBuilder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
            if (focusViewBuilder == null) {
                FocusGraphViewControllerBuilder.U(0);
            }
            if (dispatcher == null) {
                FocusGraphViewControllerBuilder.U(1);
            }
            super(focusViewBuilder, dispatcher);
        }

        @NotNull
        public static <N, E> FocusGraphViewControllerBuilder<N, E> beginSetupFor(@NotNull GraphBuilder<N, E> graphBuilder) {
            if (graphBuilder == null) {
                FocusGraphViewControllerBuilder.U(2);
            }
            return new FocusGraphViewControllerBuilder<N, E>(graphBuilder, GraphBuilderFactory.getInstance(graphBuilder.getProject()).getGraphBuilderDispatcher(graphBuilder));
        }

        @Override
        @NotNull
        protected FocusGraphViewControllerBuilder<N, E> self() {
            FocusGraphViewControllerBuilder focusGraphViewControllerBuilder = this;
            if (focusGraphViewControllerBuilder == null) {
                FocusGraphViewControllerBuilder.U(3);
            }
            return focusGraphViewControllerBuilder;
        }

        @Override
        public void endSetup() {
            this.setEditModeConstituents(this.getEditMode());
            Graph2DView graph2DView = this.getBuilder().getView();
            JComponent jComponent = graph2DView.getCanvasComponent();
            BaseGraphViewControllerMode baseGraphViewControllerMode = new BaseGraphViewControllerMode(this.getBuilder(), this.getDispatcher(), this.getEditMode(), this.getNavigationMode(), this.getMagnifierViewMode());
            graph2DView.addViewMode(baseGraphViewControllerMode);
            baseGraphViewControllerMode.setupKeyBindingsTo(jComponent);
            jComponent.addFocusListener(baseGraphViewControllerMode);
            jComponent.addMouseWheelListener(new CustomGraphBuilderWheelListener(this.getBuilder()));
            baseGraphViewControllerMode.initialize();
        }

        private static /* synthetic */ void U(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n10) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusViewBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusGraphViewControllerBuilder";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusGraphViewControllerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
            }
            switch (n10) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "beginSetupFor";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n10) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

