/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.hierarchy;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.hierarchy.LspFakePsiElement;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aX\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000526\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bH\u0000\u001a4\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\bH\u0000\u00a8\u0006\u0012"}, d2={"getTargetFromEditor", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "serverKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "serverPredicate", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "server", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "", "findSupportingServer", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspHierarchyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspHierarchyUtil.kt\ncom/intellij/platform/lsp/impl/hierarchy/LspHierarchyUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1#2:40\n777#3:41\n873#3,2:42\n296#3,2:44\n*S KotlinDebug\n*F\n+ 1 LspHierarchyUtil.kt\ncom/intellij/platform/lsp/impl/hierarchy/LspHierarchyUtilKt\n*L\n38#1:41\n38#1:42,2\n39#1:44,2\n*E\n"})
public final class LspHierarchyUtilKt {
    @Nullable
    public static final PsiElement getTargetFromEditor(@NotNull DataContext dataContext, @NotNull Key<LspServerImpl> serverKey, @NotNull Function2<? super LspServerImpl, ? super VirtualFile, Boolean> serverPredicate) {
        LspFakePsiElement lspFakePsiElement;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter(serverKey, (String)"serverKey");
        Intrinsics.checkNotNullParameter(serverPredicate, (String)"serverPredicate");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        int n10 = editor2.getCaretModel().getOffset();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        LspServerImpl lspServerImpl = LspHierarchyUtilKt.findSupportingServer(project2, virtualFile, serverPredicate);
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl lspServerImpl2 = lspServerImpl;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Position position = Lsp4jUtilKt.getLsp4jPosition(document, n10);
        LspFakePsiElement lspFakePsiElement2 = lspFakePsiElement = new LspFakePsiElement(psiFile2, position, null, 4, null);
        boolean bl = false;
        lspFakePsiElement2.putUserData(serverKey, lspServerImpl2);
        return (PsiElement)lspFakePsiElement;
    }

    @Nullable
    public static final LspServerImpl findSupportingServer(@NotNull Project project, @NotNull VirtualFile file, @NotNull Function2<? super LspServerImpl, ? super VirtualFile, Boolean> serverPredicate) {
        Collection collection;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(serverPredicate, (String)"serverPredicate");
            Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getAllRunningServers$intellij_platform_lsp_impl();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection22 = new ArrayList();
            boolean bl2 = false;
            Iterator iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl3 = false;
                if (!lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(file)) continue;
                collection22.add(t2);
            }
            iterable = (List)collection22;
            bl = false;
            for (Collection collection22 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)((Object)collection22);
                boolean bl4 = false;
                if (!((Boolean)serverPredicate.invoke((Object)lspServerImpl, (Object)file)).booleanValue()) continue;
                collection = collection22;
                break block2;
            }
            collection = null;
        }
        return (LspServerImpl)((Object)collection);
    }
}

