/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a!\u0010\n\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"j", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetSelectionRange", "Lorg/eclipse/lsp4j/Range;", "j", "", "Lcom/intellij/openapi/util/NlsSafe;", "targetFileOrDir", "j", "fileOrDir", "position", "Lorg/eclipse/lsp4j/Position;", "TARGET_PRESENTABLE_TEXT_MAX_LENGTH", "", "intellij.platform.lsp.impl"})
public final class LspNavigatableSymbolKt {
    private static final int TARGET_PRESENTABLE_TEXT_MAX_LENGTH = 20;

    private static final TargetPresentation j(VirtualFile virtualFile, Range range) {
        Range range2 = range;
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(LspNavigatableSymbolKt.j(virtualFile, range)).locationText(LspNavigatableSymbolKt.j(virtualFile, (Position)(range2 != null ? range2.getStart() : null))).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    private static final String j(VirtualFile virtualFile, Range range) {
        if (range == null) {
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        Document document2 = document;
        TextRange textRange = Lsp4jUtilKt.getRangeInDocument(document2, range);
        if (textRange == null) {
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        TextRange textRange2 = textRange;
        if (textRange2.getLength() > 0) {
            String string = StringUtil.shortenTextWithEllipsis((String)document2.getText(textRange2), (int)20, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }
        if (document2.getTextLength() <= textRange2.getStartOffset()) {
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        int n10 = Math.min(document2.getTextLength(), textRange2.getStartOffset() + 20);
        return document2.getText(new TextRange(textRange2.getStartOffset(), n10)) + "\u2026";
    }

    private static final String j(VirtualFile virtualFile, Position position) {
        return position == null || virtualFile.isDirectory() ? virtualFile.getName() : virtualFile.getName() + ":" + (position.getLine() + 1) + ":" + (position.getCharacter() + 1);
    }

    public static final /* synthetic */ TargetPresentation access$computeTargetPresentation(VirtualFile targetFile, Range targetSelectionRange) {
        return LspNavigatableSymbolKt.j(targetFile, targetSelectionRange);
    }
}

