/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExternalRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebugProcess;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebugRunner;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerHost;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSessionStartedResult;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.codeWithMe.model.DebuggerModel;
import com.jetbrains.codeWithMe.model.DebuggerSessionModel;
import com.jetbrains.codeWithMe.model.InitialSessionData;
import com.jetbrains.codeWithMe.model.StartCommandArg;
import com.jetbrains.codeWithMe.model.StartCommandResult;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "createSessionData", "Lcom/jetbrains/codeWithMe/model/InitialSessionData;", "contentToReuse", "startDebugSession", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionModel", "Lcom/jetbrains/codeWithMe/model/DebuggerSessionModel;", "debuggerHost", "Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost;", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientDebugRunner.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebugRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n1#2:150\n13#3:151\n*S KotlinDebug\n*F\n+ 1 ThinClientDebugRunner.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebugRunner\n*L\n147#1:151\n*E\n"})
public final class ThinClientDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        AsyncPromise executeResult = new AsyncPromise();
        boolean isLuxDebugger = ThinClientDebuggerHost.Companion.useLuxDebugger();
        if (isLuxDebugger) {
            executeResult.setResult(null);
        }
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ThinClientDebuggerHost debuggerHost = ThinClientDebuggerHost.Companion.getInstance(project);
        DebuggerModel debuggerModel = debuggerHost.getDebuggerModel();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings == null) {
            boolean $i$a$-checkNotNull-ThinClientDebugRunner$execute$settings$22 = false;
            String $i$a$-checkNotNull-ThinClientDebugRunner$execute$settings$22 = "No settings for runner";
            throw new IllegalStateException($i$a$-checkNotNull-ThinClientDebugRunner$execute$settings$22.toString());
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        Project project2 = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ThinClientRunConfigurationsHost runConfigurationHost = ThinClientRunConfigurationsHost.Companion.getInstance(project2);
        String string = runConfigurationHost.getRemoteUniqueId(settings);
        if (string == null) {
            boolean $i$a$-checkNotNull-ThinClientDebugRunner$execute$remoteUniqueId$22 = false;
            String $i$a$-checkNotNull-ThinClientDebugRunner$execute$remoteUniqueId$22 = "No unique id for run configuration";
            throw new IllegalStateException($i$a$-checkNotNull-ThinClientDebugRunner$execute$remoteUniqueId$22.toString());
        }
        String remoteUniqueId = string;
        int commandId = debuggerHost.getNextStartCommandId();
        LifetimeDefinition viewLifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)debuggerHost);
        RdTaskUtilKt.toPromise((IRdTask)debuggerModel.getStartCommand().start((Lifetime)viewLifetime, (Object)new StartCommandArg(remoteUniqueId, commandId, this.createSessionData(environment.getContentToReuse()))), (Lifetime)((Lifetime)viewLifetime)).onSuccess(arg_0 -> ThinClientDebugRunner.execute$lambda$3(arg_0 -> ThinClientDebugRunner.execute$lambda$2(viewLifetime, isLuxDebugger, executeResult, debuggerHost, commandId, arg_0), arg_0)).onError(arg_0 -> ThinClientDebugRunner.execute$lambda$5(arg_0 -> ThinClientDebugRunner.execute$lambda$4(viewLifetime, isLuxDebugger, executeResult, debuggerHost, commandId, arg_0), arg_0));
        debuggerModel.getSessions().view((Lifetime)viewLifetime, (arg_0, arg_1, arg_2) -> ThinClientDebugRunner.execute$lambda$6(commandId, executeResult, environment, this, debuggerHost, runConfigurationHost, isLuxDebugger, viewLifetime, arg_0, arg_1, arg_2));
        return (Promise)executeResult;
    }

    private final InitialSessionData createSessionData(RunContentDescriptor contentToReuse) {
        JComponent component;
        boolean areBreakpointsMuted = false;
        if (contentToReuse != null && (component = contentToReuse.getComponent()) != null) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            XDebugSessionData oldSessionData = (XDebugSessionData)XDebugSessionData.DATA_KEY.getData(dataContext);
            if (oldSessionData != null) {
                areBreakpointsMuted = oldSessionData.isBreakpointsMuted();
            }
        }
        return new InitialSessionData(areBreakpointsMuted);
    }

    private final RunContentDescriptor startDebugSession(ExecutionEnvironment environment, Lifetime sessionLifetime, DebuggerSessionModel sessionModel, ThinClientDebuggerHost debuggerHost) {
        XDebugProcessStarter starter2 = new XDebugProcessStarter(sessionLifetime, sessionModel){
            final /* synthetic */ Lifetime $sessionLifetime;
            final /* synthetic */ DebuggerSessionModel $sessionModel;
            {
                this.$sessionLifetime = $sessionLifetime;
                this.$sessionModel = $sessionModel;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                this.$sessionLifetime.onTerminationIfAlive(() -> startDebugSession.starter.1.start$lambda$0(session));
                return (XDebugProcess)new ThinClientDebugProcess(session, this.$sessionLifetime, this.$sessionModel);
            }

            private static final Unit start$lambda$0(XDebugSession $session) {
                $session.stop();
                return Unit.INSTANCE;
            }
        };
        XSessionStartedResult result = XDebuggerManager.getInstance((Project)environment.getProject()).newSessionBuilder(starter2).environment(environment).startSession();
        debuggerHost.handleSessionModel(result.getSession(), sessionModel);
        RunContentDescriptor runContentDescriptor = result.getRunContentDescriptor();
        Intrinsics.checkNotNull((Object)runContentDescriptor);
        return runContentDescriptor;
    }

    @NotNull
    public String getRunnerId() {
        return "ThinClientDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)"Debug") && profile instanceof RunConfiguration && ThinClientPermissionHost.Companion.getInstance().hasRunAccess() && (profile instanceof ThinClientRunConfiguration || profile instanceof ThinClientExternalRunConfiguration);
    }

    private static final Unit execute$lambda$2$0(AsyncPromise $this$setExecutionResult) {
        Intrinsics.checkNotNullParameter((Object)$this$setExecutionResult, (String)"$this$setExecutionResult");
        $this$setExecutionResult.setResult(null);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$4$0(Throwable $it, AsyncPromise $this$setExecutionResult) {
        Intrinsics.checkNotNullParameter((Object)$this$setExecutionResult, (String)"$this$setExecutionResult");
        Object object = $it instanceof RdFault ? (RdFault)$it : null;
        if ((object == null || (object = object.getReasonMessage()) == null) && (object = $it.getMessage()) == null) {
            object = "";
        }
        Object message = object;
        $this$setExecutionResult.setError((String)message);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$6$1(RunContentDescriptor $runContentDescriptor, AsyncPromise $this$setExecutionResult) {
        Intrinsics.checkNotNullParameter((Object)$this$setExecutionResult, (String)"$this$setExecutionResult");
        $this$setExecutionResult.setResult((Object)$runContentDescriptor);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$6$2(LifetimeDefinition $viewLifetime) {
        $viewLifetime.terminate(true);
        return Unit.INSTANCE;
    }

    private static final void execute$setExecutionResult(boolean isLuxDebugger, AsyncPromise<RunContentDescriptor> executeResult, ThinClientDebuggerHost debuggerHost, int commandId, Function1<? super AsyncPromise<RunContentDescriptor>, Unit> block) {
        if (!isLuxDebugger) {
            if (executeResult.isDone()) {
                logger.error("Trying to set an already set promise");
            }
            block.invoke(executeResult);
        }
        debuggerHost.markCommandIdCompleted(commandId);
    }

    private static final Unit execute$lambda$2(LifetimeDefinition $viewLifetime, boolean $isLuxDebugger, AsyncPromise $executeResult, ThinClientDebuggerHost $debuggerHost, int $commandId, StartCommandResult it) {
        if (!it.getSuccess()) {
            ThinClientDebugRunner.execute$setExecutionResult($isLuxDebugger, (AsyncPromise<RunContentDescriptor>)$executeResult, $debuggerHost, $commandId, (Function1<? super AsyncPromise<RunContentDescriptor>, Unit>)((Function1)ThinClientDebugRunner::execute$lambda$2$0));
            LifetimeDefinition.terminate$default((LifetimeDefinition)$viewLifetime, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$4(LifetimeDefinition $viewLifetime, boolean $isLuxDebugger, AsyncPromise $executeResult, ThinClientDebuggerHost $debuggerHost, int $commandId, Throwable it) {
        ThinClientDebugRunner.execute$setExecutionResult($isLuxDebugger, (AsyncPromise<RunContentDescriptor>)$executeResult, $debuggerHost, $commandId, (Function1<? super AsyncPromise<RunContentDescriptor>, Unit>)((Function1)arg_0 -> ThinClientDebugRunner.execute$lambda$4$0(it, arg_0)));
        LifetimeDefinition.terminate$default((LifetimeDefinition)$viewLifetime, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$6(int $commandId, AsyncPromise $executeResult, ExecutionEnvironment $environment, ThinClientDebugRunner this$0, ThinClientDebuggerHost $debuggerHost, ThinClientRunConfigurationsHost $runConfigurationHost, boolean $isLuxDebugger, LifetimeDefinition $viewLifetime, Lifetime sessionLifetime, int n, DebuggerSessionModel sessionModel) {
        Object v2;
        ExecutionEnvironmentBuilder builder;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
            Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
            ThreadingAssertions.assertEventDispatchThread();
            Integer n2 = sessionModel.getStartCommandId();
            int n3 = $commandId;
            if (n2 == null || n2 != n3 || $executeResult.isDone()) {
                return Unit.INSTANCE;
            }
            builder = new ExecutionEnvironmentBuilder($environment);
            Project project = $environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(project);
            Iterable iterable = runManager.getAllSettings();
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$runConfigurationHost.getRemoteUniqueId(it), (Object)sessionModel.getUniqueID())) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        RunnerAndConfigurationSettings effectiveSettings = v2;
        if (effectiveSettings != null) {
            RunConfiguration runConfiguration = effectiveSettings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            builder.runProfile((RunProfile)runConfiguration);
        }
        ExecutionEnvironment effectiveEnvironment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder, null, (int)1, null);
        RunContentDescriptor runContentDescriptor = this$0.startDebugSession(effectiveEnvironment, sessionLifetime, sessionModel, $debuggerHost);
        ThinClientDebugRunner.execute$setExecutionResult($isLuxDebugger, (AsyncPromise<RunContentDescriptor>)$executeResult, $debuggerHost, $commandId, (Function1<? super AsyncPromise<RunContentDescriptor>, Unit>)((Function1)arg_0 -> ThinClientDebugRunner.execute$lambda$6$1(runContentDescriptor, arg_0)));
        sessionLifetime.onTermination(() -> ThinClientDebugRunner.execute$lambda$6$2($viewLifetime));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientDebugRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientDebugRunner.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebugRunner$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

