/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientNamedValue;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientValueGroup;
import com.intellij.util.ModalityUiUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.codeWithMe.model.ChildrenListLive;
import com.jetbrains.codeWithMe.model.ImmutableListChildrenWrapper;
import com.jetbrains.codeWithMe.model.ValueGroupModel;
import com.jetbrains.codeWithMe.model.ValueModel;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.ValueEntityModelBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IViewableList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u0002H\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013JS\u0010\u0014\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\b2\u0006\u0010\n\u001a\u0002H\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J8\u0010\u0017\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00050\u001cH\u0002J6\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientValueContainerBase;", "", "<init>", "()V", "computeChildrenLive", "", "T", "call", "Lcom/jetbrains/rd/framework/impl/RdCall;", "Lcom/jetbrains/codeWithMe/model/ChildrenListLive;", "arg", "session", "Lcom/intellij/xdebugger/XDebugSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/jetbrains/rd/framework/impl/RdCall;Ljava/lang/Object;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/frame/XCompositeNode;Lcom/intellij/openapi/diagnostic/Logger;)V", "computeChildren", "", "Lcom/jetbrains/rd/ide/model/ValueEntityModelBase;", "handleResult", "R", "result", "Lcom/jetbrains/rd/framework/RdTaskResult;", "block", "Lkotlin/Function1;", "addChildrenWithGroups", "fields", "intellij.platform.execution.frontend.split"})
public final class ThinClientValueContainerBase {
    @NotNull
    public static final ThinClientValueContainerBase INSTANCE = new ThinClientValueContainerBase();

    private ThinClientValueContainerBase() {
    }

    public final <T> void computeChildrenLive(@NotNull RdCall<T, ChildrenListLive> call, T arg, @NotNull XDebugSession session, @NotNull Lifetime lifetime, @NotNull XCompositeNode node, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ThinClientValueContainerBase.computeChildrenLive$lambda$0(node, lifetime, call, arg, session, logger));
    }

    public final <T> void computeChildren(@NotNull RdCall<T, List<ValueEntityModelBase>> call, T arg, @NotNull XDebugSession session, @NotNull Lifetime lifetime, @NotNull XCompositeNode node, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ThinClientValueContainerBase.computeChildren$lambda$0(node, lifetime, call, arg, session, logger));
    }

    private final <R> void handleResult(RdTaskResult<? extends R> result, XCompositeNode node, Function1<? super R, Unit> block) {
        RdTaskResult<? extends R> rdTaskResult = result;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            block.invoke(((RdTaskResult.Success)result).getValue());
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            node.setErrorMessage(((RdTaskResult.Fault)result).getError().getReasonMessage());
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            node.setErrorMessage("Task was cancelled");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addChildrenWithGroups(List<? extends ValueEntityModelBase> fields, XDebugSession session, Lifetime lifetime, XCompositeNode node, Logger logger) {
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList children = new XValueChildrenList();
        boolean wasValueList = false;
        for (ValueEntityModelBase valueEntityModelBase : fields) {
            ValueEntityModelBase valueEntityModelBase2 = valueEntityModelBase;
            if (valueEntityModelBase2 instanceof ValueModel) {
                wasValueList = true;
                children.add((XNamedValue)new ThinClientNamedValue(lifetime, session, (ValueModel)valueEntityModelBase));
                continue;
            }
            if (valueEntityModelBase2 instanceof ValueGroupModel) {
                ThinClientValueGroup group = new ThinClientValueGroup(lifetime, session, (ValueGroupModel)valueEntityModelBase);
                List targetGroup = !wasValueList ? children.getTopGroups() : children.getBottomGroups();
                targetGroup.add(group);
                continue;
            }
            logger.error("Unknown type of model: " + valueEntityModelBase.getClass());
        }
        node.addChildren(children, true);
    }

    private static final void computeChildrenLive$lambda$0$0$0$1$0(Lifetime $lifetime, ChildrenListLive $it) {
        if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
            return;
        }
        $it.getGetNextChildren().fire((Object)Unit.INSTANCE);
    }

    private static final Unit computeChildrenLive$lambda$0$0$0$0(XDebugSession $session, Lifetime $lifetime, XCompositeNode $node, Logger $logger, IViewableList.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof IViewableList.Event.Add)) {
            throw new IllegalArgumentException("Only Add event is allowed for live children list, received event: " + event);
        }
        INSTANCE.addChildrenWithGroups(((ImmutableListChildrenWrapper)((IViewableList.Event.Add)event).getNewValue()).getList(), $session, $lifetime, $node, $logger);
        return Unit.INSTANCE;
    }

    private static final Unit computeChildrenLive$lambda$0$0$0$1(XCompositeNode $node, Lifetime $lifetime, ChildrenListLive $it, int remaining) {
        $node.tooManyChildren(remaining, () -> ThinClientValueContainerBase.computeChildrenLive$lambda$0$0$0$1$0($lifetime, $it));
        return Unit.INSTANCE;
    }

    private static final Unit computeChildrenLive$lambda$0$0$0(Lifetime $lifetime, XDebugSession $session, XCompositeNode $node, Logger $logger, ChildrenListLive it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.getChildren().advise($lifetime, arg_0 -> ThinClientValueContainerBase.computeChildrenLive$lambda$0$0$0$0($session, $lifetime, $node, $logger, arg_0));
        it.getTooManyChildren().advise($lifetime, arg_0 -> ThinClientValueContainerBase.computeChildrenLive$lambda$0$0$0$1($node, $lifetime, it, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit computeChildrenLive$lambda$0$0(XCompositeNode $node, Lifetime $lifetime, XDebugSession $session, Logger $logger, RdTaskResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        INSTANCE.handleResult(result, $node, arg_0 -> ThinClientValueContainerBase.computeChildrenLive$lambda$0$0$0($lifetime, $session, $node, $logger, arg_0));
        return Unit.INSTANCE;
    }

    private static final void computeChildrenLive$lambda$0(XCompositeNode $node, Lifetime $lifetime, RdCall $call, Object $arg, XDebugSession $session, Logger $logger) {
        if ($node.isObsolete() || RLifetimeKt.isNotAlive((Lifetime)$lifetime) || !$call.isBound()) {
            return;
        }
        $call.start($lifetime, $arg).getResult().advise($lifetime, arg_0 -> ThinClientValueContainerBase.computeChildrenLive$lambda$0$0($node, $lifetime, $session, $logger, arg_0));
    }

    private static final Unit computeChildren$lambda$0$0$0(XDebugSession $session, Lifetime $lifetime, XCompositeNode $node, Logger $logger, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.addChildrenWithGroups(it, $session, $lifetime, $node, $logger);
        return Unit.INSTANCE;
    }

    private static final Unit computeChildren$lambda$0$0(XCompositeNode $node, XDebugSession $session, Lifetime $lifetime, Logger $logger, RdTaskResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        INSTANCE.handleResult(result, $node, arg_0 -> ThinClientValueContainerBase.computeChildren$lambda$0$0$0($session, $lifetime, $node, $logger, arg_0));
        return Unit.INSTANCE;
    }

    private static final void computeChildren$lambda$0(XCompositeNode $node, Lifetime $lifetime, RdCall $call, Object $arg, XDebugSession $session, Logger $logger) {
        if ($node.isObsolete() || RLifetimeKt.isNotAlive((Lifetime)$lifetime) || !$call.isBound()) {
            return;
        }
        $call.start($lifetime, $arg).getResult().advise($lifetime, arg_0 -> ThinClientValueContainerBase.computeChildren$lambda$0$0($node, $session, $lifetime, $logger, arg_0));
    }
}

