/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.EnversProperties;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.orm.IntellijDatabaseManager;
import com.intellij.liquibase.orm.LiquibaseGenerationContext;
import com.intellij.liquibase.orm.gui.DiffScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import liquibase.ext.intellij.database.connection.IntellijConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="use provider")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/orm/JpbIntellijDatabaseManager;", "Lcom/intellij/liquibase/orm/IntellijDatabaseManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "enversService", "Lcom/intellij/jpa/jpb/model/service/EnversService;", "findEntityByTableName", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "intellijConnection", "Lliquibase/ext/intellij/database/connection/IntellijConnection;", "tableName", "", "collectEntitiesToProcess", "", "collectAllEntities", "generationContext", "Lcom/intellij/liquibase/orm/LiquibaseGenerationContext;", "diffScope", "Lcom/intellij/liquibase/orm/gui/DiffScope;", "collectEntities", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "persistenceUnitName", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nJpbIntellijDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpbIntellijDatabaseManager.kt\ncom/intellij/liquibase/orm/JpbIntellijDatabaseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n1#2:108\n777#3:109\n873#3,2:110\n13#4:112\n*S KotlinDebug\n*F\n+ 1 JpbIntellijDatabaseManager.kt\ncom/intellij/liquibase/orm/JpbIntellijDatabaseManager\n*L\n90#1:109\n90#1:110,2\n92#1:112\n*E\n"})
public final class JpbIntellijDatabaseManager
extends IntellijDatabaseManager {
    @NotNull
    private final EnversService enversService;

    public JpbIntellijDatabaseManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.enversService = EnversService.Companion.getInstance(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public OrmEntity findEntityByTableName(@NotNull IntellijConnection intellijConnection, @NotNull String tableName) {
        CustomJpaOrmEntity customJpaOrmEntity;
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        OrmEntity entity = super.findEntityByTableName(intellijConnection, tableName);
        if (entity != null) return entity;
        if (!Intrinsics.areEqual((Object)intellijConnection.getGenerationContext().getOrmFramework(), (Object)JpaOrmFramework.INSTANCE)) return entity;
        if (!JpaUtils.isHibernateEnversProject((Project)this.getProject(), null)) {
            return entity;
        }
        Entity revisionEntity = this.enversService.getRevisionEntity();
        if (StringsKt.equals((String)tableName, (String)revisionEntity.getTable(), (boolean)true)) {
            return (OrmEntity)new CustomJpaOrmEntity(revisionEntity);
        }
        EnversProperties enversProps = this.enversService.getActualEnversProperties();
        if (StringsKt.startsWith$default((String)tableName, (String)enversProps.getAuditTablePrefix(), (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)tableName, (String)enversProps.getAuditTableSuffix(), (boolean)false, (int)2, null)) {
            CustomJpaOrmEntity customJpaOrmEntity2;
            OrmEntity ormEntity = super.findEntityByTableName(intellijConnection, StringsKt.removeSurrounding((String)tableName, (CharSequence)enversProps.getAuditTablePrefix(), (CharSequence)enversProps.getAuditTableSuffix()));
            if (ormEntity != null) {
                OrmEntity it = ormEntity;
                boolean bl = false;
                Entity entity2 = OrmUtil.INSTANCE.getEntityByOrmEntity(it);
                if (entity2 != null) {
                    Entity it2 = entity2;
                    boolean bl2 = false;
                    EntityPsi entityPsi = it2 instanceof EntityPsi ? (EntityPsi)it2 : null;
                    if (entityPsi != null) {
                        EntityPsi it3 = entityPsi;
                        boolean bl3 = false;
                        it = AuditEntity.Companion.getInstance(it3);
                        if (it != null) {
                            it3 = it;
                            boolean bl4 = false;
                            customJpaOrmEntity2 = new CustomJpaOrmEntity((Entity)it3);
                            return (OrmEntity)customJpaOrmEntity2;
                        }
                    }
                }
            }
            customJpaOrmEntity2 = null;
            return (OrmEntity)customJpaOrmEntity2;
        }
        PsiClass psiClass = EntitySearch.getInstance((Project)this.getProject()).findByAuditTableName(tableName);
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)it);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            AuditEntity auditEntity = AuditEntity.Companion.getInstance(entityPsi);
            if (auditEntity != null) {
                it = auditEntity;
                boolean bl5 = false;
                customJpaOrmEntity = new CustomJpaOrmEntity((Entity)it);
                return (OrmEntity)customJpaOrmEntity;
            }
        }
        customJpaOrmEntity = null;
        return (OrmEntity)customJpaOrmEntity;
    }

    @Override
    @NotNull
    public List<OrmEntity> collectEntitiesToProcess(@NotNull IntellijConnection intellijConnection) {
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        LiquibaseGenerationContext generationContext = intellijConnection.getGenerationContext();
        Intrinsics.checkNotNull((Object)generationContext);
        return this.collectEntitiesToProcess(generationContext, generationContext.getDiffScope());
    }

    @Override
    @NotNull
    public List<OrmEntity> collectAllEntities(@NotNull IntellijConnection intellijConnection) {
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        LiquibaseGenerationContext generationContext = intellijConnection.getGenerationContext();
        Intrinsics.checkNotNull((Object)generationContext);
        return this.collectEntitiesToProcess(generationContext, DiffScope.AllPlaces);
    }

    private final List<OrmEntity> collectEntitiesToProcess(LiquibaseGenerationContext generationContext, DiffScope diffScope) {
        String persistenceUnitName = generationContext.getPersistenceUnitName();
        OrmFramework ormFramework = generationContext.getOrmFramework();
        CacheKeyStore cacheKeyStore = CacheKeyStore.Companion.getInstance(this.getProject());
        String string = persistenceUnitName;
        if (string == null) {
            string = "all_persistence_units";
        }
        Key key = cacheKeyStore.getKey((Object)(string + " - " + diffScope.getId() + " - " + ormFramework.getName()));
        Object object = CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this.getProject(), key, () -> JpbIntellijDatabaseManager.collectEntitiesToProcess$lambda$0(this, ormFramework, persistenceUnitName, diffScope), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OrmEntity> collectEntities(OrmFramework ormFramework, String persistenceUnitName, DiffScope diffScope) {
        List list;
        GlobalSearchScope searchScope = diffScope.toSearchScope(this.getProject());
        OrmUnitsProvider unitsProvider = OrmUnitsProvider.Companion.getForFramework(ormFramework);
        if (persistenceUnitName == null) {
            list = unitsProvider.getUnits(this.getProject());
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = unitsProvider.getUnits(this.getProject());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OrmUnit it = (OrmUnit)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)persistenceUnitName, (Object)it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List persistenceUnits = list;
        if (persistenceUnits.isEmpty()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JpbIntellijDatabaseManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Persistence unit '" + persistenceUnitName + "' not found");
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)persistenceUnits), JpbIntellijDatabaseManager::collectEntities$lambda$1), arg_0 -> JpbIntellijDatabaseManager.collectEntities$lambda$2(searchScope, diffScope, arg_0)), JpbIntellijDatabaseManager::collectEntities$lambda$3));
    }

    private static final CachedValueProvider.Result collectEntitiesToProcess$lambda$0(JpbIntellijDatabaseManager this$0, OrmFramework $ormFramework, String $persistenceUnitName, DiffScope $diffScope) {
        List list;
        List entities = this$0.collectEntities($ormFramework, $persistenceUnitName, $diffScope);
        if ($ormFramework instanceof JpaOrmFramework && JpaUtils.isHibernateEnversProject((Project)this$0.getProject(), null)) {
            List auditEntities = EnversService.Companion.getInstance(this$0.getProject()).getAuditOrmEntities(entities);
            list = CollectionsKt.plus((Collection)entities, (Iterable)auditEntities);
        } else {
            list = entities;
        }
        List allEntities = list;
        Object[] objectArray = new Object[]{PsiModificationTracker.getInstance((Project)this$0.getProject())};
        return CachedValueProvider.Result.create(allEntities, (Object[])objectArray);
    }

    private static final Iterable collectEntities$lambda$1(OrmUnit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEntities();
    }

    private static final boolean collectEntities$lambda$2(GlobalSearchScope $searchScope, DiffScope $diffScope, OrmEntity it) {
        PsiClass psiElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SmartPsiElementPointer smartPsiElementPointer = it.getClassPsiPointer();
        Object object = psiElement = smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null;
        return psiElement != null ? PsiSearchScopeUtil.isInScope((GlobalSearchScope)$searchScope, (PsiElement)((PsiElement)psiElement)) : $diffScope == DiffScope.AllPlaces;
    }

    private static final SmartPsiElementPointer collectEntities$lambda$3(OrmEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getClassPsiPointer();
    }
}

