/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.core.model.dbtype.OracleType;
import com.intellij.jpa.jpb.model.core.util.StringExtensionsKt;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BigIntType;
import liquibase.datatype.core.DecimalType;
import liquibase.datatype.core.DoubleType;
import liquibase.datatype.core.FloatType;
import liquibase.datatype.core.IntType;
import liquibase.datatype.core.NumberType;
import liquibase.datatype.core.SmallIntType;
import liquibase.datatype.core.TinyIntType;
import liquibase.ext.intellij.snapshot.formatter.BasicFormatterImpl;
import liquibase.ext.intellij.snapshot.formatter.DDLFormatterImpl;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.core.DataType;
import liquibase.util.SqlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lliquibase/ext/intellij/snapshot/HSqlUtil;", "", "<init>", "()V", "Companion", "intellij.liquibase.orm"})
public final class HSqlUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final Object parseValue(@NotNull Database database, @Nullable Object value, @NotNull DataType type) {
        return Companion.parseValue(database, value, type);
    }

    @JvmStatic
    @NotNull
    public static final String reformatSql(@NotNull DbProperties dbProperties, @NotNull String sql, @NotNull Project project) {
        return Companion.reformatSql(dbProperties, sql, project);
    }

    @JvmStatic
    @NotNull
    public static final String removeTypeCasts(@NotNull String stringValue) {
        return Companion.removeTypeCasts(stringValue);
    }

    @JvmStatic
    public static final boolean isNumericType(@NotNull String typeName) {
        return Companion.isNumericType(typeName);
    }

    @JvmStatic
    @NotNull
    public static final String getSqlLanguageDialect(@NotNull DbType dbType) {
        return Companion.getSqlLanguageDialect(dbType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u0019"}, d2={"Lliquibase/ext/intellij/snapshot/HSqlUtil$Companion;", "", "<init>", "()V", "parseValue", "database", "Lliquibase/database/Database;", "value", "type", "Lliquibase/structure/core/DataType;", "reformatSql", "", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "sql", "project", "Lcom/intellij/openapi/project/Project;", "removeTypeCasts", "stringValue", "isNumericType", "", "typeName", "getSqlLanguageDialect", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "intellij.liquibase.orm"})
    @SourceDebugExtension(value={"SMAP\nHSqlUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSqlUtil.kt\nliquibase/ext/intellij/snapshot/HSqlUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n296#2,2:150\n13225#3,2:152\n13225#3,2:154\n*S KotlinDebug\n*F\n+ 1 HSqlUtil.kt\nliquibase/ext/intellij/snapshot/HSqlUtil$Companion\n*L\n129#1:150,2\n86#1:152,2\n92#1:154,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Object parseValue(@NotNull Database database, @Nullable Object value, @NotNull DataType type) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Object object = SqlUtil.parseValue((Database)database, (Object)value, (DataType)type);
            if (object == null) {
                return null;
            }
            Object parsedValue = object;
            if (!(value instanceof String)) {
                return parsedValue;
            }
            String trimmedValue = ((Object)StringsKt.trim((CharSequence)((String)value))).toString();
            if (parsedValue instanceof DatabaseFunction) {
                Double convertedValue;
                Integer n = type.getDataTypeId();
                int typeId = n != null ? n : Integer.MIN_VALUE;
                LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(type, database);
                Number number = liquibaseDataType instanceof DoubleType || typeId == 8 ? (Number)StringsKt.toDoubleOrNull((String)trimmedValue) : (Number)(liquibaseDataType instanceof DecimalType || typeId == 3 || liquibaseDataType instanceof NumberType || typeId == 2 ? StringsKt.toBigDecimalOrNull((String)trimmedValue) : (liquibaseDataType instanceof BigIntType || typeId == -5 ? StringsKt.toBigIntegerOrNull((String)trimmedValue) : (liquibaseDataType instanceof FloatType || typeId == 6 ? (Number)StringsKt.toFloatOrNull((String)trimmedValue) : (Number)(convertedValue = liquibaseDataType instanceof IntType || typeId == 4 || liquibaseDataType instanceof SmallIntType || typeId == 5 || liquibaseDataType instanceof TinyIntType || typeId == -6 ? StringsKt.toIntOrNull((String)trimmedValue) : null))));
                if (convertedValue != null) {
                    return convertedValue;
                }
            }
            return parsedValue;
        }

        @JvmStatic
        @NotNull
        public final String reformatSql(@NotNull DbProperties dbProperties, @NotNull String sql, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (StringsKt.isBlank((CharSequence)sql)) {
                return sql;
            }
            String trimmedSql = ((Object)StringsKt.trim((CharSequence)sql)).toString();
            DbType dbType = dbProperties.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
            Language sqlLanguage = Language.findLanguageByID((String)this.getSqlLanguageDialect(dbType));
            if (sqlLanguage != null) {
                PsiFile sqlFile = PsiFileFactory.getInstance((Project)project).createFileFromText(sqlLanguage, (CharSequence)trimmedSql);
                new ReformatCodeProcessor(sqlFile, false).runWithoutProgress();
                String string = sqlFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return string;
            }
            return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)trimmedSql), (CharSequence)"\n", null, null, (int)0, null, Companion::reformatSql$lambda$0, (int)30, null))).toString();
        }

        @JvmStatic
        @NotNull
        public final String removeTypeCasts(@NotNull String stringValue) {
            Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
            String funArgs = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)stringValue, (String)"(", null, (int)2, null), (String)")", null, (int)2, null);
            boolean isFunResCast = StringsKt.contains$default((CharSequence)stringValue, (CharSequence)(funArgs + ")::"), (boolean)false, (int)2, null);
            if (!Intrinsics.areEqual((Object)stringValue, (Object)funArgs) && !isFunResCast) {
                String[] stringArray = new String[]{","};
                String funArgsWithNoCasts = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)funArgs, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)", ", null, null, (int)0, null, Companion::removeTypeCasts$lambda$0, (int)30, null);
                return StringsKt.replace$default((String)stringValue, (String)funArgs, (String)funArgsWithNoCasts, (boolean)false, (int)4, null);
            }
            int index = StringsKt.lastIndexOf$default((CharSequence)stringValue, (String)"::", (int)0, (boolean)false, (int)6, null);
            if (index < 0) {
                return stringValue;
            }
            String string = stringValue.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String expr = string;
            String string2 = stringValue.substring(index + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String type = string2;
            if (isFunResCast) {
                return this.removeTypeCasts(expr);
            }
            if (StringExtensionsKt.isSurrounded((String)expr, (char)'\'') && this.isNumericType(type)) {
                return StringsKt.removeSurrounding((String)expr, (CharSequence)"'");
            }
            return expr;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean isNumericType(@NotNull String typeName) {
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                Iterable iterable = (Iterable)HibernateSqlType.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HibernateSqlType it = (HibernateSqlType)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.name(), (String)typeName, (boolean)true)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            HibernateSqlType hibernateSqlType = v0;
            if (hibernateSqlType == null) {
                return false;
            }
            int typeCode = hibernateSqlType.getSqlCode();
            return SqlUtil.isNumeric((int)typeCode);
        }

        @JvmStatic
        @NotNull
        public final String getSqlLanguageDialect(@NotNull DbType dbType) {
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            DbType dbType2 = dbType;
            return Intrinsics.areEqual((Object)dbType2, (Object)DbType.POSTGRES) ? "PostgreSQL" : (dbType2 instanceof MssqlType ? "TSQL" : (dbType2 instanceof OracleType ? "Oracle" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL_FILE) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL_INMEMORY) ? "HSQLDB" : (dbType2 instanceof MysqlType ? "MySQL" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MARIA) ? "MariaDB" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.H2) ? "H2" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.DB2) ? "DB2" : "SQL")))))));
        }

        private static final CharSequence reformatSql$lambda$0(String s) {
            CharSequence charSequence;
            boolean bl;
            String statement;
            String element$iv;
            int n;
            int n2;
            String[] $this$any$iv;
            boolean $i$f$any;
            block6: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String[] stringArray = new String[]{"select", "insert", "update", "delete"};
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    statement = element$iv = $this$any$iv[n];
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)s, (String)statement, (boolean)true)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                String string = BasicFormatterImpl.INSTANCE.format(s);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                charSequence = string;
            } else {
                boolean bl3;
                block7: {
                    $this$any$iv = new String[]{"create table", "alter table", "comment on"};
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        statement = element$iv = $this$any$iv[n];
                        boolean bl4 = false;
                        if (!StringsKt.startsWith((String)s, (String)statement, (boolean)true)) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    String string = DDLFormatterImpl.INSTANCE.format(s);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    charSequence = string;
                } else {
                    charSequence = s;
                }
            }
            return charSequence;
        }

        private static final CharSequence removeTypeCasts$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.removeTypeCasts(((Object)StringsKt.trim((CharSequence)it)).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

