/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;

public class SequenceSnapshotGenerator
extends IntellijSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class)) {
            return;
        }
        if (!(foundObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        List<OrmEntity> entities = database.getOrmFramework() == JpaOrmFramework.INSTANCE ? database.getOrmEntitiesToProcess(schema) : database.getAllOrmEntities();
        database.getLiquibaseGenerator().generateSequences(schema, entities).forEach(arg_0 -> ((Schema)schema).addDatabaseObject(arg_0));
    }
}

