/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ex.ToolLanguageUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate,
Comparable<IntentionAction> {
    private final IntentionActionBean extension;
    private IntentionAction instance;
    private String fullFamilyName;
    private volatile Set<String> applicableToLanguages;

    public IntentionActionWrapper(@NotNull IntentionActionBean extension) {
        if (extension == null) {
            IntentionActionWrapper.$$$reportNull$$$0(0);
        }
        this.extension = extension;
    }

    @NotNull
    public String getDescriptionDirectoryName() {
        return IntentionActionWrapper.getDescriptionDirectoryName(this.getImplementationClassName());
    }

    @ApiStatus.Internal
    @NotNull
    public static String getDescriptionDirectoryName(@NotNull String fqn) {
        if (fqn == null) {
            IntentionActionWrapper.$$$reportNull$$$0(1);
        }
        String string = fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getDelegate().getText();
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getDelegate().getFamilyName();
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isApplicable(@NotNull Collection<String> fileLanguageIds) {
        String language;
        if (fileLanguageIds == null) {
            IntentionActionWrapper.$$$reportNull$$$0(5);
        }
        if ((language = this.extension.language) == null || "any".equals(language) || language.isBlank()) {
            return true;
        }
        Set languages = this.applicableToLanguages;
        if (languages == null) {
            this.applicableToLanguages = languages = ToolLanguageUtil.getAllMatchingLanguages((String)language, (boolean)true);
        }
        return ContainerUtil.intersects(fileLanguageIds, languages);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            IntentionActionWrapper.$$$reportNull$$$0(6);
        }
        return this.getDelegate().isAvailable(project, editor, psiFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            IntentionActionWrapper.$$$reportNull$$$0(7);
        }
        this.getDelegate().invoke(project, editor, psiFile);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            IntentionActionWrapper.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            IntentionActionWrapper.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            IntentionActionWrapper.$$$reportNull$$$0(10);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.getDelegate().generatePreview(project, editor, psiFile);
        if (intentionPreviewInfo == null) {
            IntentionActionWrapper.$$$reportNull$$$0(11);
        }
        return intentionPreviewInfo;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            IntentionActionWrapper.$$$reportNull$$$0(12);
        }
        return this.getDelegate().getElementToMakeWritable(file);
    }

    @NotNull
    public String getFullFamilyName() {
        String result = this.fullFamilyName;
        if (result == null) {
            CharSequence[] categories = this.extension.getCategories();
            result = categories != null ? String.join((CharSequence)"/", categories) + "/" + this.getFamilyName() : this.getFamilyName();
            this.fullFamilyName = result;
        }
        String string = result;
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public IntentionAction getDelegate() {
        if (this.instance == null) {
            IntentionAction action;
            CommonIntentionAction base = (CommonIntentionAction)this.extension.getInstance();
            this.instance = base instanceof IntentionAction ? (action = (IntentionAction)base) : base.asIntention();
        }
        IntentionAction intentionAction = this.instance;
        if (intentionAction == null) {
            IntentionActionWrapper.$$$reportNull$$$0(14);
        }
        return intentionAction;
    }

    @NotNull
    public String getImplementationClassName() {
        String string = this.extension.className;
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(15);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public ClassLoader getImplementationClassLoader() {
        ClassLoader classLoader = this.extension.getLoaderForClass();
        if (classLoader == null) {
            IntentionActionWrapper.$$$reportNull$$$0(16);
        }
        return classLoader;
    }

    public String toString() {
        String text;
        try {
            text = this.getText();
        }
        catch (PsiInvalidElementAccessException e) {
            text = e.getMessage();
        }
        ModCommandAction modCommand = this.asModCommandAction();
        Class cls = modCommand == null ? this.getDelegate().getClass() : modCommand.getClass();
        return "Intention: (" + cls.getName() + "): '" + text + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        ShortcutSet shortcutSet;
        IntentionAction delegate = this.getDelegate();
        if (delegate instanceof ShortcutProvider) {
            ShortcutProvider shortcut = (ShortcutProvider)delegate;
            shortcutSet = shortcut.getShortcut();
        } else {
            shortcutSet = null;
        }
        return shortcutSet;
    }

    @Override
    public int compareTo(@NotNull IntentionAction other) {
        if (other == null) {
            IntentionActionWrapper.$$$reportNull$$$0(17);
        }
        if (other instanceof IntentionActionWrapper) {
            IntentionActionWrapper wrapper = (IntentionActionWrapper)other;
            IntentionAction action1 = this.getDelegate();
            IntentionAction action2 = wrapper.getDelegate();
            if (action1 instanceof Comparable && action2 instanceof Comparable) {
                return ((Comparable)action1).compareTo(action2);
            }
        }
        return this.getText().compareTo(other.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 11, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguageIds";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionDirectoryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionDirectoryName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 11, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

