/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.InspectionVisitorOptimizer;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolLanguageUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class InspectionEngine {
    private static final Logger LOG = Logger.getInstance(InspectionEngine.class);
    private static final Set<String> ourToolsWithInformationProblems = ConcurrentCollectionFactory.createConcurrentSet();

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(1);
        }
        if (session == null) {
            InspectionEngine.$$$reportNull$$$0(2);
        }
        if (!tool.isAvailableForFile(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                InspectionEngine.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        try {
            visitor = tool.buildVisitor(holder, isOnTheFly, session);
        }
        catch (Throwable e) {
            if (Logger.shouldRethrow((Throwable)e)) {
                throw e;
            }
            PluginException t = PluginException.createByClass((String)("Inspection tool '" + tool.getShortName() + "' (" + String.valueOf(tool.getClass()) + ") thrown exception from its buildVisitor()"), (Throwable)e, tool.getClass());
            LOG.error((Throwable)t);
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                InspectionEngine.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        if (visitor == null) {
            LOG.error("Tool " + String.valueOf(tool) + " (" + String.valueOf(tool.getClass()) + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + String.valueOf(tool));
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    @Deprecated
    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(7);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(9);
        }
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map = InspectionEngine.inspectEx(toolWrappers, psiFile, psiFile.getTextRange(), psiFile.getTextRange(), isOnTheFly, false, true, indicator, (PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor>)PairProcessor.alwaysTrue());
        Map<String, List<ProblemDescriptor>> map2 = map.entrySet().stream().map(e -> Pair.create((Object)((LocalInspectionToolWrapper)((Object)((Object)e.getKey()))).getShortName(), (Object)((List)e.getValue()))).collect(Collectors.toMap(p -> (String)p.getFirst(), p -> (List)p.getSecond()));
        if (map2 == null) {
            InspectionEngine.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, boolean isOnTheFly, boolean inspectInjectedPsi, boolean ignoreSuppressedElements, @NotNull ProgressIndicator indicator, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(12);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(13);
        }
        if (priorityRange == null) {
            InspectionEngine.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(15);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(16);
        }
        return InspectionEngine.inspectEx(toolWrappers, psiFile, restrictRange, priorityRange, isOnTheFly, inspectInjectedPsi, ignoreSuppressedElements, indicator, null, foundDescriptorCallback);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, boolean isOnTheFly, boolean inspectInjectedPsi, boolean ignoreSuppressedElements, @NotNull ProgressIndicator indicator, @Nullable UserDataHolderBase userData, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(17);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(18);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(19);
        }
        if (priorityRange == null) {
            InspectionEngine.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(21);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(22);
        }
        if (toolWrappers.isEmpty()) {
            Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map = Collections.emptyMap();
            if (map == null) {
                InspectionEngine.$$$reportNull$$$0(23);
            }
            return map;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(psiFile, restrictRange, priorityRange, Predicates.alwaysTrue(), (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List elements = ContainerUtil.concat((List)ContainerUtil.map(allDivided, d -> ContainerUtil.concat((List[])new List[]{d.inside(), d.outside(), d.parents()})));
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map = InspectionEngine.inspectElements(toolWrappers, psiFile, restrictRange, ignoreSuppressedElements, isOnTheFly, indicator, elements, userData, foundDescriptorCallback);
        if (inspectInjectedPsi) {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)psiFile.getProject());
            HashSet<Pair> injectedFiles = new HashSet<Pair>();
            for (PsiElement element : elements) {
                List files;
                if (!(element instanceof PsiLanguageInjectionHost) || (files = injectedLanguageManager.getInjectedPsiFiles(element)) == null) continue;
                for (Pair pair2 : files) {
                    PsiFile injectedFile = (PsiFile)pair2.getFirst();
                    injectedFiles.add(Pair.create((Object)injectedFile, (Object)element));
                }
            }
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injectedFiles), indicator, pair -> {
                PsiFile injectedFile = (PsiFile)pair.getFirst();
                PsiElement host = (PsiElement)pair.getSecond();
                ArrayList injectedElements = new ArrayList();
                HashSet<String> injectedDialects = new HashSet<String>();
                InspectionEngine.getAllElementsAndDialectsFrom(injectedFile, injectedElements, injectedDialects);
                Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> result = InspectionEngine.inspectElements(toolWrappers, injectedFile, injectedFile.getTextRange(), isOnTheFly, indicator, ignoreSuppressedElements, injectedElements, injectedDialects, userData, foundDescriptorCallback);
                for (Map.Entry<LocalInspectionToolWrapper, List<ProblemDescriptor>> entry : result.entrySet()) {
                    LocalInspectionToolWrapper toolWrapper = entry.getKey();
                    List descriptors = entry.getValue();
                    List filtered = ignoreSuppressedElements ? ContainerUtil.filter(descriptors, descriptor -> !((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(host)) : descriptors;
                    map.merge(toolWrapper, filtered, (oldList, newList) -> ContainerUtil.concat((List)oldList, (List)newList));
                }
                return true;
            })) {
                throw new ProcessCanceledException();
            }
        }
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map2 = map;
        if (map2 == null) {
            InspectionEngine.$$$reportNull$$$0(24);
        }
        return map2;
    }

    private static void getAllElementsAndDialectsFrom(@NotNull PsiFile psiFile, final @NotNull List<? super PsiElement> outElements, @NotNull Set<? super String> outDialects) {
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(25);
        }
        if (outElements == null) {
            InspectionEngine.$$$reportNull$$$0(26);
        }
        if (outDialects == null) {
            InspectionEngine.$$$reportNull$$$0(27);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set;
                this.val$outDialects = set2;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    outElements.add(child);
                    child.accept((PsiElementVisitor)this);
                    InspectionEngine.appendDialects(child, this.val$processedLanguages, this.val$outDialects);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionEngine$1", "visitElement"));
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(psiFile.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            outElements.add((PsiElement)psiRoot);
            psiRoot.accept((PsiElementVisitor)visitor);
            InspectionEngine.appendDialects((PsiElement)psiRoot, (Set<? super Language>)processedLanguages, outDialects);
        }
    }

    private static void appendDialects(@NotNull PsiElement element, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (element == null) {
            InspectionEngine.$$$reportNull$$$0(28);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(29);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(30);
        }
        Language language = element.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add((Language)language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull TextRange restrictRange, boolean ignoreSuppressedElements, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(31);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(32);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(33);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(34);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(35);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(36);
        }
        return InspectionEngine.inspectElements(toolWrappers, psiFile, restrictRange, isOnTheFly, indicator, ignoreSuppressedElements, elements, InspectionEngine.calcElementDialectIds(elements), null, foundDescriptorCallback);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull TextRange restrictRange, boolean ignoreSuppressedElements, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements, @Nullable UserDataHolderBase userData, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(37);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(38);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(39);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(40);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(41);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(42);
        }
        return InspectionEngine.inspectElements(toolWrappers, psiFile, restrictRange, isOnTheFly, indicator, ignoreSuppressedElements, elements, InspectionEngine.calcElementDialectIds(elements), userData, foundDescriptorCallback);
    }

    @ApiStatus.Internal
    public static void withSession(@NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @Nullable HighlightSeverity minimumSeverity, boolean isOnTheFly, @Nullable UserDataHolderBase userData, @NotNull Consumer<? super LocalInspectionToolSession> runnable) {
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(43);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(44);
        }
        if (priorityRange == null) {
            InspectionEngine.$$$reportNull$$$0(45);
        }
        if (runnable == null) {
            InspectionEngine.$$$reportNull$$$0(46);
        }
        LocalInspectionToolSession session = new LocalInspectionToolSession(psiFile, priorityRange, restrictRange, minimumSeverity);
        if (userData != null) {
            userData.copyUserDataTo((UserDataHolderBase)session);
        }
        runnable.accept((LocalInspectionToolSession)session);
    }

    private static boolean warnAboutInformationLevelInBatchMode(@NotNull ProblemHighlightType highlightType, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull PsiFile psiFile) {
        if (highlightType == null) {
            InspectionEngine.$$$reportNull$$$0(47);
        }
        if (toolWrapper == null) {
            InspectionEngine.$$$reportNull$$$0(48);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(49);
        }
        if (highlightType == ProblemHighlightType.INFORMATION) {
            String shortName = toolWrapper.getShortName();
            if (ourToolsWithInformationProblems.add(shortName)) {
                String message = "Tool #" + shortName + " (" + String.valueOf(((LocalInspectionTool)toolWrapper.getTool()).getClass()) + ") registers 'INFORMATION'-level problem in batch mode on " + String.valueOf(psiFile) + ". Warnings of the 'INFORMATION' level are invisible in the editor and should not become visible in batch mode. Moreover, since 'INFORMATION'-level fixes act more like intention actions, they could e.g. change semantics and thus should not be suggested for batch transformations";
                LocalInspectionEP extension = (LocalInspectionEP)toolWrapper.getExtension();
                if (extension == null) {
                    LOG.error(message);
                } else {
                    LOG.warn((Throwable)new PluginException(message, extension.getPluginDescriptor().getPluginId()));
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile psiFile, @NotNull TextRange restrictRange, final boolean isOnTheFly, @NotNull ProgressIndicator indicator, boolean ignoreSuppressedElements, @NotNull List<? extends PsiElement> elements, @NotNull Set<String> elementDialectIds, @Nullable UserDataHolderBase userData, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(50);
        }
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(51);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(52);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(53);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(54);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(55);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(56);
        }
        ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>>();
        InspectionEngine.withSession(psiFile, restrictRange, restrictRange, HighlightSeverity.INFORMATION, isOnTheFly, userData, session -> {
            List<LocalInspectionToolWrapper> applicableTools = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, elementDialectIds, elementDialectIds);
            InspectionVisitorOptimizer inspectionVisitorsOptimizer = new InspectionVisitorOptimizer(elements);
            InspectListener inspectionListener = isOnTheFly ? null : (InspectListener)psiFile.getProject().getMessageBus().syncPublisher(GlobalInspectionContextEx.INSPECT_TOPIC);
            Processor processor = toolWrapper -> {
                ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)psiFile.getProject()), psiFile, isOnTheFly, (LocalInspectionToolWrapper)((Object)((Object)toolWrapper)), psiFile, foundDescriptorCallback){
                    final /* synthetic */ LocalInspectionToolWrapper val$toolWrapper;
                    final /* synthetic */ PsiFile val$psiFile;
                    final /* synthetic */ PairProcessor val$foundDescriptorCallback;
                    {
                        this.val$toolWrapper = localInspectionToolWrapper;
                        this.val$psiFile = psiFile;
                        this.val$foundDescriptorCallback = pairProcessor;
                        super(arg0, arg1, arg2);
                    }

                    public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                        if (descriptor == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!isOnTheFly) {
                            ProblemHighlightType highlightType = descriptor.getHighlightType();
                            if (InspectionEngine.warnAboutInformationLevelInBatchMode(highlightType, this.val$toolWrapper, this.val$psiFile)) {
                                return;
                            }
                            if (highlightType == ProblemHighlightType.POSSIBLE_PROBLEM) {
                                return;
                            }
                        }
                        if (this.val$foundDescriptorCallback.process((Object)this.val$toolWrapper, (Object)descriptor)) {
                            super.registerProblem(descriptor);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InspectionEngine$2", "registerProblem"));
                    }
                };
                LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
                try {
                    boolean inspectionWasRun;
                    long inspectionStartTime = System.nanoTime();
                    PsiElementVisitor visitor = InspectionEngine.createVisitor(tool, holder, isOnTheFly, session);
                    if (visitor == PsiElementVisitor.EMPTY_VISITOR) {
                        inspectionWasRun = false;
                    } else {
                        inspectionWasRun = true;
                        tool.inspectionStarted(session, isOnTheFly);
                        inspectionVisitorsOptimizer.acceptElements(elements, visitor);
                        tool.inspectionFinished(session, holder);
                    }
                    long inspectionDuration = TimeoutUtil.getDurationMillis((long)inspectionStartTime);
                    if (inspectionListener != null && inspectionWasRun) {
                        inspectionListener.inspectionFinished(inspectionDuration, Thread.currentThread().getId(), holder.getResultCount(), (InspectionToolWrapper<?, ?>)toolWrapper, InspectListener.InspectionKind.LOCAL, psiFile, psiFile.getProject());
                    }
                }
                catch (Exception e) {
                    if (inspectionListener != null) {
                        inspectionListener.inspectionFailed(toolWrapper.getID(), e, psiFile, psiFile.getProject());
                    }
                    throw e;
                }
                if (holder.hasResults()) {
                    for (ProblemDescriptor descriptor : holder.getResults()) {
                        PsiElement element = descriptor.getPsiElement();
                        if (element != null && ignoreSuppressedElements && SuppressionUtil.inspectionResultSuppressed(element, tool)) continue;
                        LocalInspectionToolWrapper wrapper = InspectionEngine.getRedirectedToolWrapper(toolWrapper, descriptor);
                        resultDescriptors.computeIfAbsent(wrapper, x -> new ArrayList()).add(descriptor);
                    }
                }
                return true;
            };
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(applicableTools, indicator, processor);
        });
        ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(57);
        }
        return concurrentHashMap;
    }

    @Nullable
    private static LocalInspectionToolWrapper getRedirectedToolWrapper(LocalInspectionToolWrapper toolWrapper, ProblemDescriptor descriptor) {
        if (descriptor instanceof ProblemDescriptorWithReporterName) {
            ProblemDescriptorWithReporterName name = (ProblemDescriptorWithReporterName)descriptor;
            InspectionProfileEntry inspectionProfileEntry = toolWrapper.getTool();
            if (inspectionProfileEntry instanceof DynamicGroupTool) {
                DynamicGroupTool groupTool = (DynamicGroupTool)inspectionProfileEntry;
                String reportingToolName = name.getReportingToolShortName();
                for (LocalInspectionToolWrapper child : groupTool.getChildren()) {
                    if (!child.getShortName().equals(reportingToolName)) continue;
                    return child;
                }
            }
        }
        return toolWrapper;
    }

    @NotNull
    public static @Unmodifiable List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile psiFile, @NotNull InspectionToolWrapper<?, ?> toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        if (psiFile == null) {
            InspectionEngine.$$$reportNull$$$0(58);
        }
        if (toolWrapper == null) {
            InspectionEngine.$$$reportNull$$$0(59);
        }
        if (inspectionContext == null) {
            InspectionEngine.$$$reportNull$$$0(60);
        }
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)psiFile.getProject());
        toolWrapper.initialize(inspectionContext);
        RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
        final ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        refManager.runInsideInspectionReadAction(() -> {
            try {
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(Collections.singletonList(local), psiFile, psiFile.getTextRange(), psiFile.getTextRange(), false, false, true, (ProgressIndicator)new EmptyProgressIndicator(), (PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor>)PairProcessor.alwaysTrue());
                    for (List<ProblemDescriptor> group : problemDescriptors.values()) {
                        result.addAll(group);
                    }
                } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    GlobalInspectionToolWrapper global = (GlobalInspectionToolWrapper)toolWrapper;
                    final GlobalInspectionTool globalTool = (GlobalInspectionTool)global.getTool();
                    if (globalTool.isGlobalSimpleInspectionTool()) {
                        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, psiFile, false);
                        ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                            public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                                if (refEntity == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                return result.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                            }

                            public void ignoreElement(@NotNull RefEntity refEntity) {
                                if (refEntity == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                throw new UnsupportedOperationException();
                            }

                            public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
                                if (descriptor == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                throw new UnsupportedOperationException();
                            }

                            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                                if (commonProblemDescriptors == null) {
                                    3.$$$reportNull$$$0(3);
                                }
                                if (!(refEntity instanceof RefElement)) {
                                    return;
                                }
                                RefElement refElement = (RefElement)refEntity;
                                PsiElement element = refElement.getPsiElement();
                                InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, result);
                            }

                            public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                                if (descriptor == null) {
                                    3.$$$reportNull$$$0(4);
                                }
                                throw new RuntimeException();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "refEntity";
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                    case 3: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "commonProblemDescriptors";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine$3";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "getDescriptions";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "ignoreElement";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "resolveProblem";
                                        break;
                                    }
                                    case 3: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "addProblemElement";
                                        break;
                                    }
                                    case 4: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "getElement";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        globalTool.checkFile(psiFile, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                    } else {
                        RefElement fileRef = refManager.getReference((PsiElement)psiFile);
                        final AnalysisScope scope = new AnalysisScope(psiFile);
                        assert (fileRef != null);
                        fileRef.accept(new RefVisitor(){

                            public void visitElement(@NotNull RefEntity elem) {
                                CommonProblemDescriptor[] elemDescriptors;
                                if (elem == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                if ((elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext)) != null) {
                                    InspectionEngine.convertToProblemDescriptors((PsiElement)psiFile, elemDescriptors, result);
                                }
                                for (RefEntity child : elem.getChildren()) {
                                    child.accept((RefVisitor)this);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$4", "visitElement"));
                            }
                        });
                    }
                }
            }
            finally {
                toolWrapper.cleanup(psiFile.getProject());
                inspectionContext.cleanup();
            }
        });
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            InspectionEngine.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, @NotNull @NotNull CommonProblemDescriptor @NotNull [] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> outDescriptors) {
        if (element == null) {
            InspectionEngine.$$$reportNull$$$0(62);
        }
        if (outDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(63);
        }
        if (commonProblemDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(64);
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)common;
                outDescriptors.add((ProblemDescriptor)problemDescriptor);
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            outDescriptors.add(base);
        }
    }

    @NotNull
    public static @Unmodifiable List<LocalInspectionToolWrapper> filterToolsApplicableByLanguage(@NotNull Collection<? extends LocalInspectionToolWrapper> tools, @NotNull Set<String> elementDialectIdsForRegularTool, @NotNull Set<String> elementDialectIdsForWholeFileTool) {
        if (tools == null) {
            InspectionEngine.$$$reportNull$$$0(65);
        }
        if (elementDialectIdsForRegularTool == null) {
            InspectionEngine.$$$reportNull$$$0(66);
        }
        if (elementDialectIdsForWholeFileTool == null) {
            InspectionEngine.$$$reportNull$$$0(67);
        }
        HashMap resultsWithDialects = new HashMap();
        HashMap resultsNoDialects = new HashMap();
        List list = ContainerUtil.filter(tools, tool -> {
            String toolLanguageId = tool.getLanguage();
            if (toolLanguageId == null || toolLanguageId.isBlank() || "any".equals(toolLanguageId)) {
                return true;
            }
            boolean applyToDialects = tool.applyToDialects();
            Map map = applyToDialects ? resultsWithDialects : resultsNoDialects;
            return map.computeIfAbsent(toolLanguageId, __ -> ToolLanguageUtil.isToolLanguageOneOf((Set)(tool.runForWholeFile() ? elementDialectIdsForWholeFileTool : elementDialectIdsForRegularTool), (String)toolLanguageId, (boolean)applyToDialects));
        });
        if (list == null) {
            InspectionEngine.$$$reportNull$$$0(68);
        }
        return list;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (inside == null) {
            InspectionEngine.$$$reportNull$$$0(69);
        }
        if (outside == null) {
            InspectionEngine.$$$reportNull$$$0(70);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(inside, processedLanguages, dialectIds);
        InspectionEngine.addDialects(outside, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(71);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(72);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(elements, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(73);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(74);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(75);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(76);
        }
        for (PsiElement psiElement : elements) {
            Language language = psiElement.getLanguage();
            outDialectIds.add(language.getID());
            InspectionEngine.addDialects(language, outProcessedLanguages, outDialectIds);
        }
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(77);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(78);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(79);
        }
        if (outProcessedLanguages.add((Language)language)) {
            Collection dialects = language.getTransitiveDialects();
            outProcessedLanguages.addAll(dialects);
            for (Language dialect : dialects) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 10, 23, 24, 57, 61, 68, 71, 73 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 23: 
            case 24: 
            case 57: 
            case 61: 
            case 68: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 6: 
            case 11: 
            case 17: 
            case 31: 
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 32: 
            case 38: 
            case 43: 
            case 49: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 9: 
            case 15: 
            case 21: 
            case 34: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 19: 
            case 33: 
            case 39: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 14: 
            case 20: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 16: 
            case 22: 
            case 36: 
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundDescriptorCallback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialects";
                break;
            }
            case 28: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 30: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
            case 35: 
            case 41: 
            case 54: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 48: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDescriptors";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonProblemDescriptors";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIdsForRegularTool";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIdsForWholeFileTool";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 10: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectEx";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectElements";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionOnFile";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "filterToolsApplicableByLanguage";
                break;
            }
            case 71: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "calcElementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 23: 
            case 24: 
            case 57: 
            case 61: 
            case 68: 
            case 71: 
            case 73: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "inspectEx";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllElementsAndDialectsFrom";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendDialects";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "inspectElements";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "withSession";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "warnAboutInformationLevelInBatchMode";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "filterToolsApplicableByLanguage";
                break;
            }
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "calcElementDialectIds";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 10, 23, 24, 57, 61, 68, 71, 73 -> new IllegalStateException(string);
        };
    }
}

