/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexingIteratorsProvider;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.ProcessorWithThrottledCancellationCheck;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexLookupTimingsReporting;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorageLockingBase;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.io.MeasurableIndexStore;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public abstract class FileBasedIndexEx
extends FileBasedIndex {
    public static final boolean TRACE_STUB_INDEX_UPDATES = SystemProperties.getBooleanProperty((String)"idea.trace.stub.index.update", (boolean)false) || SystemProperties.getBooleanProperty((String)"trace.stub.index.update", (boolean)false);
    private static final boolean TRACE_INDEX_UPDATES = SystemProperties.getBooleanProperty((String)"trace.file.based.index.update", (boolean)false);
    private static final boolean TRACE_SHARED_INDEX_UPDATES = SystemProperties.getBooleanProperty((String)"trace.shared.index.update", (boolean)false);
    private static final ThreadLocal<Stack<DumbModeAccessType>> ourDumbModeAccessTypeStack = ThreadLocal.withInitial(() -> new Stack());
    private static final RecursionGuard<Object> ourIgnoranceGuard = RecursionManager.createGuard((String)"ignoreDumbMode");

    @ApiStatus.Internal
    public static boolean doTraceIndexUpdates() {
        return TRACE_INDEX_UPDATES;
    }

    @ApiStatus.Internal
    public static boolean doTraceStubUpdates(@NotNull IndexId<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(0);
        }
        return TRACE_STUB_INDEX_UPDATES && indexId.equals(StubUpdatingIndex.INDEX_ID);
    }

    @ApiStatus.Internal
    public static boolean doTraceSharedIndexUpdates() {
        return TRACE_SHARED_INDEX_UPDATES;
    }

    @ApiStatus.Internal
    @NotNull
    public abstract IntPredicate getAccessibleFileIdFilter(@Nullable Project var1);

    @ApiStatus.Internal
    @Nullable
    public abstract IdFilter extractIdFilter(@Nullable GlobalSearchScope var1, @Nullable Project var2);

    @ApiStatus.Internal
    @NotNull
    public abstract <K, V> UpdatableIndex<K, V, FileContent, ?> getIndex(ID<K, V> var1);

    public void resetHints() {
    }

    @ApiStatus.Internal
    public abstract void waitUntilIndicesAreInitialized();

    @ApiStatus.Internal
    public abstract <K> boolean ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3, @Nullable VirtualFile var4);

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(1);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(3);
        }
        Iterator<VirtualFile> restrictToFileIt = FileBasedIndexEx.extractSingleFileOrEmpty(scope);
        SmartList values = new SmartList();
        if (restrictToFileIt != null) {
            VirtualFile restrictToFile;
            FileBasedIndex.ValueProcessor processor = (arg_0, arg_1) -> FileBasedIndexEx.lambda$getValues$1((List)values, arg_0, arg_1);
            VirtualFile virtualFile = restrictToFile = restrictToFileIt.hasNext() ? restrictToFileIt.next() : null;
            if (restrictToFile == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    FileBasedIndexEx.$$$reportNull$$$0(4);
                }
                return list;
            }
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, scope, processor);
        } else {
            Project project = scope.getProject();
            IdFilter filter = this.extractIdFilter(scope, project);
            IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
            this.processValueIterator(indexId, dataKey, null, scope, arg_0 -> this.lambda$getValues$2(accessibleFileFilter, filter, scope, (List)values, arg_0));
        }
        SmartList smartList = values;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(6);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(7);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor(allKeys), project);
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @Nullable Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(10);
        }
        return this.processAllKeys(indexId, processor, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.everythingScope((Project)project)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        block14: {
            if (indexId == null) {
                FileBasedIndexEx.$$$reportNull$$$0(11);
            }
            if (processor == null) {
                FileBasedIndexEx.$$$reportNull$$$0(12);
            }
            if (scope == null) {
                FileBasedIndexEx.$$$reportNull$$$0(13);
            }
            try (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupAllKeysTrace trace = (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupAllKeysTrace)IndexLookupTimingsReporting.IndexOperationFusCollector.lookupAllKeysStarted(indexId).withProject(scope.getProject());){
                this.waitUntilIndicesAreInitialized();
                UpdatableIndex<K, ?, FileContent, ?> index = this.getIndex(indexId);
                if (!this.ensureUpToDate(indexId, scope.getProject(), scope, null)) {
                    boolean bl = true;
                    return bl;
                }
                trace.indexValidationFinished();
                IdFilter idFilterAdjusted = idFilter == null ? this.extractIdFilter(scope, scope.getProject()) : idFilter;
                trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible(index));
                boolean bl = index.processAllKeys(FileBasedIndexEx.maybeWrapAsCancellable(processor), scope, idFilterAdjusted);
                return bl;
            }
        }
        return false;
    }

    public <K, V> @Unmodifiable @NotNull Map<K, V> getFileData(@NotNull ID<K, V> id, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id == null) {
            FileBasedIndexEx.$$$reportNull$$$0(14);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(16);
        }
        if (!(virtualFile instanceof VirtualFileWithId)) {
            Map map = Collections.emptyMap();
            if (map == null) {
                FileBasedIndexEx.$$$reportNull$$$0(17);
            }
            return map;
        }
        int fileId = FileBasedIndexEx.getFileId((VirtualFile)virtualFile);
        if (this.getAccessibleFileIdFilter(project).test(fileId)) {
            Map map = (Map)this.readIndexAndProcessExceptions(id, virtualFile, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile), index -> {
                if (IndexDebugProperties.DEBUG && !ApplicationManager.getApplication().isUnitTestMode() && !((FileBasedIndexExtension)index.getExtension()).needsForwardIndexWhenSharing()) {
                    this.getLogger().error("Index extension " + String.valueOf(id) + " doesn't require forward index but accesses it");
                }
                return index.getIndexedFileData(fileId);
            });
            Map map2 = ContainerUtil.notNullize((Map)map);
            if (map2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(18);
            }
            return map2;
        }
        Map map = Collections.emptyMap();
        if (map == null) {
            FileBasedIndexEx.$$$reportNull$$$0(19);
        }
        return map;
    }

    @Nullable
    public <V> V getSingleEntryIndexData(@NotNull ID<Integer, V> id, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id == null) {
            FileBasedIndexEx.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(21);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(22);
        }
        if (!(this.getIndex(id).getExtension() instanceof SingleEntryFileBasedIndexExtension)) {
            throw new IllegalArgumentException("'" + String.valueOf(id) + "' index is not a SingleEntryFileBasedIndex");
        }
        Map<Integer, V> data = this.getFileData(id, virtualFile, project);
        if (data.isEmpty()) {
            return null;
        }
        if (data.size() == 1) {
            return data.values().iterator().next();
        }
        throw new IllegalStateException("Invalid single entry index data '" + String.valueOf(id) + "'");
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(23);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(24);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(25);
        }
        HashSet hashSet = ContainerUtil.newHashSet(this.getContainingFilesIterator(indexId, dataKey, filter));
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public <K, V> Iterator<VirtualFile> getContainingFilesIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(27);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(29);
        }
        Project project = scope.getProject();
        IndexLookupTimingsReporting.IndexOperationFusCollector.LookupEntriesByKeysTrace trace = IndexLookupTimingsReporting.IndexOperationFusCollector.lookupEntriesStarted(indexId);
        trace.keysWithAND(1).withProject(project);
        if (project instanceof LightEditCompatible) {
            Iterator<VirtualFile> iterator = Collections.emptyIterator();
            Iterator<VirtualFile> iterator2 = iterator;
            if (iterator2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(30);
            }
            return iterator2;
        }
        @Nullable Iterator<VirtualFile> restrictToFileIt = FileBasedIndexEx.extractSingleFileOrEmpty(scope);
        if (restrictToFileIt != null) {
            VirtualFile restrictToFile;
            VirtualFile virtualFile = restrictToFile = restrictToFileIt.hasNext() ? restrictToFileIt.next() : null;
            if (restrictToFile == null) {
                Iterator<VirtualFile> iterator = Collections.emptyIterator();
                Iterator<VirtualFile> iterator3 = iterator;
                if (iterator3 == null) {
                    FileBasedIndexEx.$$$reportNull$$$0(31);
                }
                return iterator3;
            }
            Iterator<VirtualFile> iterator = !this.processValuesInOneFile(indexId, dataKey, restrictToFile, scope, (f, v) -> false) ? Collections.singleton(restrictToFile).iterator() : Collections.emptyIterator();
            Iterator<VirtualFile> iterator4 = iterator;
            if (iterator4 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(32);
            }
            return iterator4;
        }
        IdFilter filter = this.extractIdFilter(scope, project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        IntSet fileIds = (IntSet)this.readIndexAndProcessExceptions(indexId, null, scope, index -> {
            IntOpenHashSet fileIdsInner = new IntOpenHashSet();
            trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible((Object)index));
            index.withData(dataKey, arg_0 -> FileBasedIndexEx.lambda$getContainingFilesIterator$6(accessibleFileFilter, filter, (IntSet)fileIdsInner, arg_0));
            return fileIdsInner;
        });
        trace.lookupResultSize(fileIds != null ? fileIds.size() : 0);
        Iterator<VirtualFile> iterator = FileBasedIndexEx.createLazyFileIterator(fileIds, scope);
        Iterator<VirtualFile> iterator5 = iterator;
        if (iterator5 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(33);
        }
        return iterator5;
        finally {
            if (trace != null) {
                trace.close();
            }
        }
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(34);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(36);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(37);
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(38);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(40);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(41);
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, filter, processor) : this.processValuesInScope(indexId, dataKey, false, filter, idFilter, processor);
    }

    public <K, V> long getIndexModificationStamp(@NotNull ID<K, V> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(42);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(43);
        }
        this.waitUntilIndicesAreInitialized();
        UpdatableIndex<K, V, FileContent, ?> index = this.getIndex(indexId);
        this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
        return index.getModificationStamp();
    }

    @Nullable
    private <K, V, R> R readIndexAndProcessExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent, ?>, ? extends R, StorageException> computable) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(44);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(45);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(46);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, V, FileContent, ?> index = this.getIndex(indexId);
            Project project = filter.getProject();
            if (!this.ensureUpToDate(indexId, project, filter, restrictToFile)) {
                return null;
            }
            IndexLookupTimingsReporting.IndexOperationFusCollector.TRACE_OF_ENTRIES_LOOKUP.get().indexValidationFinished();
            return (R)computable.convert(index);
        }
        catch (StorageException e) {
            IndexLookupTimingsReporting.IndexOperationFusCollector.TRACE_OF_ENTRIES_LOOKUP.get().lookupFailed();
            this.requestRebuild(indexId, e);
        }
        catch (CancellationException e) {
            IndexLookupTimingsReporting.IndexOperationFusCollector.TRACE_OF_ENTRIES_LOOKUP.get().lookupCancelled();
            throw e;
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexEx.extractCauseToRebuildIndex(e);
            if (cause != null) {
                this.requestRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    protected <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(47);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(48);
        }
        if (restrictToFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(51);
        }
        Project project = scope.getProject();
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return true;
        }
        int restrictedFileId = FileBasedIndexEx.getFileId((VirtualFile)restrictToFile);
        if (!this.getAccessibleFileIdFilter(project).test(restrictedFileId)) {
            return true;
        }
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueIt.getValueAssociationPredicate().test(restrictedFileId) && !processor.process(restrictToFile, value)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    protected <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(52);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(53);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(55);
        }
        Project project = scope.getProject();
        IdFilter filter = idFilter != null ? idFilter : this.extractIdFilter(scope, project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id = inputIdsIterator.next();
                    if (!accessibleFileFilter.test(id) || filter != null && !filter.containsFileId(id)) continue;
                    VirtualFile file = this.findFileById(id);
                    if (file != null && scope.contains(file) && !processor.process(file, value)) {
                        return false;
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(56);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(57);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(58);
        }
        if (valueProcessor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(59);
        }
        try (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupEntriesByKeysTrace trace = IndexLookupTimingsReporting.IndexOperationFusCollector.lookupEntriesStarted(indexId);){
            trace.keysWithAND(1).withProject(scope.getProject());
            Boolean result = (Boolean)this.readIndexAndProcessExceptions(indexId, restrictToFile, scope, index -> {
                trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible((Object)index));
                return index.withData(dataKey, container -> {
                    InvertedIndexValueIterator valuesIterator = (InvertedIndexValueIterator)container.getValueIterator();
                    return valueProcessor.process((Object)valuesIterator);
                });
            });
            boolean bl = result == null || result != false;
            return bl;
        }
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        IdFilter filesSet;
        IntSet set;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(60);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(61);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(62);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(63);
        }
        return (set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet = this.extractIdFilter(filter, filter.getProject()), null)) != null && this.processVirtualFiles((IntCollection)set, filter, processor);
    }

    public <K, V> boolean processFilesContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(64);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(65);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(66);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(67);
        }
        IdFilter idFilterAdjusted = idFilter != null ? idFilter : this.extractIdFilter(filter, filter.getProject());
        IntSet set = this.collectFileIdsContainingAnyKey(indexId, dataKeys, filter, valueChecker, idFilterAdjusted);
        return set != null && this.processVirtualFiles((IntCollection)set, filter, processor);
    }

    private boolean processFilesContainingAllKeysInPhysicalFiles(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter, @Nullable IdFilter filesSet, @NotNull Processor<? super VirtualFile> processor) {
        if (queries == null) {
            FileBasedIndexEx.$$$reportNull$$$0(68);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(69);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(70);
        }
        IntOpenHashSet set = null;
        if (filter instanceof GlobalSearchScope.FilesScope) {
            GlobalSearchScope.FilesScope filesScope = (GlobalSearchScope.FilesScope)filter;
            set = new IntOpenHashSet(filesScope.asArray());
        }
        for (FileBasedIndex.AllKeysQuery<?, ?> query : queries) {
            IntSet queryResult = this.collectFileIdsContainingAllKeys(query.getIndexId(), query.getDataKeys(), filter, query.getValueChecker(), filesSet, (IntSet)set);
            if (queryResult == null) {
                return false;
            }
            if (queryResult.isEmpty()) {
                return true;
            }
            if (set == null) {
                set = new IntOpenHashSet((IntCollection)queryResult);
                continue;
            }
            set = queryResult;
        }
        return set != null && this.processVirtualFiles((IntCollection)set, filter, processor);
    }

    public boolean processFilesContainingAllKeys(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor) {
        if (queries == null) {
            FileBasedIndexEx.$$$reportNull$$$0(71);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(73);
        }
        IdFilter filesSet = this.extractIdFilter(filter, filter.getProject());
        return this.processFilesContainingAllKeysInPhysicalFiles(queries, filter, filesSet, processor);
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(74);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(75);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(76);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(77);
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter, null, processor);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(78);
        }
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(79);
        }
        this.requestRebuild(indexId, e);
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(80);
        }
        this.waitUntilIndicesAreInitialized();
        this.ensureUpToDate(indexId, project, filter, null);
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(81);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(82);
        }
        List<IndexableFilesIterator> providers = this.getIndexableFilesProviders(project);
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        for (IndexableFilesIterator provider : providers) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (provider.iterateFiles(project, processor, (VirtualFileFilter)indexableFilesDeduplicateFilter)) continue;
            break;
        }
    }

    @NotNull
    public List<IndexableFilesIterator> getIndexableFilesProviders(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(83);
        }
        if (project instanceof LightEditCompatible) {
            List<IndexableFilesIterator> list = Collections.emptyList();
            if (list == null) {
                FileBasedIndexEx.$$$reportNull$$$0(84);
            }
            return list;
        }
        List<IndexableFilesIterator> list = IndexingIteratorsProvider.getInstance(project).getIndexingIterators();
        if (list == null) {
            FileBasedIndexEx.$$$reportNull$$$0(85);
        }
        return list;
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope scope, @Nullable Condition<? super V> valueChecker, @Nullable IdFilter projectFilesFilter, @Nullable IntSet restrictedIds) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(86);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(87);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(88);
        }
        try (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupEntriesByKeysTrace trace = IndexLookupTimingsReporting.IndexOperationFusCollector.lookupEntriesStarted(indexId);){
            trace.keysWithAND(dataKeys.size()).withProject(scope.getProject());
            IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(scope.getProject());
            IntPredicate idChecker = id -> !(projectFilesFilter != null && !projectFilesFilter.containsFileId(id) || !accessibleFileFilter.test(id) || restrictedIds != null && !restrictedIds.contains(id));
            IntSet ids = (IntSet)this.readIndexAndProcessExceptions(indexId, null, scope, index -> {
                trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible((Object)index));
                IndexDebugProperties.DEBUG_INDEX_ID.set(indexId);
                try {
                    IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, (Condition)valueChecker, (IntPredicate)idChecker);
                    return intSet;
                }
                finally {
                    IndexDebugProperties.DEBUG_INDEX_ID.remove();
                }
            });
            trace.lookupResultSize(ids != null ? ids.size() : 0);
            IntSet intSet = ids;
            return intSet;
        }
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @Nullable IdFilter projectFilesFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(89);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(90);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(91);
        }
        try (IndexLookupTimingsReporting.IndexOperationFusCollector.LookupEntriesByKeysTrace trace = IndexLookupTimingsReporting.IndexOperationFusCollector.lookupEntriesStarted(indexId);){
            trace.keysWithOR(dataKeys.size());
            IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter.getProject());
            IntPredicate idChecker = id -> (projectFilesFilter == null || projectFilesFilter.containsFileId(id)) && accessibleFileFilter.test(id);
            IntSet ids = (IntSet)this.readIndexAndProcessExceptions(indexId, null, filter, index -> {
                trace.totalKeysIndexed(MeasurableIndexStore.keysCountApproximatelyIfPossible((Object)index));
                IndexDebugProperties.DEBUG_INDEX_ID.set(indexId);
                try {
                    IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAnyKey((InvertedIndex)index, (Collection)dataKeys, (Condition)valueChecker, (IntPredicate)idChecker);
                    return intSet;
                }
                finally {
                    IndexDebugProperties.DEBUG_INDEX_ID.remove();
                }
            });
            trace.lookupResultSize(ids != null ? ids.size() : 0);
            IntSet intSet = ids;
            return intSet;
        }
    }

    private boolean processVirtualFiles(@NotNull IntCollection ids, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor) {
        if (ids == null) {
            FileBasedIndexEx.$$$reportNull$$$0(92);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(93);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(94);
        }
        IntArrayList sortedIds = new IntArrayList(ids);
        sortedIds.sort(null);
        Processor<? super VirtualFile> enhancedProcessor = FileBasedIndexEx.maybeWrapAsCancellable(processor);
        IntListIterator iterator = sortedIds.iterator();
        while (iterator.hasNext()) {
            boolean processNext;
            int id = iterator.nextInt();
            VirtualFile file = this.findFileById(id);
            if (file == null || !filter.contains(file) || (processNext = enhancedProcessor.process((Object)file))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType(@Nullable Project project) {
        DumbModeAccessType result = this.getCurrentDumbModeAccessType_NoDumbChecks();
        if (result != null && project != null) {
            this.getLogger().assertTrue(DumbService.isDumb((Project)project), (Object)("getCurrentDumbModeAccessType may only be called during indexing. Project " + project.getName() + " is not in dumb mode."));
        }
        return result;
    }

    @Nullable
    @ApiStatus.Internal
    public DumbModeAccessType getCurrentDumbModeAccessType_NoDumbChecks() {
        Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
        if (dumbModeAccessTypeStack.isEmpty()) {
            if (!Registry.is((String)"ide.dumb.mode.check.awareness")) {
                return DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE;
            }
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ourIgnoranceGuard.prohibitResultCaching(dumbModeAccessTypeStack.get(0));
        return (DumbModeAccessType)dumbModeAccessTypeStack.peek();
    }

    @ApiStatus.Internal
    @NotNull
    public <T> Processor<? super T> inheritCurrentDumbAccessType(@NotNull Processor<? super T> processor) {
        Stack<DumbModeAccessType> stack;
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(95);
        }
        if ((stack = ourDumbModeAccessTypeStack.get()).isEmpty()) {
            Processor processor2 = processor;
            if (processor2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(96);
            }
            return processor2;
        }
        DumbModeAccessType access = (DumbModeAccessType)stack.peek();
        Processor processor3 = t -> (Boolean)this.ignoreDumbMode(access, () -> processor.process(t));
        if (processor3 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(97);
        }
        return processor3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndexEx.$$$reportNull$$$0(98);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(99);
        }
        Application app = ApplicationManager.getApplication();
        Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
        boolean preventCaching = dumbModeAccessTypeStack.empty();
        dumbModeAccessTypeStack.push((Object)dumbModeAccessType);
        Disposable disposable = null;
        if (app.isWriteIntentLockAcquired()) {
            disposable = Disposer.newDisposable();
            app.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> RecursionManager.dropCurrentMemoizationCache());
        }
        try {
            Object object = preventCaching ? ourIgnoranceGuard.computePreventingRecursion((Object)dumbModeAccessType, false, computable) : computable.compute();
            return (T)object;
        }
        finally {
            if (disposable != null) {
                Disposer.dispose((Disposable)disposable);
            }
            DumbModeAccessType type = (DumbModeAccessType)dumbModeAccessTypeStack.pop();
            assert (dumbModeAccessType == type);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public abstract VirtualFile findFileById(int var1);

    @ApiStatus.Internal
    @NotNull
    public abstract Logger getLogger();

    @Nullable
    public static Throwable extractCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(100);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof MapReduceIndexMappingException) {
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    @ApiStatus.Internal
    public static boolean isTooLarge(@NotNull VirtualFile file, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize, @NotNull Set<FileType> noLimitFileTypes) {
        if (file == null) {
            FileBasedIndexEx.$$$reportNull$$$0(101);
        }
        if (noLimitFileTypes == null) {
            FileBasedIndexEx.$$$reportNull$$$0(102);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file, (Long)contentSize)) {
            return !noLimitFileTypes.contains(file.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file, (Long)contentSize);
        }
        return false;
    }

    public static boolean acceptsInput(@NotNull FileBasedIndex.InputFilter filter, @NotNull IndexedFile indexedFile) {
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(103);
        }
        if (indexedFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(104);
        }
        if (filter instanceof FileBasedIndex.ProjectSpecificInputFilter) {
            if (indexedFile.getProject() == null) {
                Project project = ProjectLocator.getInstance().guessProjectForFile(indexedFile.getFile());
                ((IndexedFileImpl)indexedFile).setProject(project);
            }
            return ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(indexedFile);
        }
        return filter.acceptInput(indexedFile.getFile());
    }

    @NotNull
    public static FileBasedIndex.InputFilter composeInputFilter(final @NotNull FileBasedIndex.InputFilter filter, final @NotNull BiPredicate<? super VirtualFile, ? super Project> condition) {
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(105);
        }
        if (condition == null) {
            FileBasedIndexEx.$$$reportNull$$$0(106);
        }
        return new FileBasedIndex.ProjectSpecificInputFilter(){

            public boolean acceptInput(@NotNull IndexedFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean doesMainFilterAccept = filter instanceof FileBasedIndex.ProjectSpecificInputFilter ? ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(file) : filter.acceptInput(file.getFile());
                return doesMainFilterAccept && condition.test(file.getFile(), file.getProject());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexEx$1", "acceptInput"));
            }
        };
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexEx.$$$reportNull$$$0(107);
        }
    }

    @ApiStatus.Internal
    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(108);
        }
        return IndexUpToDateCheckIn.disableUpToDateCheckIn(runnable);
    }

    @ApiStatus.Internal
    static boolean belongsToScope(@Nullable VirtualFile file, @Nullable VirtualFile restrictedTo, @Nullable GlobalSearchScope filter) {
        if (!(file instanceof VirtualFileWithId) || !file.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file, (Object)restrictedTo) || filter != null && restrictedTo == null && !filter.accept(file));
    }

    @ApiStatus.Internal
    @NotNull
    public static Iterator<VirtualFile> createLazyFileIterator(@Nullable IntSet result, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(109);
        }
        Set fileSet = new CompactVirtualFileSet(result == null ? IntSets.emptySet() : result).freezed();
        Iterator<VirtualFile> iterator = fileSet.stream().filter(arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)).iterator();
        if (iterator == null) {
            FileBasedIndexEx.$$$reportNull$$$0(110);
        }
        return iterator;
    }

    @ApiStatus.Internal
    @Nullable
    public static Iterator<VirtualFile> extractSingleFileOrEmpty(@Nullable GlobalSearchScope scope) {
        Collection scopeAsFileIterable;
        if (scope == null) {
            return null;
        }
        VirtualFileEnumeration enumeration = VirtualFileEnumeration.extract((GlobalSearchScope)scope);
        Iterable iterable = enumeration != null ? enumeration.getFilesIfCollection() : (scopeAsFileIterable = scope instanceof Iterable ? (Iterable)scope : null);
        if (scopeAsFileIterable == null) {
            return null;
        }
        VirtualFile result = null;
        boolean isFirst = true;
        for (VirtualFile file : scopeAsFileIterable) {
            if (!isFirst) {
                return null;
            }
            result = file;
            isFirst = false;
        }
        return isFirst ? Collections.emptyIterator() : (result instanceof VirtualFileWithId ? ObjectIterators.singleton(result) : null);
    }

    @NotNull
    public static Iterable<VirtualFile> toFileIterable(final int @NotNull [] fileIds) {
        if (fileIds == null) {
            FileBasedIndexEx.$$$reportNull$$$0(111);
        }
        if (fileIds.length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                FileBasedIndexEx.$$$reportNull$$$0(112);
            }
            return list;
        }
        Iterable<VirtualFile> iterable = () -> new Iterator<VirtualFile>(){
            int myId;
            VirtualFile myNext;

            @Override
            public boolean hasNext() {
                while (this.myNext == null && this.myId < fileIds.length) {
                    this.myNext = VirtualFileManager.getInstance().findFileById(fileIds[this.myId++]);
                }
                return this.myNext != null;
            }

            @Override
            public VirtualFile next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                VirtualFile next = this.myNext;
                this.myNext = null;
                return next;
            }
        };
        if (iterable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(113);
        }
        return iterable;
    }

    @NotNull
    private static <K> Processor<? super K> maybeWrapAsCancellable(@NotNull Processor<? super K> processor) {
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(114);
        }
        if (IndexStorageLockingBase.MAKE_INDEX_LOOKUP_CANCELLABLE) {
            return new ProcessorWithThrottledCancellationCheck(processor);
        }
        Processor<? super K> processor2 = processor;
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(115);
        }
        return processor2;
    }

    private static /* synthetic */ boolean lambda$getContainingFilesIterator$6(IntPredicate accessibleFileFilter, IdFilter filter, IntSet fileIdsInner, ValueContainer container) throws RuntimeException {
        return container.forEach((id, value) -> {
            ProgressManager.checkCanceled();
            if (!accessibleFileFilter.test(id) || filter != null && !filter.containsFileId(id)) {
                return true;
            }
            fileIdsInner.add(id);
            return true;
        });
    }

    private /* synthetic */ boolean lambda$getValues$2(IntPredicate accessibleFileFilter, IdFilter filter, GlobalSearchScope scope, List values, InvertedIndexValueIterator valueIt) {
        while (valueIt.hasNext()) {
            Object value = valueIt.next();
            boolean isValueAccessible = false;
            ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
            while (inputIdsIterator.hasNext()) {
                int id = inputIdsIterator.next();
                if (!accessibleFileFilter.test(id) || filter != null && !filter.containsFileId(id)) continue;
                VirtualFile file = this.findFileById(id);
                if (file != null && scope.contains(file)) {
                    isValueAccessible = true;
                    break;
                }
                ProgressManager.checkCanceled();
            }
            if (!isValueAccessible) continue;
            values.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$1(List values, VirtualFile file, Object value) {
        values.add(value);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 17, 18, 19, 26, 30, 31, 32, 33, 84, 85, 96, 97, 110, 112, 113, 115 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 24: 
            case 28: 
            case 35: 
            case 39: 
            case 48: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 3: 
            case 13: 
            case 29: 
            case 50: 
            case 54: 
            case 58: 
            case 88: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 84: 
            case 85: 
            case 96: 
            case 97: 
            case 110: 
            case 112: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 7: 
            case 16: 
            case 22: 
            case 43: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 36: 
            case 40: 
            case 51: 
            case 55: 
            case 63: 
            case 67: 
            case 70: 
            case 73: 
            case 76: 
            case 81: 
            case 94: 
            case 95: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: 
            case 37: 
            case 41: 
            case 45: 
            case 62: 
            case 66: 
            case 69: 
            case 72: 
            case 77: 
            case 91: 
            case 93: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 46: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProcessor";
                break;
            }
            case 61: 
            case 65: 
            case 75: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 79: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLimitFileTypes";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFilesIterator";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableFilesProviders";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritCurrentDumbAccessType";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyFileIterator";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileIterable";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "maybeWrapAsCancellable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTraceStubUpdates";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 84: 
            case 85: 
            case 96: 
            case 97: 
            case 110: 
            case 112: 
            case 113: 
            case 115: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSingleEntryIndexData";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilesIterator";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readIndexAndProcessExceptions";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processValueIterator";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAnyKey";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeysInPhysicalFiles";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithKey";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRebuild";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableFilesProviders";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAllKeys";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAnyKey";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "inheritCurrentDumbAccessType";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "extractCauseToRebuildIndex";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInput";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "composeInputFilter";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createLazyFileIterator";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "toFileIterable";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "maybeWrapAsCancellable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 17, 18, 19, 26, 30, 31, 32, 33, 84, 85, 96, 97, 110, 112, 113, 115 -> new IllegalStateException(string);
        };
    }
}

