/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u00020\u0005\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"NO_ISSUE_SPECIFIED", "", "toKotlinVersion", "Lkotlin/KotlinVersion;", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isPreRelease", "", "forcesPreReleaseBinariesIfEnabled", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "getCustomizedEffectivelyEnabledLanguageFeatures", "", "getCustomizedEffectivelyDisabledLanguageFeatures", "isEnabledByDefault", "languageFeature", "util"})
@SourceDebugExtension(value={"SMAP\nLanguageVersionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,842:1\n1651#2:843\n1915#2:844\n1916#2:847\n1652#2:848\n1651#2:849\n1915#2:850\n1916#2:852\n1652#2:853\n1#3:845\n1#3:846\n1#3:851\n*S KotlinDebug\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsKt\n*L\n829#1:843\n829#1:844\n829#1:847\n829#1:848\n835#1:849\n835#1:850\n835#1:852\n835#1:853\n829#1:846\n835#1:851\n*E\n"})
public final class LanguageVersionSettingsKt {
    @NotNull
    public static final String NO_ISSUE_SPECIFIED = "No YT issue";

    @NotNull
    public static final KotlinVersion toKotlinVersion(@NotNull LanguageVersion $this$toKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinVersion, (String)"<this>");
        return new KotlinVersion($this$toKotlinVersion.getMajor(), $this$toKotlinVersion.getMinor());
    }

    @NotNull
    public static final KotlinVersion toKotlinVersion(@NotNull LanguageVersionSettings $this$toKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinVersion, (String)"<this>");
        return LanguageVersionSettingsKt.toKotlinVersion($this$toKotlinVersion.getLanguageVersion());
    }

    public static final boolean isPreRelease(@NotNull LanguageVersion $this$isPreRelease) {
        Intrinsics.checkNotNullParameter((Object)$this$isPreRelease, (String)"<this>");
        if (!$this$isPreRelease.isStable()) {
            return true;
        }
        return KotlinCompilerVersion.isPreRelease() && $this$isPreRelease == LanguageVersion.LATEST_STABLE;
    }

    public static final boolean forcesPreReleaseBinariesIfEnabled(@NotNull LanguageFeature $this$forcesPreReleaseBinariesIfEnabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forcesPreReleaseBinariesIfEnabled), (String)"<this>");
        LanguageVersion languageVersion = $this$forcesPreReleaseBinariesIfEnabled.getSinceVersion();
        boolean isFeatureNotReleasedYet = !(languageVersion != null ? languageVersion.isStable() : false);
        return isFeatureNotReleasedYet && $this$forcesPreReleaseBinariesIfEnabled.getForcesPreReleaseBinaries();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<LanguageFeature> getCustomizedEffectivelyEnabledLanguageFeatures(@NotNull LanguageVersionSettings $this$getCustomizedEffectivelyEnabledLanguageFeatures) {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getCustomizedEffectivelyEnabledLanguageFeatures, (String)"<this>");
        Iterable iterable = $this$getCustomizedEffectivelyEnabledLanguageFeatures.getCustomizedLanguageFeatures().entrySet();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LanguageFeature it$iv;
            LanguageFeature languageFeature;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
            LanguageFeature.State state = (LanguageFeature.State)entry.getValue();
            LanguageFeature it = languageFeature = feature;
            boolean bl3 = false;
            if ((!LanguageVersionSettingsKt.isEnabledByDefault($this$getCustomizedEffectivelyEnabledLanguageFeatures, feature) && state == LanguageFeature.State.ENABLED ? languageFeature : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<LanguageFeature> getCustomizedEffectivelyDisabledLanguageFeatures(@NotNull LanguageVersionSettings $this$getCustomizedEffectivelyDisabledLanguageFeatures) {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getCustomizedEffectivelyDisabledLanguageFeatures, (String)"<this>");
        Iterable iterable = $this$getCustomizedEffectivelyDisabledLanguageFeatures.getCustomizedLanguageFeatures().entrySet();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LanguageFeature it$iv;
            LanguageFeature languageFeature;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
            LanguageFeature.State state = (LanguageFeature.State)entry.getValue();
            LanguageFeature it = languageFeature = feature;
            boolean bl3 = false;
            if ((LanguageVersionSettingsKt.isEnabledByDefault($this$getCustomizedEffectivelyDisabledLanguageFeatures, feature) && state == LanguageFeature.State.DISABLED ? languageFeature : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    public static final boolean isEnabledByDefault(@NotNull LanguageVersionSettings $this$isEnabledByDefault, @NotNull LanguageFeature languageFeature) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnabledByDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)languageFeature), (String)"languageFeature");
        return languageFeature.getSinceVersion() != null && $this$isEnabledByDefault.getLanguageVersion().compareTo((Enum)languageFeature.getSinceVersion()) >= 0 && $this$isEnabledByDefault.getApiVersion().compareTo(languageFeature.getSinceApiVersion()) >= 0;
    }
}

