/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.LenientUnresolvedLibrary;
import org.jetbrains.kotlin.library.RequiredUnresolvedLibrary;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a*\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a)\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\r*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"KOTLINTEST_MODULE_NAME", "", "KOTLIN_JS_STDLIB_NAME", "KOTLIN_NATIVE_STDLIB_NAME", "KOTLIN_WASM_STDLIB_NAME", "validFileOrNull", "Lorg/jetbrains/kotlin/konan/file/File;", "path", "validateNoLibrariesWerePassedViaCliByUniqueName", "", "givenNames", "", "resolvedLibraries", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "resolve", "L", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nSearchPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchPathResolver.kt\norg/jetbrains/kotlin/library/SearchPathResolverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n865#2,2:366\n*S KotlinDebug\n*F\n+ 1 SearchPathResolver.kt\norg/jetbrains/kotlin/library/SearchPathResolverKt\n*L\n331#1:366,2\n*E\n"})
public final class SearchPathResolverKt {
    @NotNull
    public static final String KOTLIN_NATIVE_STDLIB_NAME = "stdlib";
    @NotNull
    public static final String KOTLIN_JS_STDLIB_NAME = "kotlin";
    @NotNull
    public static final String KOTLIN_WASM_STDLIB_NAME = "kotlin";
    @NotNull
    public static final String KOTLINTEST_MODULE_NAME = "kotlin-test";

    @Nullable
    public static final <L extends KotlinLibrary> L resolve(@NotNull SearchPathResolver<L> $this$resolve, @NotNull UnresolvedLibrary unresolved) {
        L l;
        Intrinsics.checkNotNullParameter($this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        UnresolvedLibrary unresolvedLibrary = unresolved;
        if (unresolvedLibrary instanceof LenientUnresolvedLibrary) {
            l = $this$resolve.resolve((LenientUnresolvedLibrary)unresolved);
        } else if (unresolvedLibrary instanceof RequiredUnresolvedLibrary) {
            l = $this$resolve.resolve((RequiredUnresolvedLibrary)unresolved);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateNoLibrariesWerePassedViaCliByUniqueName(@NotNull List<String> givenNames, @NotNull List<? extends KotlinLibrary> resolvedLibraries, @NotNull Logger logger) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(givenNames, (String)"givenNames");
        Intrinsics.checkNotNullParameter(resolvedLibraries, (String)"resolvedLibraries");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (givenNames.isEmpty() || resolvedLibraries.isEmpty()) {
            return;
        }
        Iterable iterable = givenNames;
        Collection collection = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String givenName = (String)element$iv;
            boolean bl = false;
            File given = SearchPathResolverKt.validFileOrNull(givenName);
            if (!(given == null || given.getNameSegments().size() == 1)) continue;
            collection.add(element$iv);
        }
        Set potentiallyUniqueNames = (Set)collection;
        if (potentiallyUniqueNames.isEmpty()) {
            return;
        }
        for (KotlinLibrary kotlinLibrary : resolvedLibraries) {
            String uniqueName = KotlinLibraryKt.getUniqueName(kotlinLibrary);
            if (!potentiallyUniqueNames.contains(uniqueName) || Intrinsics.areEqual((Object)uniqueName, (Object)kotlinLibrary.getLibraryFile().getName())) continue;
            logger.error("KLIB resolver: Library '" + kotlinLibrary.getLibraryFile() + "' was found by its unique name '" + uniqueName + "'. This could happen if the library unique name was passed instead of the library path via the compiler CLI argument `-library` (`-l`). Note that using unique name is deprecated and will become unavailable in one of the future Kotlin releases. Please, specify full paths to libraries in compiler CLI arguments.");
        }
    }

    private static final File validFileOrNull(String path) {
        File file;
        try {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            file = new File(path2);
        }
        catch (InvalidPathException _) {
            file = null;
        }
        return file;
    }

    public static final /* synthetic */ File access$validFileOrNull(String path) {
        return SearchPathResolverKt.validFileOrNull(path);
    }
}

