/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.inference.components.AbstractVariableReadinessCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.InferenceLogger;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;
import org.jetbrains.kotlin.types.model.TypeSystemContextContextualKt;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContextContextualKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000b\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u0013*\u00020\u000eH\u0002R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractVariableReadinessCalculator;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator$TypeVariableFixationReadiness;", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "inferenceLoggerParameter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger;)V", "getReadiness", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "c", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "dependencyProvider", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;)Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator$TypeVariableFixationReadiness;", "hasLowerNonNothingNonIltProperConstraint", "", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;)Z", "typeVariableHasProperConstraint", "typeVariable", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;)Z", "prepareVariableForFixation", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "candidate", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;)Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "TypeVariableFixationReadinessQuality", "TypeVariableFixationReadiness", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nVariableReadinessCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableReadinessCalculator.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1807#2,3:174\n*S KotlinDebug\n*F\n+ 1 VariableReadinessCalculator.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator\n*L\n138#1:174,3\n*E\n"})
public final class VariableReadinessCalculator
extends AbstractVariableReadinessCalculator<TypeVariableFixationReadiness> {
    public VariableReadinessCalculator(@NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceLogger inferenceLoggerParameter) {
        Intrinsics.checkNotNullParameter((Object)trivialConstraintTypeInferenceOracle, (String)"trivialConstraintTypeInferenceOracle");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        super(trivialConstraintTypeInferenceOracle, languageVersionSettings, inferenceLoggerParameter);
    }

    public /* synthetic */ VariableReadinessCalculator(TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, LanguageVersionSettings languageVersionSettings, InferenceLogger inferenceLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            inferenceLogger = null;
        }
        this(trivialConstraintTypeInferenceOracle, languageVersionSettings, inferenceLogger);
    }

    @Override
    @NotNull
    public TypeVariableFixationReadiness getReadiness(@NotNull VariableFixationFinder.Context c, @NotNull TypeConstructorMarker $this$getReadiness, @NotNull TypeVariableDependencyInformationProvider dependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)$this$getReadiness, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        TypeVariableFixationReadiness readiness = new TypeVariableFixationReadiness();
        boolean forbidden = !c.getNotFixedTypeVariables().containsKey($this$getReadiness) || dependencyProvider.isVariableRelatedToTopLevelType($this$getReadiness) || this.hasUnprocessedConstraintsInForks(c, $this$getReadiness);
        boolean areAllProperConstraintsSelfTypeBased = this.areAllProperConstraintsSelfTypeBased(c, $this$getReadiness);
        readiness.set(TypeVariableFixationReadinessQuality.ALLOWED, !forbidden);
        if (forbidden) {
            return readiness;
        }
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_CONSTRAINTS, this.hasProperArgumentConstraints(c, $this$getReadiness) || areAllProperConstraintsSelfTypeBased);
        readiness.set(TypeVariableFixationReadinessQuality.HAS_NO_OUTER_TYPE_VARIABLE_DEPENDENCY, !dependencyProvider.isRelatedToOuterTypeVariable($this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_CAPTURED_UPPER_BOUND_WITH_SELF_TYPES, areAllProperConstraintsSelfTypeBased && this.getFixationEnhancementsIn22() && !this.isReified(c, $this$getReadiness) && this.hasDirectConstraintToNotFixedRelevantVariable(c, $this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_NON_SELF_TYPE_BASED_CONSTRAINT, readiness.get(TypeVariableFixationReadinessQuality.HAS_PROPER_CONSTRAINTS) && !areAllProperConstraintsSelfTypeBased);
        readiness.set(TypeVariableFixationReadinessQuality.HAS_NO_DEPENDENCIES_TO_OTHER_VARIABLES, !this.hasDependencyToOtherTypeVariables(c, $this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_NON_TRIVIAL_CONSTRAINTS, !this.allConstraintsTrivialOrNonProper(c, $this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_NO_RELATION_TO_ANY_OUTPUT_TYPE, !dependencyProvider.isVariableRelatedToAnyOutputType($this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_NON_TRIVIAL_CONSTRAINTS_OTHER_THAN_INCORPORATED_FROM_DECLARED_UPPER_BOUND, !this.hasOnlyIncorporatedConstraintsFromDeclaredUpperBound(c, $this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.REIFIED, this.isReified(c, $this$getReadiness));
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_NON_NOTHING_NON_ILT_LOWER_CONSTRAINT, this.hasLowerNonNothingNonIltProperConstraint(c, $this$getReadiness));
        boolean hasProperNonIltConstraint = this.computeIltConstraintsRelatedFlags(c, $this$getReadiness).component2();
        readiness.set(TypeVariableFixationReadinessQuality.HAS_PROPER_NON_ILT_CONSTRAINT, hasProperNonIltConstraint);
        return readiness;
    }

    private final boolean hasLowerNonNothingNonIltProperConstraint(VariableFixationFinder.Context c, TypeConstructorMarker $this$hasLowerNonNothingNonIltProperConstraint) {
        boolean bl;
        block4: {
            Object object = c.getNotFixedTypeVariables().get($this$hasLowerNonNothingNonIltProperConstraint);
            if (object == null || (object = object.getConstraints()) == null) {
                return false;
            }
            Object constraints = object;
            Iterable $this$any$iv = (Iterable)constraints;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint constraint = (Constraint)element$iv;
                    boolean bl2 = false;
                    if (!(constraint.getKind().isLower() && this.isProperArgumentConstraint(c, constraint) && !TypeSystemContextContextualKt.isNothingConstructor(c, TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)c, constraint.getType())) && !TypeSystemInferenceExtensionContextContextualKt.contains(c, constraint.getType(), (Function1<? super KotlinTypeMarker, Boolean>)((Function1)arg_0 -> VariableReadinessCalculator.hasLowerNonNothingNonIltProperConstraint$lambda$0$0(c, arg_0))))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean typeVariableHasProperConstraint(@NotNull VariableFixationFinder.Context c, @NotNull TypeConstructorMarker typeVariable, @NotNull TypeVariableDependencyInformationProvider dependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        TypeVariableFixationReadiness readiness = this.getReadiness(c, typeVariable, dependencyProvider);
        return readiness.get(TypeVariableFixationReadinessQuality.ALLOWED) && readiness.get(TypeVariableFixationReadinessQuality.HAS_PROPER_CONSTRAINTS);
    }

    @Override
    @Nullable
    public VariableFixationFinder.VariableForFixation prepareVariableForFixation(@NotNull VariableFixationFinder.Context c, @NotNull TypeConstructorMarker candidate2, @NotNull TypeVariableDependencyInformationProvider dependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        TypeVariableFixationReadiness readiness = this.getReadiness(c, candidate2, dependencyProvider);
        return !readiness.get(TypeVariableFixationReadinessQuality.ALLOWED) ? null : new VariableFixationFinder.VariableForFixation(candidate2, readiness.get(TypeVariableFixationReadinessQuality.HAS_PROPER_CONSTRAINTS), !readiness.get(TypeVariableFixationReadinessQuality.HAS_NO_OUTER_TYPE_VARIABLE_DEPENDENCY));
    }

    private static final boolean hasLowerNonNothingNonIltProperConstraint$lambda$0$0(VariableFixationFinder.Context $c, KotlinTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeSystemContextContextualKt.isIntegerLiteralTypeConstructor($c, TypeSystemContextContextualKt.typeConstructor((TypeSystemContext)$c, it));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u0012\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0082\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator$TypeVariableFixationReadiness;", "", "<init>", "()V", "bitMask", "", "get", "", "index", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator$TypeVariableFixationReadinessQuality;", "set", "", "value", "compareTo", "other", "resolution.common"})
    public static final class TypeVariableFixationReadiness
    implements Comparable<TypeVariableFixationReadiness> {
        private int bitMask;

        public final boolean get(@NotNull TypeVariableFixationReadinessQuality index) {
            Intrinsics.checkNotNullParameter((Object)((Object)index), (String)"index");
            return (this.bitMask & index.getMask()) != 0;
        }

        public final void set(@NotNull TypeVariableFixationReadinessQuality index, boolean value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)index), (String)"index");
            int conditionalMask = value2 ? index.getMask() : 0;
            this.bitMask = this.bitMask & ~index.getMask() | conditionalMask;
        }

        @Override
        public int compareTo(@NotNull TypeVariableFixationReadiness other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.bitMask - other.bitMask;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableReadinessCalculator$TypeVariableFixationReadinessQuality;", "", "<init>", "(Ljava/lang/String;I)V", "ALLOWED", "HAS_PROPER_CONSTRAINTS", "HAS_NO_OUTER_TYPE_VARIABLE_DEPENDENCY", "HAS_CAPTURED_UPPER_BOUND_WITH_SELF_TYPES", "HAS_PROPER_NON_SELF_TYPE_BASED_CONSTRAINT", "HAS_NO_DEPENDENCIES_TO_OTHER_VARIABLES", "HAS_PROPER_NON_TRIVIAL_CONSTRAINTS", "HAS_NO_RELATION_TO_ANY_OUTPUT_TYPE", "HAS_PROPER_NON_TRIVIAL_CONSTRAINTS_OTHER_THAN_INCORPORATED_FROM_DECLARED_UPPER_BOUND", "REIFIED", "HAS_PROPER_NON_NOTHING_NON_ILT_LOWER_CONSTRAINT", "HAS_PROPER_NON_ILT_CONSTRAINT", "mask", "", "getMask", "()I", "resolution.common"})
    public static final class TypeVariableFixationReadinessQuality
    extends Enum<TypeVariableFixationReadinessQuality> {
        private final int mask;
        public static final /* enum */ TypeVariableFixationReadinessQuality ALLOWED = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_CONSTRAINTS = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_NO_OUTER_TYPE_VARIABLE_DEPENDENCY = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_CAPTURED_UPPER_BOUND_WITH_SELF_TYPES = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_NON_SELF_TYPE_BASED_CONSTRAINT = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_NO_DEPENDENCIES_TO_OTHER_VARIABLES = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_NON_TRIVIAL_CONSTRAINTS = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_NO_RELATION_TO_ANY_OUTPUT_TYPE = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_NON_TRIVIAL_CONSTRAINTS_OTHER_THAN_INCORPORATED_FROM_DECLARED_UPPER_BOUND = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality REIFIED = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_NON_NOTHING_NON_ILT_LOWER_CONSTRAINT = new TypeVariableFixationReadinessQuality();
        public static final /* enum */ TypeVariableFixationReadinessQuality HAS_PROPER_NON_ILT_CONSTRAINT = new TypeVariableFixationReadinessQuality();
        private static final /* synthetic */ TypeVariableFixationReadinessQuality[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TypeVariableFixationReadinessQuality() {
            if (!(this.ordinal() < 30)) {
                throw new IllegalStateException("Check failed.");
            }
            this.mask = 1 << 30 - this.ordinal();
        }

        public final int getMask() {
            return this.mask;
        }

        public static TypeVariableFixationReadinessQuality[] values() {
            return (TypeVariableFixationReadinessQuality[])$VALUES.clone();
        }

        public static TypeVariableFixationReadinessQuality valueOf(String value2) {
            return Enum.valueOf(TypeVariableFixationReadinessQuality.class, value2);
        }

        @NotNull
        public static EnumEntries<TypeVariableFixationReadinessQuality> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeVariableFixationReadinessQualityArray = new TypeVariableFixationReadinessQuality[]{TypeVariableFixationReadinessQuality.ALLOWED, TypeVariableFixationReadinessQuality.HAS_PROPER_CONSTRAINTS, TypeVariableFixationReadinessQuality.HAS_NO_OUTER_TYPE_VARIABLE_DEPENDENCY, TypeVariableFixationReadinessQuality.HAS_CAPTURED_UPPER_BOUND_WITH_SELF_TYPES, TypeVariableFixationReadinessQuality.HAS_PROPER_NON_SELF_TYPE_BASED_CONSTRAINT, TypeVariableFixationReadinessQuality.HAS_NO_DEPENDENCIES_TO_OTHER_VARIABLES, TypeVariableFixationReadinessQuality.HAS_PROPER_NON_TRIVIAL_CONSTRAINTS, TypeVariableFixationReadinessQuality.HAS_NO_RELATION_TO_ANY_OUTPUT_TYPE, TypeVariableFixationReadinessQuality.HAS_PROPER_NON_TRIVIAL_CONSTRAINTS_OTHER_THAN_INCORPORATED_FROM_DECLARED_UPPER_BOUND, TypeVariableFixationReadinessQuality.REIFIED, TypeVariableFixationReadinessQuality.HAS_PROPER_NON_NOTHING_NON_ILT_LOWER_CONSTRAINT, TypeVariableFixationReadinessQuality.HAS_PROPER_NON_ILT_CONSTRAINT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

