/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.inspections;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.inspections.QsLocalInspectionTool;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParameterEx;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection;", "Lcom/intellij/quarkus/inspections/QsLocalInspectionTool;", "<init>", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "reportPrivateModifier", "", "uElement", "Lorg/jetbrains/uast/UElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "reportedMembers", "", "Lcom/intellij/psi/PsiElement;", "isInjectionPointDefinedInClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "ip", "Lcom/intellij/cdi/beans/InjectionPointDescriptor;", "isMethodDefinedInClass", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "RemovePrivateModifierFix", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsPrivateBeanMembersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPrivateBeanMembersInspection.kt\ncom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,123:1\n171#2:124\n171#2:125\n*S KotlinDebug\n*F\n+ 1 QsPrivateBeanMembersInspection.kt\ncom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection\n*L\n51#1:124\n62#1:125\n*E\n"})
public final class QsPrivateBeanMembersInspection
extends QsLocalInspectionTool {
    public QsPrivateBeanMembersInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass));
        if (module == null || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        HashSet reportedOwners = new HashSet();
        Set injectionPoints = CdiInjectionUtils.getInjectionPoints((PsiClass)psiClass);
        for (Object injectionPoint : injectionPoints) {
            UElement uParameterParent;
            PsiModifierListOwner ipOwner;
            Intrinsics.checkNotNull((Object)injectionPoint);
            if (!this.isInjectionPointDefinedInClass(psiClass, (InjectionPointDescriptor)injectionPoint)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)injectionPoint.getOwner(), (String)"getOwner(...)");
            if (!ipOwner.isValid()) continue;
            Class[] classArray = new Class[]{UField.class, UParameter.class};
            UElement uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiElement)ipOwner), (Class[])classArray);
            if (uElement instanceof UFieldEx) {
                if (!((UFieldEx)uElement).getJavaPsi().hasModifierProperty("private")) continue;
                this.reportPrivateModifier(uElement, holder, reportedOwners);
                continue;
            }
            if (!(uElement instanceof UParameterEx) || !((uParameterParent = ((UParameterEx)uElement).getUastParent()) instanceof UMethod) || !((UMethod)uParameterParent).getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier(uParameterParent, holder, reportedOwners);
        }
        List list = CdiCommonUtils.getObservesMethods((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getObservesMethods(...)");
        List observesMethods = list;
        for (PsiMethod observesMethod : observesMethods) {
            Intrinsics.checkNotNull((Object)observesMethod);
            if (!this.isMethodDefinedInClass(psiClass, observesMethod)) continue;
            PsiElement $this$toUElementOfType$iv = (PsiElement)observesMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod == null || !uMethod.getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier((UElement)uMethod, holder, reportedOwners);
        }
        Set set = CdiCommonUtils.getDisposerMethods((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getDisposerMethods(...)");
        Set disposerMethods = set;
        for (PsiMethod disposerMethod : disposerMethods) {
            Intrinsics.checkNotNull((Object)disposerMethod);
            if (!this.isMethodDefinedInClass(psiClass, disposerMethod)) continue;
            PsiElement $this$toUElementOfType$iv = (PsiElement)disposerMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod == null || !uMethod.getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier((UElement)uMethod, holder, reportedOwners);
        }
        return holder.getResultsArray();
    }

    private final void reportPrivateModifier(UElement uElement, ProblemsHolder holder, Set<PsiElement> reportedMembers) {
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (CollectionsKt.contains((Iterable)reportedMembers, (Object)sourcePsi)) {
            return;
        }
        if (sourcePsi instanceof PsiModifierListOwner) {
            PsiElement[] modifiers;
            PsiModifierList psiModifierList = ((PsiModifierListOwner)sourcePsi).getModifierList();
            Object object = modifiers = psiModifierList != null ? psiModifierList.getChildren() : null;
            if (modifiers != null) {
                for (PsiElement localQuickFixArray : modifiers) {
                    Intrinsics.checkNotNull((Object)localQuickFixArray);
                    PsiElement child = localQuickFixArray;
                    if (!child.textMatches((CharSequence)"private")) continue;
                    reportedMembers.add(sourcePsi);
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{new RemovePrivateModifierFix()};
                    holder.registerProblem(child, QuarkusBundle.message("inspection.message.private.bean.members", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray2);
                    break;
                }
            }
        }
    }

    private final boolean isInjectionPointDefinedInClass(PsiClass psiClass, InjectionPointDescriptor ip) {
        return Intrinsics.areEqual((Object)psiClass, (Object)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ip.getOwner()), PsiClass.class));
    }

    private final boolean isMethodDefinedInClass(PsiClass psiClass, PsiMethod psiMethod) {
        return Intrinsics.areEqual((Object)psiClass, (Object)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiMethod), PsiClass.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection$RemovePrivateModifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.quarkus"})
    @SourceDebugExtension(value={"SMAP\nQsPrivateBeanMembersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPrivateBeanMembersInspection.kt\ncom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection$RemovePrivateModifierFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,123:1\n66#2,2:124\n*S KotlinDebug\n*F\n+ 1 QsPrivateBeanMembersInspection.kt\ncom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection$RemovePrivateModifierFix\n*L\n115#1:124,2\n*E\n"})
    private static final class RemovePrivateModifierFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return QuarkusBundle.message("inspection.fix.remove.private.modifier", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement problemElement = descriptor.getPsiElement();
                if (problemElement == null || !problemElement.isValid()) {
                    return;
                }
                if (!(problemElement instanceof PsiModifierListOwner)) {
                    PsiElement $this$parentOfType_u24default$iv = problemElement;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    problemElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiModifierListOwner.class, (boolean)true);
                }
                if (problemElement == null) break block3;
                PsiModifierList psiModifierList = ((PsiModifierListOwner)problemElement).getModifierList();
                if (psiModifierList != null) {
                    psiModifierList.setModifierProperty("private", false);
                }
            }
        }
    }
}

