/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.maven;

import com.intellij.CommonBundle;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.debugger.engine.DelayedRemoteConnectionImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentExtKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.jvm.util.PortBindingNotificationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.maven.QsMavenRunConfigurationBase;
import com.intellij.quarkus.maven.QsMavenRunConfigurationKt;
import com.intellij.quarkus.maven.QsMavenRunConfigurationSettingsEditor;
import com.intellij.quarkus.run.QsDebugState;
import com.intellij.quarkus.run.QsRunConfigurationService;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.quarkus.run.QsTargetConfigurationExtension;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.MavenRunnerSettingsEditor;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.run.MavenCommandLineState;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/quarkus/maven/QsMavenRunConfiguration;", "Lcom/intellij/quarkus/maven/QsMavenRunConfigurationBase;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "attachDebugger", "", "debugPort", "", "prepareRunnerSettings", "Lorg/jetbrains/idea/maven/execution/MavenRunnerSettings;", "removeMavenEventListener", "parameters", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "clone", "QsMavenState", "intellij.quarkus.maven"})
@SourceDebugExtension(value={"SMAP\nQsMavenRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsMavenRunConfiguration.kt\ncom/intellij/quarkus/maven/QsMavenRunConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n1915#2,2:351\n*S KotlinDebug\n*F\n+ 1 QsMavenRunConfiguration.kt\ncom/intellij/quarkus/maven/QsMavenRunConfiguration\n*L\n96#1:351,2\n*E\n"})
public final class QsMavenRunConfiguration
extends QsMavenRunConfigurationBase {
    @NotNull
    private final Module module;

    public QsMavenRunConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.module = module;
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (executor instanceof DefaultDebugExecutor) {
            int port = NetUtils.findAvailableSocketPort();
            QsMavenState mavenState = new QsMavenState(this, environment, true, port);
            String string = DebuggerManagerImpl.LOCALHOST_ADDRESS_FALLBACK;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LOCALHOST_ADDRESS_FALLBACK");
            DelayedRemoteConnectionImpl remoteConnection = new DelayedRemoteConnectionImpl(true, string, String.valueOf(port), false);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RemoteConnection remoteConnection2 = (RemoteConnection)remoteConnection;
            TargetEnvironmentAwareRunProfileState targetEnvironmentAwareRunProfileState = (TargetEnvironmentAwareRunProfileState)mavenState;
            String string2 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return (RunProfileState)new QsDebugState(project, remoteConnection2, targetEnvironmentAwareRunProfileState, string2, (Function0<Boolean>)((Function0)() -> QsMavenRunConfiguration.getState$lambda$0(this, mavenState)));
        }
        return (RunProfileState)new QsMavenState(this, environment, false, 0);
    }

    private final JavaParameters createJavaParameters(boolean attachDebugger, int debugPort) throws ExecutionException {
        MavenRunnerSettings runnerSettings = this.prepareRunnerSettings(attachDebugger, debugPort);
        JavaParameters parameters = MavenExternalParameters.createJavaParameters((Project)this.getProject(), (MavenRunnerParameters)this.getRunnerParameters(), (MavenGeneralSettings)this.getGeneralSettings(), (MavenRunnerSettings)runnerSettings, (MavenRunConfiguration)this);
        if (!Intrinsics.areEqual((Object)this.getProfile(), (Object)"dev")) {
            parameters.getVMParametersList().addProperty("quarkus.profile", this.getProfile());
        }
        Iterable $this$forEach$iv = runnerSettings.getEnvironmentProperties().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)v);
            Object value = StringsKt.contains$default((CharSequence)v, (char)' ', (boolean)false, (int)2, null) ? "'" + v + "'" : v;
            parameters.getVMParametersList().addProperty(k, (String)value);
        }
        Intrinsics.checkNotNull((Object)parameters);
        return this.removeMavenEventListener(parameters);
    }

    private final MavenRunnerSettings prepareRunnerSettings(boolean attachDebugger, int debugPort) {
        MavenRunnerSettings mavenRunnerSettings = this.getRunnerSettings();
        if (mavenRunnerSettings == null || (mavenRunnerSettings = mavenRunnerSettings.clone()) == null) {
            MavenRunnerSettings mavenRunnerSettings2 = MavenRunner.getInstance((Project)this.getProject()).getState().clone();
            mavenRunnerSettings = mavenRunnerSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings2, (String)"clone(...)");
        }
        MavenRunnerSettings runnerSettings = mavenRunnerSettings;
        if (attachDebugger) {
            Map map = runnerSettings.getMavenProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMavenProperties(...)");
            Map map2 = map;
            String string = "debug";
            String string2 = String.valueOf(debugPort);
            map2.put(string, string2);
        }
        return runnerSettings;
    }

    private final JavaParameters removeMavenEventListener(JavaParameters parameters) {
        String listenerPath = MavenServerManager.Companion.getInstance().getMavenEventListener().getAbsolutePath();
        String extClassPath = parameters.getVMParametersList().getPropertyValue("maven.ext.class.path");
        if (extClassPath != null) {
            CharSequence charSequence = extClassPath;
            Intrinsics.checkNotNull((Object)listenerPath);
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)listenerPath, (boolean)false, (int)2, null)) {
                parameters.getVMParametersList().replaceOrAppend("-Dmaven.ext.class.path", StringsKt.replace$default((String)extClassPath, (String)listenerPath, (String)"", (boolean)false, (int)4, null));
            }
        }
        return parameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        String string = QuarkusBundle.message("run.configuration.configuration.tab", new Object[0]);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        group.addEditor(string, (SettingsEditor)new QsMavenRunConfigurationSettingsEditor(project));
        group.addEditor(CommonBundle.message((String)"tab.title.general", (Object[])new Object[0]), (SettingsEditor)new MavenGeneralSettingsEditor(this.getProject()));
        group.addEditor(RunnerBundle.message((String)"maven.tab.runner", (Object[])new Object[0]), (SettingsEditor)new MavenRunnerSettingsEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return (SettingsEditor)group;
    }

    @NotNull
    public QsMavenRunConfiguration clone() {
        MavenRunConfiguration mavenRunConfiguration = super.clone();
        Intrinsics.checkNotNull((Object)mavenRunConfiguration, (String)"null cannot be cast to non-null type com.intellij.quarkus.maven.QsMavenRunConfiguration");
        QsMavenRunConfiguration clone = (QsMavenRunConfiguration)mavenRunConfiguration;
        clone.setLocalRepoRoot(this.getLocalRepoRoot());
        return clone;
    }

    private static final boolean getState$lambda$0(QsMavenRunConfiguration this$0, QsMavenState $mavenState) {
        return QsMavenRunConfigurationKt.access$emulateTerminal(this$0, (JavaCommandLineState)$mavenState);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\b\u0010!\u001a\u00020\u0007H\u0014J0\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0002JL\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010%\u001a\u00020&2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(01H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\u0018\u00106\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\r2\u0006\u00107\u001a\u000208H\u0016JL\u0010:\u001a\b\u0012\u0004\u0012\u0002H<0;\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010(2\u0016\u0010B\u001a\u0012\u0012\u0006\b\u0001\u0012\u0002H<\u0012\u0006\b\u0001\u0012\u00020D0CH\u0016J\b\u0010E\u001a\u00020\u0007H\u0014J\u0010\u0010F\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0002J\b\u0010G\u001a\u00020\u0019H\u0002J(\u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u0002032\u000e\u0010L\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010MH\u0002J\b\u0010N\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/quarkus/maven/QsMavenRunConfiguration$QsMavenState;", "Lorg/jetbrains/idea/maven/execution/run/MavenCommandLineState;", "configuration", "Lcom/intellij/quarkus/maven/QsMavenRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "attachDebugger", "", "debugPort", "", "<init>", "(Lcom/intellij/quarkus/maven/QsMavenRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;ZI)V", "resolvedEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "targetLocalRepoResolver", "Ljava/util/function/Consumer;", "serverConfigurationPrepared", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serverConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "getJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "createJavaParameters", "createJavaParametersInternal", "updateJavaParameters", "", "parameters", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "emulateTerminal", "addPortBindingPanel", "console", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "applicationUrl", "", "applicationPort", "resolvedPort", "doRunExecute", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "descriptor", "Lcom/intellij/build/DefaultBuildDescriptor;", "targetFileMapper", "Ljava/util/function/Function;", "createTargetedCommandLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "prepareTargetEnvironmentRequest", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "handleCreatedTargetEnvironment", "prepareTargetToCommandExecution", "Lorg/jetbrains/concurrency/Promise;", "T", "", "env", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logFailureMessage", "afterPreparation", "Lcom/intellij/openapi/util/ThrowableComputable;", "Lcom/intellij/execution/ExecutionException;", "shouldPrepareDebuggerConnection", "exposePorts", "prepareServerConfiguration", "setupMavenOpts", "settings", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings;", "commandLine", "targetMavenRepoLocalPath", "Lcom/intellij/execution/target/value/TargetValue;", "deleteDevAppModel", "intellij.quarkus.maven"})
    @SourceDebugExtension(value={"SMAP\nQsMavenRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsMavenRunConfiguration.kt\ncom/intellij/quarkus/maven/QsMavenRunConfiguration$QsMavenState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,350:1\n1#2:351\n221#3,2:352\n18#4:354\n*S KotlinDebug\n*F\n+ 1 QsMavenRunConfiguration.kt\ncom/intellij/quarkus/maven/QsMavenRunConfiguration$QsMavenState\n*L\n324#1:352,2\n211#1:354\n*E\n"})
    private static final class QsMavenState
    extends MavenCommandLineState {
        @NotNull
        private final QsMavenRunConfiguration configuration;
        private final boolean attachDebugger;
        private final int debugPort;
        @Nullable
        private TargetEnvironment resolvedEnvironment;
        @Nullable
        private Consumer<TargetEnvironment> targetLocalRepoResolver;
        @NotNull
        private final AtomicBoolean serverConfigurationPrepared;
        @Nullable
        private volatile QsServerConfiguration serverConfiguration;

        public QsMavenState(@NotNull QsMavenRunConfiguration configuration, @NotNull ExecutionEnvironment environment, boolean attachDebugger, int debugPort) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            super(environment, (MavenRunConfiguration)configuration);
            this.configuration = configuration;
            this.attachDebugger = attachDebugger;
            this.debugPort = debugPort;
            this.serverConfigurationPrepared = new AtomicBoolean(false);
        }

        @NotNull
        public JavaParameters getJavaParameters() {
            JavaParameters javaParameters;
            JavaParameters p0 = javaParameters = super.getJavaParameters();
            boolean bl = false;
            this.updateJavaParameters(p0);
            JavaParameters javaParameters2 = javaParameters;
            Intrinsics.checkNotNullExpressionValue((Object)javaParameters2, (String)"also(...)");
            return javaParameters2;
        }

        @NotNull
        protected JavaParameters createJavaParameters() {
            JavaParameters javaParameters;
            JavaParameters p0 = javaParameters = this.createJavaParametersInternal();
            boolean bl = false;
            this.updateJavaParameters(p0);
            return javaParameters;
        }

        private final JavaParameters createJavaParametersInternal() {
            return this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest ? this.configuration.createJavaParameters(this.attachDebugger, this.debugPort) : new JavaParameters();
        }

        private final void updateJavaParameters(JavaParameters parameters) {
            JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.Companion.getInstance();
            RunConfigurationBase runConfigurationBase = (RunConfigurationBase)this.configuration;
            RunnerSettings runnerSettings = this.getRunnerSettings();
            Executor executor = this.getEnvironment().getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
            javaRunConfigurationExtensionManager.updateJavaParameters(runConfigurationBase, parameters, runnerSettings, executor);
        }

        @NotNull
        public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            ExecutionResult executionResult = super.execute(executor, runner);
            Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"execute(...)");
            ExecutionResult result = executionResult;
            ProcessHandler processHandler2 = result.getProcessHandler();
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(this, processHandler2){
                final /* synthetic */ QsMavenState this$0;
                final /* synthetic */ ProcessHandler $processHandler;
                {
                    this.this$0 = $receiver;
                    this.$processHandler = $processHandler;
                }

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    TargetEnvironment targetEnvironment = QsMavenState.access$getResolvedEnvironment$p(this.this$0);
                    if (targetEnvironment != null) {
                        targetEnvironment.shutdown();
                    }
                    this.$processHandler.removeProcessListener((ProcessListener)this);
                }
            });
            if (this.serverConfiguration != QsRunConfigurationService.Companion.getDEFAULT_SERVER_CONFIGURATION()) {
                QsServerConfiguration qsServerConfiguration = this.serverConfiguration;
                if (qsServerConfiguration == null) {
                    return result;
                }
                int serverPort = qsServerConfiguration.getServerPort();
                processHandler2.putUserData(QsRunConfigurationService.Companion.getAPPLICATION_SERVER_PORT_KEY(), (Object)serverPort);
                TargetEnvironment targetEnvironment = this.resolvedEnvironment;
                int localPortForServer = targetEnvironment != null && (targetEnvironment = TargetEnvironmentExtKt.findTargetPortBinding((TargetEnvironment)targetEnvironment, (int)serverPort)) != null ? ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)targetEnvironment) : serverPort;
                QsServerConfiguration qsServerConfiguration2 = this.serverConfiguration;
                Intrinsics.checkNotNull((Object)qsServerConfiguration2);
                QsServerConfiguration resolvedConfiguration = new QsServerConfiguration(localPortForServer, qsServerConfiguration2.getSslEnabled());
                processHandler2.putUserData(QsRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY(), (Object)resolvedConfiguration);
                if (localPortForServer != serverPort) {
                    ExecutionConsole executionConsole = result.getExecutionConsole();
                    ConsoleView consoleView = executionConsole instanceof ConsoleView ? (ConsoleView)executionConsole : null;
                    if (consoleView == null) {
                        return result;
                    }
                    ConsoleView console = consoleView;
                    Intrinsics.checkNotNull((Object)processHandler2);
                    this.addPortBindingPanel(console, processHandler2, resolvedConfiguration.getApplicationUrl(), serverPort, localPortForServer);
                }
            } else {
                processHandler2.putUserData(QsRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY(), (Object)this.serverConfiguration);
            }
            return result;
        }

        protected boolean emulateTerminal() {
            return QsMavenRunConfigurationKt.access$emulateTerminal(this.configuration, (JavaCommandLineState)this);
        }

        private final void addPortBindingPanel(ConsoleView console, ProcessHandler processHandler2, String applicationUrl, int applicationPort, int resolvedPort) {
            ApplicationManager.getApplication().invokeLater(() -> QsMavenState.addPortBindingPanel$lambda$0(applicationUrl, this, applicationPort, resolvedPort, processHandler2, console), arg_0 -> QsMavenState.addPortBindingPanel$lambda$1(console, arg_0));
        }

        @NotNull
        public ExecutionResult doRunExecute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner, @Nullable ExternalSystemTaskId taskId, @Nullable DefaultBuildDescriptor descriptor, @NotNull ProcessHandler processHandler2, @NotNull Function<String, String> targetFileMapper) {
            ConsoleView console;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
            Intrinsics.checkNotNullParameter(targetFileMapper, (String)"targetFileMapper");
            ConsoleView consoleView = console = this.createConsole(executor, processHandler2, this.configuration.getProject());
            if (consoleView != null) {
                consoleView.attachToProcess(processHandler2);
            }
            AnAction[] anActionArray = this.createActions(console, processHandler2, executor);
            return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, processHandler2, Arrays.copyOf(anActionArray, anActionArray.length));
        }

        @NotNull
        protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
            Pair targetLocalRepo;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.exposePorts(request);
            if (request instanceof LocalTargetEnvironmentRequest) {
                Boolean runOnRemoteTarget = (Boolean)this.configuration.module.getUserData(QsMavenRunConfigurationKt.access$getTARGET_TYPE_KEY$p());
                if (Intrinsics.areEqual((Object)true, (Object)runOnRemoteTarget)) {
                    this.deleteDevAppModel();
                }
                this.configuration.module.putUserData(QsMavenRunConfigurationKt.access$getTARGET_TYPE_KEY$p(), null);
                TargetedCommandLineBuilder targetedCommandLineBuilder = super.createTargetedCommandLine(request);
                Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLineBuilder, (String)"createTargetedCommandLine(...)");
                return targetedCommandLineBuilder;
            }
            TargetEnvironmentConfiguration targetConfiguration = request.getConfiguration();
            if (targetConfiguration == null) {
                throw new CantRunException(RunnerBundle.message((String)"cannot.find.target.environment.configuration", (Object[])new Object[0]));
            }
            this.configuration.module.putUserData(QsMavenRunConfigurationKt.access$getTARGET_TYPE_KEY$p(), (Object)true);
            this.deleteDevAppModel();
            MavenRunConfiguration.MavenSettings settings = new MavenRunConfiguration.MavenSettings(this.configuration.getProject());
            settings.myGeneralSettings = this.configuration.getGeneralSettings();
            settings.myRunnerParameters = this.configuration.getRunnerParameters();
            settings.myRunnerSettings = this.configuration.prepareRunnerSettings(this.attachDebugger, this.debugPort);
            Pair pair = targetLocalRepo = (Pair)QsTargetConfigurationExtension.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> QsMavenState.createTargetedCommandLine$lambda$0(request, targetConfiguration, this, arg_0));
            this.targetLocalRepoResolver = pair != null ? (Consumer)pair.getSecond() : null;
            TargetedCommandLineBuilder commandLine = (TargetedCommandLineBuilder)ReadAction.nonBlocking(() -> QsMavenState.createTargetedCommandLine$lambda$1(this, request, settings)).executeSynchronously();
            Intrinsics.checkNotNull((Object)commandLine);
            Pair pair2 = targetLocalRepo;
            this.setupMavenOpts(settings, commandLine, (TargetValue<String>)(pair2 != null ? (TargetValue)pair2.getFirst() : null));
            QsTargetConfigurationExtension.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> QsMavenState.createTargetedCommandLine$lambda$3(arg_0 -> QsMavenState.createTargetedCommandLine$lambda$2(targetConfiguration, commandLine, this, arg_0), arg_0));
            return commandLine;
        }

        public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
            this.prepareServerConfiguration();
            super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
        }

        public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
                super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
                this.resolvedEnvironment = environment;
                Consumer<TargetEnvironment> consumer = this.targetLocalRepoResolver;
                if (consumer == null) break block0;
                consumer.accept(environment);
            }
        }

        @NotNull
        public <T> Promise<T> prepareTargetToCommandExecution(@NotNull ExecutionEnvironment env, @NotNull Logger logger, @Nullable String logFailureMessage, @NotNull ThrowableComputable<? extends T, ? extends ExecutionException> afterPreparation) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter(afterPreparation, (String)"afterPreparation");
            ThrowableComputable wrapper = () -> QsMavenState.prepareTargetToCommandExecution$lambda$0(this, afterPreparation);
            Promise promise = super.prepareTargetToCommandExecution(env, logger, logFailureMessage, wrapper);
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"prepareTargetToCommandExecution(...)");
            return promise;
        }

        protected boolean shouldPrepareDebuggerConnection() {
            return false;
        }

        private final void exposePorts(TargetEnvironmentRequest request) {
            if (this.attachDebugger) {
                request.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(Integer.valueOf(this.debugPort), this.debugPort));
            }
            if (this.serverConfiguration != null && this.serverConfiguration != QsRunConfigurationService.Companion.getDEFAULT_SERVER_CONFIGURATION() && !(request instanceof LocalTargetEnvironmentRequest)) {
                Set set = request.getTargetPortBindings();
                QsServerConfiguration qsServerConfiguration = this.serverConfiguration;
                Intrinsics.checkNotNull((Object)qsServerConfiguration);
                set.add(new TargetEnvironment.TargetPortBinding(null, qsServerConfiguration.getServerPort()));
            }
        }

        private final void prepareServerConfiguration() {
            if (this.serverConfigurationPrepared.compareAndSet(false, true)) {
                this.serverConfiguration = QsRunConfigurationService.Companion.getInstance().getServerConfiguration(this.getJavaParameters(), this.configuration.module);
            }
        }

        private final void setupMavenOpts(MavenRunConfiguration.MavenSettings settings, TargetedCommandLineBuilder commandLine, TargetValue<String> targetMavenRepoLocalPath) {
            MavenRunnerSettings mavenRunnerSettings;
            commandLine.removeEnvironmentVariable("MAVEN_OPTS");
            List mavenOptsValues = new ArrayList();
            if (targetMavenRepoLocalPath != null) {
                TargetValue targetValue = TargetValue.map(targetMavenRepoLocalPath, arg_0 -> QsMavenState.setupMavenOpts$lambda$1(QsMavenState::setupMavenOpts$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"map(...)");
                mavenOptsValues.add(targetValue);
            }
            if ((mavenRunnerSettings = settings.myRunnerSettings) == null) {
                MavenRunnerSettings mavenRunnerSettings2 = MavenRunner.getInstance((Project)this.getEnvironment().getProject()).getState();
                mavenRunnerSettings = mavenRunnerSettings2;
                Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings2, (String)"getState(...)");
            }
            MavenRunnerSettings runnerSettings = mavenRunnerSettings;
            Map map = runnerSettings.getEnvironmentProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentProperties(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!Intrinsics.areEqual((Object)"MAVEN_OPTS", (Object)name)) continue;
                TargetValue targetValue = TargetValue.fixed((Object)value);
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
                mavenOptsValues.add(targetValue);
            }
            String string = runnerSettings.getVmOptions();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVmOptions(...)");
            if (!StringsKt.isBlank((CharSequence)string)) {
                TargetValue targetValue = TargetValue.fixed((Object)runnerSettings.getVmOptions());
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
                mavenOptsValues.add(targetValue);
            }
            TargetValue targetValue = TargetValue.composite((Collection)mavenOptsValues, arg_0 -> QsMavenState.setupMavenOpts$lambda$4(QsMavenState::setupMavenOpts$lambda$3, arg_0));
            commandLine.addEnvironmentVariable("MAVEN_OPTS", targetValue);
        }

        private final void deleteDevAppModel() {
            MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.configuration.getProject()).findProject(this.configuration.module);
            if (mavenProject == null) {
                return;
            }
            MavenProject mavenProject2 = mavenProject;
            File devAppModelFile = new File(FileUtil.toSystemIndependentName((String)mavenProject2.getBuildDirectory()) + "/quarkus/bootstrap/dev-app-model.dat");
            try {
                if (devAppModelFile.exists() && !devAppModelFile.isDirectory()) {
                    devAppModelFile.delete();
                }
            }
            catch (Exception e) {
                QsMavenRunConfigurationKt.access$getLOG$p().debug("Could not delete dev-app-model.dat", (Throwable)e);
            }
        }

        private static final void addPortBindingPanel$lambda$0(String $applicationUrl, QsMavenState this$0, int $applicationPort, int $resolvedPort, ProcessHandler $processHandler, ConsoleView $console) {
            block1: {
                NavigatorHttpRequest request = new NavigatorHttpRequest($applicationUrl, "GET", CollectionsKt.emptyList(), CollectionsKt.emptyList());
                Project project = this$0.configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string = this$0.configuration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                PortBindingNotificationPanel panel = new PortBindingNotificationPanel(project, request, string, $applicationPort, $resolvedPort);
                panel.registerProcessListener($processHandler, (Disposable)$console);
                JPanel jPanel = ServiceViewUIUtils.getServicesAlignedPanelWrapper((JComponent)((JComponent)panel));
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getServicesAlignedPanelWrapper(...)");
                JPanel wrapper = jPanel;
                wrapper.setBorder(IdeBorderFactory.createBorder((int)8));
                ConsoleView $this$asSafely$iv = $console;
                boolean $i$f$asSafely = false;
                ConsoleView consoleView = $this$asSafely$iv;
                if (!(consoleView instanceof ConsoleViewImpl)) {
                    consoleView = null;
                }
                ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)consoleView;
                if (consoleViewImpl == null) break block1;
                consoleViewImpl.addNotificationComponent((JComponent)wrapper);
            }
        }

        private static final boolean addPortBindingPanel$lambda$1(ConsoleView $console, Object it) {
            return Disposer.isDisposed((Disposable)((Disposable)$console));
        }

        private static final Pair createTargetedCommandLine$lambda$0(TargetEnvironmentRequest $request, TargetEnvironmentConfiguration $targetConfiguration, QsMavenState this$0, QsTargetConfigurationExtension it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.prepareTargetLocalRepo($request, $targetConfiguration, this$0.configuration);
        }

        private static final TargetedCommandLineBuilder createTargetedCommandLine$lambda$1(QsMavenState this$0, TargetEnvironmentRequest $request, MavenRunConfiguration.MavenSettings $settings) {
            Project project = this$0.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = this$0.configuration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new MavenCommandLineSetup(project, string, $request).setupCommandLine($settings, false).getCommandLine();
        }

        private static final Unit createTargetedCommandLine$lambda$2(TargetEnvironmentConfiguration $targetConfiguration, TargetedCommandLineBuilder $commandLine, QsMavenState this$0, QsTargetConfigurationExtension it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNull((Object)$commandLine);
            it.customizeCommandLine($targetConfiguration, $commandLine, this$0.attachDebugger);
            return Unit.INSTANCE;
        }

        private static final void createTargetedCommandLine$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object prepareTargetToCommandExecution$lambda$0(QsMavenState this$0, ThrowableComputable $afterPreparation) {
            this$0.prepareServerConfiguration();
            return $afterPreparation.compute();
        }

        private static final String setupMavenOpts$lambda$0(String it) {
            return "-Dmaven.repo.local=" + it;
        }

        private static final String setupMavenOpts$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String setupMavenOpts$lambda$3(Collection it) {
            Intrinsics.checkNotNull((Object)it);
            return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        private static final String setupMavenOpts$lambda$4(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ TargetEnvironment access$getResolvedEnvironment$p(QsMavenState $this) {
            return $this.resolvedEnvironment;
        }
    }
}

