/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"QUTE_EXTENSIONS", "", "", "QUTE_SUPPORTED_EXTENSIONS", "QUTE_LIBRARIES", "isQuteFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isQuteFileExtension", "fileName", "", "isQuteSupportedForFile", "isQuteModule", "module", "Lcom/intellij/openapi/module/Module;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQuteFileTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuteFileTypeUtils.kt\ncom/intellij/quarkus/qute/QuteFileTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1807#2,3:39\n1807#2,3:42\n*S KotlinDebug\n*F\n+ 1 QuteFileTypeUtils.kt\ncom/intellij/quarkus/qute/QuteFileTypeUtilsKt\n*L\n31#1:39,3\n33#1:42,3\n*E\n"})
public final class QuteFileTypeUtilsKt {
    @NotNull
    private static final List<String> QUTE_EXTENSIONS;
    @NotNull
    private static final List<String> QUTE_SUPPORTED_EXTENSIONS;
    @NotNull
    private static final List<String> QUTE_LIBRARIES;

    public static final boolean isQuteFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        if (QuteFileTypeUtilsKt.isQuteFileExtension(nameSequence)) {
            return true;
        }
        if (!QuteFileTypeUtilsKt.isQuteSupportedForFile(nameSequence)) {
            return false;
        }
        VirtualFile templatesDir = VfsUtil.findContainingDirectory((VirtualFile)virtualFile, (CharSequence)"templates");
        VirtualFile virtualFile2 = templatesDir;
        if (Intrinsics.areEqual((Object)(virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null ? virtualFile2.getName() : null), (Object)"resources") && ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(virtualFile)) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (module == null) {
                return false;
            }
            Module module2 = module;
            if (QuteFileTypeUtilsKt.isQuteModule(module2)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isQuteFileExtension(@NotNull CharSequence fileName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable $this$any$iv = QUTE_EXTENSIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((CharSequence)fileName, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isQuteSupportedForFile(@NotNull CharSequence fileName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable $this$any$iv = QUTE_SUPPORTED_EXTENSIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((CharSequence)fileName, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isQuteModule(Module module) {
        return JavaLibraryUtil.hasAnyLibraryJar((Module)module, (Collection)QUTE_LIBRARIES);
    }

    static {
        Object[] objectArray = new String[]{".qute.html", ".qute.htm", ".qute.txt", ".qute.json", ".qute.yaml", ".qute.yml"};
        QUTE_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{".html", ".htm", ".txt", ".json", ".yaml", ".yml"};
        QUTE_SUPPORTED_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"io.quarkus:quarkus-qute", "io.quarkus.qute:qute-core"};
        QUTE_LIBRARIES = CollectionsKt.listOf((Object[])objectArray);
    }
}

