/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.protocol;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.rd.framework.ExtCreationInfo;
import com.jetbrains.rd.framework.ExtCreationInfoEx;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SolutionModel;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.protocol.AppExtListener;
import com.jetbrains.rd.protocol.BaseExtListenerDescriptor;
import com.jetbrains.rd.protocol.ProjectExtListener;
import com.jetbrains.rd.protocol.ProtocolExtListener;
import com.jetbrains.rd.protocol.ProtocolExtListenerAdapter;
import com.jetbrains.rd.protocol.ProtocolExtListenerAdapterBase;
import com.jetbrains.rd.protocol.ProtocolExtListenerDescriptor;
import com.jetbrains.rd.protocol.ProtocolExtListenerManager;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.protocol.RootExtListenerDescriptor;
import com.jetbrains.rd.protocol.SolutionExtListenerDescriptor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.string.RName;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b&\u0018\u0000 T2\u00020\u0001:\u0002STB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\tH\u0002J\b\u0010'\u001a\u00020!H\u0002J\u0018\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0018H\u0014J\u0018\u0010,\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u00020!H\u0002J(\u00101\u001a\u00020!\"\b\b\u0000\u00102*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H2052\u0006\u00106\u001a\u000207H\u0002J'\u00108\u001a\u00020!\"\b\b\u0000\u00102*\u0002032\u0006\u00109\u001a\u0002H22\u0006\u0010:\u001a\u00020;H\u0002\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u00020!2\u0006\u00109\u001a\u0002032\u0006\u0010>\u001a\u00020;H\u0002J*\u0010?\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0018H\u0014J\u0010\u0010@\u001a\u00020\u00182\u0006\u0010A\u001a\u00020BH\u0016J\u0012\u0010C\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002JD\u0010D\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020\u00180E2\u0006\u0010\u0006\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020B0H2\u0006\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020NH\u0002J\u000e\u0010O\u001a\u0004\u0018\u00010\t*\u00020JH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010P\u001a\u0004\u0018\u00010\t*\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006U"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "protocol", "Lcom/jetbrains/rd/framework/Protocol;", "endpoint", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/framework/Protocol;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getAppSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getProtocol", "()Lcom/jetbrains/rd/framework/Protocol;", "getEndpoint", "()Ljava/lang/String;", "projectSessions", "", "Lcom/intellij/openapi/client/ClientProjectSession;", "recentlyClosedProjectSessions", "", "accumulatedMessages", "", "Lcom/jetbrains/rd/framework/ExtCreationInfoEx;", "lock", "adapters", "Lcom/intellij/util/containers/MultiMap;", "Lcom/jetbrains/rd/protocol/ProtocolExtListenerAdapterBase;", "startDeliveringMessages", "", "projectSession", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "stopDeliveringMessages", "solutionId", "adviseOnProtocol", "beforeAccumulateExcCreationSignal", "info", "Lcom/jetbrains/rd/framework/ExtCreationInfo;", "isLocal", "adviseOnSolutionsMap", "model", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "adviseOnListeners", "addSolutionModelListener", "adviseOnExtensionPoint", "T", "Lcom/jetbrains/rd/protocol/BaseExtListenerDescriptor;", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "disposable", "Lcom/intellij/openapi/Disposable;", "onExtensionAdded", "extension", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "(Lcom/jetbrains/rd/protocol/BaseExtListenerDescriptor;Lcom/intellij/openapi/extensions/PluginDescriptor;)V", "onExtensionRemoved", "pluginDescriptor", "handleMessage", "isExtListeningAllowed", "boundExt", "Lcom/jetbrains/rd/framework/base/RdExtBase;", "isDisposed", "createExtInstance", "Lkotlin/Pair;", "Lcom/jetbrains/rd/framework/IProtocol;", "extClass", "Ljava/lang/Class;", "rName", "Lcom/jetbrains/rd/util/string/RName;", "parent", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "hash", "", "tryGetSolutionId", "asSolutionId", "getAsSolutionId", "(Lcom/jetbrains/rd/util/string/RName;)Ljava/lang/String;", "SolutionModelListener", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolExtListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManagerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 7 RdBindableBase.kt\ncom/jetbrains/rd/framework/base/RdBindableBase\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,415:1\n1915#2:416\n1916#2:421\n1786#2,3:435\n1915#2,2:438\n67#3,4:417\n13#3:449\n406#4,9:422\n1#5:431\n39#6,3:432\n43#6:440\n120#7:441\n383#8,7:442\n*S KotlinDebug\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase\n*L\n79#1:416\n79#1:421\n226#1:435,3\n248#1:438,2\n80#1:417,4\n312#1:449\n188#1:422,9\n221#1:432,3\n221#1:440\n299#1:441\n125#1:442,7\n*E\n"})
public abstract class ProtocolExtListenerManagerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientAppSession appSession;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String endpoint;
    @NotNull
    private Map<String, ClientProjectSession> projectSessions;
    @NotNull
    private Map<String, Boolean> recentlyClosedProjectSessions;
    @NotNull
    private final Map<String, List<ExtCreationInfoEx>> accumulatedMessages;
    @NotNull
    private final Object lock;
    @NotNull
    private final MultiMap<String, ProtocolExtListenerAdapterBase> adapters;
    @NotNull
    private static final Logger logger;

    public ProtocolExtListenerManagerBase(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull Protocol protocol, @NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.lifetime = lifetime;
        this.appSession = appSession;
        this.protocol = protocol;
        this.endpoint = endpoint;
        this.projectSessions = new LinkedHashMap();
        this.recentlyClosedProjectSessions = new LinkedHashMap();
        this.accumulatedMessages = new LinkedHashMap();
        this.lock = new Object();
        this.adapters = new MultiMap();
        this.adviseOnListeners();
        this.adviseOnProtocol();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ClientAppSession getAppSession() {
        return this.appSession;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startDeliveringMessages(@NotNull ClientProjectSession projectSession, @NotNull Solution solution) {
        List list;
        Intrinsics.checkNotNullParameter((Object)projectSession, (String)"projectSession");
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        String solutionId = this.tryGetSolutionId(solution.getLocation());
        if (solutionId == null) {
            logger.error("Failed to get solution location for solution: " + solution.getLocation());
            return;
        }
        if (this.isDisposed(projectSession)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(this.projectSessions.get(solutionId) == null)) {
                boolean $i$a$-check-ProtocolExtListenerManagerBase$startDeliveringMessages$messages$1$22 = false;
                String $i$a$-check-ProtocolExtListenerManagerBase$startDeliveringMessages$messages$1$22 = "Tried to reset a project session " + this.projectSessions.get(solutionId) + " " + solutionId + " with " + projectSession;
                throw new IllegalStateException($i$a$-check-ProtocolExtListenerManagerBase$startDeliveringMessages$messages$1$22.toString());
            }
            this.projectSessions.put(solutionId, projectSession);
            List list2 = this.accumulatedMessages.remove(solutionId);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        List messages = list;
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtCreationInfoEx extCreationInfoEx = (ExtCreationInfoEx)element$iv;
            boolean bl = false;
            ExtCreationInfo info = extCreationInfoEx.component1();
            boolean isLocal = extCreationInfoEx.component2();
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("init listeners on background for model " + info.getRName() + ", isLocal=" + isLocal);
            }
            this.handleMessage(this.protocol, projectSession, info, isLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopDeliveringMessages(String solutionId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.accumulatedMessages.remove(solutionId);
            this.projectSessions.remove(solutionId);
            boolean bl2 = logger.assertTrue(this.recentlyClosedProjectSessions.put(solutionId, false) == null, (Object)("Solution: " + solutionId + " closed twice?"));
        }
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, solutionId, null){
            int label;
            final /* synthetic */ ProtocolExtListenerManagerBase this$0;
            final /* synthetic */ String $solutionId;
            {
                this.this$0 = $receiver;
                this.$solutionId = $solutionId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        var2_3 = ProtocolExtListenerManagerBase.access$getLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$solutionId;
                        var5_6 = var2_3;
                        synchronized (var5_6) {
                            $i$a$-synchronized-ProtocolExtListenerManagerBase$stopDeliveringMessages$2$1 = false;
                            ProtocolExtListenerManagerBase.access$getRecentlyClosedProjectSessions$p(var3_4).put(var4_5, Boxing.boxBoolean((boolean)true));
                            $i$a$-synchronized-ProtocolExtListenerManagerBase$stopDeliveringMessages$2$1 = Unit.INSTANCE;
                        }
                        this.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        var2_3 = ProtocolExtListenerManagerBase.access$getLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$solutionId;
                        var5_6 = var2_3;
                        synchronized (var5_6) {
                            $i$a$-synchronized-ProtocolExtListenerManagerBase$stopDeliveringMessages$2$2 = false;
                            ProtocolExtListenerManagerBase.access$getLogger$cp().assertTrue(ProtocolExtListenerManagerBase.access$getRecentlyClosedProjectSessions$p(var3_4).remove(var4_5) != null);
                            var6_10 = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void adviseOnProtocol() {
        IRdDispatcher scheduler = IRdDispatcherKt.getAsRdDispatcher(this.protocol.getScheduler());
        this.protocol.getExtCreated().advise(this.lifetime, arg_0 -> ProtocolExtListenerManagerBase.adviseOnProtocol$lambda$0(this, scheduler, arg_0));
    }

    protected void beforeAccumulateExcCreationSignal(@NotNull ExtCreationInfo info, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
    }

    private final void adviseOnSolutionsMap(Lifetime lifetime, SolutionModel model) {
        model.getSolutions().view(lifetime, (arg_0, arg_1) -> ProtocolExtListenerManagerBase.adviseOnSolutionsMap$lambda$0(this, arg_0, arg_1));
    }

    private final void adviseOnListeners() {
        Disposable disposable = DisposableEx.createNestedDisposable$default(this.lifetime, null, 1, null);
        this.addSolutionModelListener();
        this.adviseOnExtensionPoint(ProtocolExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
        this.adviseOnExtensionPoint(SolutionExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
        this.adviseOnExtensionPoint(RootExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
    }

    private final void addSolutionModelListener() {
        SolutionModelListener listener2 = new SolutionModelListener(this);
        this.adapters.putValue((Object)Reflection.getOrCreateKotlinClass(SolutionModel.class).getSimpleName(), (Object)new ProtocolExtListenerAdapterBase(listener2){
            private final Class<RdExtBase> extClass;
            final /* synthetic */ SolutionModelListener $listener;
            {
                this.$listener = $listener;
                this.extClass = SolutionModel.class;
            }

            public ProtocolExtListener<RdBindableBase, RdExtBase> getHandlerInstance() {
                SolutionModelListener solutionModelListener = this.$listener;
                Intrinsics.checkNotNull((Object)solutionModelListener, (String)"null cannot be cast to non-null type com.jetbrains.rd.protocol.ProtocolExtListener<com.jetbrains.rd.framework.base.RdBindableBase?, com.jetbrains.rd.framework.base.RdExtBase>");
                return solutionModelListener;
            }

            public Class<RdExtBase> getExtClass() {
                return this.extClass;
            }
        });
    }

    private final <T extends BaseExtListenerDescriptor> void adviseOnExtensionPoint(ExtensionPoint<T> extensionPoint, Disposable disposable) {
        boolean $i$f$createListener = false;
        ExtensionPointListener listener2 = new ExtensionPointListener<T>(this, this){
            final /* synthetic */ ProtocolExtListenerManagerBase $receiver$inlined;
            final /* synthetic */ ProtocolExtListenerManagerBase $receiver$inlined$1;
            {
                this.$receiver$inlined = protocolExtListenerManagerBase;
                this.$receiver$inlined$1 = protocolExtListenerManagerBase2;
            }

            /*
             * WARNING - void declaration
             */
            public void extensionAdded(T extension, PluginDescriptor pluginDescriptor) {
                void p1;
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                BaseExtListenerDescriptor p0 = (BaseExtListenerDescriptor)extension;
                boolean bl = false;
                ProtocolExtListenerManagerBase.access$onExtensionAdded(this.$receiver$inlined, p0, (PluginDescriptor)p1);
            }

            /*
             * WARNING - void declaration
             */
            public void extensionRemoved(T extension, PluginDescriptor pluginDescriptor) {
                void p1;
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                BaseExtListenerDescriptor p0 = (BaseExtListenerDescriptor)extension;
                boolean bl = false;
                ProtocolExtListenerManagerBase.access$onExtensionRemoved(this.$receiver$inlined$1, p0, (PluginDescriptor)p1);
            }
        };
        extensionPoint.addExtensionPointListener(listener2, true, disposable);
    }

    private final <T extends BaseExtListenerDescriptor> void onExtensionAdded(T extension, PluginDescriptor descriptor) {
        if (!extension.isValid()) {
            logger.error("extension is broken: " + extension);
            return;
        }
        if (!Intrinsics.areEqual((Object)extension.getEndpoint(), (Object)this.endpoint)) {
            return;
        }
        ProtocolExtListenerAdapter adapter = new ProtocolExtListenerAdapter(extension, descriptor);
        this.adapters.putValue((Object)adapter.getLocation(), (Object)adapter);
    }

    private final void onExtensionRemoved(BaseExtListenerDescriptor extension, PluginDescriptor pluginDescriptor) {
        if (!Intrinsics.areEqual((Object)extension.getEndpoint(), (Object)this.endpoint)) {
            return;
        }
        ProtocolExtListenerAdapter adapter = new ProtocolExtListenerAdapter(extension, pluginDescriptor);
        this.adapters.remove((Object)adapter.getLocation(), (Object)adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(@NotNull Protocol protocol, @Nullable ClientProjectSession projectSession, @NotNull ExtCreationInfo info, boolean isLocal) {
        RdBindableBase parent;
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String location = ProtocolExtListenerManagerBase.Companion.toLocation(info.getRName());
        Collection collection = this.adapters.get((Object)location);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ifEmpty(...)");
        Collection listeners = collection2;
        RdId rdId = info.getRdId-vX8-7Ic();
        if (rdId != null) {
            long it = rdId.unbox-impl();
            boolean bl = false;
            v2 = ProtocolExtListenerManagerBase.Companion.findParent-v_l8LFs(protocol, it);
        } else {
            v2 = parent = null;
        }
        if (info.getRdId-vX8-7Ic() != null && parent == null) {
            if (this.isDisposed(projectSession)) {
                return;
            }
            logger.error("Failed to get parent for location \"" + info.getRName() + "\"");
            return;
        }
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            block21: {
                Class<RdExtBase> extClass;
                Lifetime backgroundLifetime = def$iv.getLifetime();
                boolean bl = false;
                IRdDispatcherKt.getAsRdDispatcher(protocol.getScheduler()).allowBackgroundThreadAndSuppressPumping(backgroundLifetime);
                try {
                    boolean bl2;
                    block20: {
                        extClass = ((ProtocolExtListenerAdapterBase)CollectionsKt.first((Iterable)listeners)).getExtClass();
                        Iterable $this$all$iv = listeners;
                        boolean $i$f$all = false;
                        if (((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                ProtocolExtListenerAdapterBase it = (ProtocolExtListenerAdapterBase)element$iv;
                                boolean bl3 = false;
                                if (Intrinsics.areEqual(it.getExtClass(), extClass)) continue;
                                bl2 = false;
                                break block20;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        boolean $i$a$-check-ProtocolExtListenerManagerBase$handleMessage$1$32 = false;
                        String $i$a$-check-ProtocolExtListenerManagerBase$handleMessage$1$32 = "All ext classes must be the same, found: [" + CollectionsKt.joinToString$default((Iterable)listeners, null, null, null, (int)0, null, ProtocolExtListenerManagerBase::handleMessage$lambda$2$1$0, (int)31, null) + "]";
                        throw new IllegalStateException($i$a$-check-ProtocolExtListenerManagerBase$handleMessage$1$32.toString());
                    }
                    extClass = this.createExtInstance((IProtocol)protocol, extClass, info.getRName(), parent, info.getHash());
                }
                catch (Exception e) {
                    logger.error("Failed to create extension instance for location \"" + location + "\"", (Throwable)e);
                    break block21;
                }
                Class<RdExtBase> clazz = extClass;
                RdExtBase boundExt = (RdExtBase)clazz.component1();
                boolean isNew = (Boolean)clazz.component2();
                if (this.isExtListeningAllowed(boundExt) && isLocal) {
                    logger.assertTrue(!isNew);
                    Iterable $this$forEach$iv = listeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProtocolExtListenerAdapterBase it = (ProtocolExtListenerAdapterBase)element$iv;
                        boolean bl4 = false;
                        try {
                            Lifetime bindLifetime;
                            ProtocolExtListener<RdBindableBase, RdExtBase> handler2 = it.getHandlerInstance();
                            if (boundExt.getBindLifetime() == null) {
                                throw new IllegalStateException("Bind lifetime is not initialized yet for extension " + it.getExtClass());
                            }
                            Unit cfr_ignored_0 = (Unit)bindLifetime.executeIfAlive(() -> ProtocolExtListenerManagerBase.handleMessage$lambda$2$2$0(handler2, projectSession, bindLifetime, parent, boundExt, this));
                        }
                        catch (Exception e) {
                            if (e instanceof CancellationException) {
                                if (!this.isDisposed(projectSession)) continue;
                                logger.error("Failed to create extension instance for location \"" + location + "\"", (Throwable)new Exception("Unexpectedly cancelled", e));
                                continue;
                            }
                            logger.error("Failed to create protocol listener for location \"" + location + "\"", (Throwable)e);
                        }
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    public boolean isExtListeningAllowed(@NotNull RdExtBase boundExt) {
        Intrinsics.checkNotNullParameter((Object)boundExt, (String)"boundExt");
        return true;
    }

    private final boolean isDisposed(ClientProjectSession projectSession) {
        if (projectSession != null && (projectSession.isDisposed() || projectSession.getProject().isDisposed() || RLifetimeKt.isNotAlive((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)projectSession.getProject()))))) {
            return true;
        }
        if (this.appSession.isDisposed()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        return application.isDisposed() || RLifetimeKt.isNotAlive((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)application)));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<RdExtBase, Boolean> createExtInstance(IProtocol protocol, Class<RdExtBase> extClass, RName rName, RdBindableBase parent, long hash) {
        RdExtBase ext;
        RdExtBase newInstance = null;
        if (parent != null) {
            void this_$iv;
            RdExtBase rdExtBase = extClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)rdExtBase, (String)"newInstance(...)");
            newInstance = rdExtBase;
            RdBindableBase rdBindableBase = parent;
            String string = rName.getLocalName();
            Function0 create$iv = () -> ProtocolExtListenerManagerBase.createExtInstance$lambda$0(newInstance);
            boolean $i$f$getOrCreateExtension = false;
            v1 = (RdExtBase)this_$iv.getOrCreateExtension((String)name$iv, Reflection.getOrCreateKotlinClass(RdExtBase.class), create$iv);
        } else {
            name$iv = new Class[]{Lifetime.class, IProtocol.class};
            Method createModelMethod = extClass.getMethod("internalCreateModel", name$iv);
            Object[] objectArray = new Object[]{protocol.getLifetime(), protocol};
            Object object = createModelMethod.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.base.RdExtBase");
            newInstance = (RdExtBase)object;
            v1 = ext = protocol.getOrCreateExtension(JvmClassMappingKt.getKotlinClass(extClass), () -> ProtocolExtListenerManagerBase.createExtInstance$lambda$1(newInstance));
        }
        if (!(ext.getSerializationHash() == hash)) {
            boolean bl = false;
            String string = "Hash mismatch: expected hash " + hash + ", actual ext hash was " + ext.getSerializationHash();
            throw new IllegalStateException(string.toString());
        }
        return TuplesKt.to((Object)ext, (Object)(newInstance == ext ? 1 : 0));
    }

    private final String tryGetSolutionId(RName $this$tryGetSolutionId) {
        for (RName name = $this$tryGetSolutionId; name != null; name = name.getParent()) {
            String solutionId = this.getAsSolutionId(name);
            if (solutionId == null) continue;
            return solutionId;
        }
        return null;
    }

    private final String getAsSolutionId(RName $this$asSolutionId) {
        RName rName = $this$asSolutionId.getParent();
        if (rName == null) {
            return null;
        }
        RName solutions = rName;
        RName rName2 = solutions.getParent();
        if (rName2 == null) {
            return null;
        }
        RName solutionModel = rName2;
        RName rName3 = solutionModel.getParent();
        if (rName3 == null) {
            return null;
        }
        RName root = rName3;
        if (!Intrinsics.areEqual((Object)root.getParent(), (Object)RName.Companion.getEmpty())) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)solutions.getLocalName(), (Object)"solutions")) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)solutionModel.getLocalName(), (Object)SolutionModel.class.getSimpleName())) {
            return null;
        }
        return $this$asSolutionId.getLocalName();
    }

    private static final Unit adviseOnProtocol$lambda$0$1(ProtocolExtListenerManagerBase this$0, ClientProjectSession $localProjectSession, ExtCreationInfo $info, boolean $isLocal) {
        this$0.handleMessage(this$0.protocol, $localProjectSession, $info, $isLocal);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit adviseOnProtocol$lambda$0(ProtocolExtListenerManagerBase this$0, IRdDispatcher $scheduler, ExtCreationInfoEx infoEx) {
        ClientProjectSession localProjectSession;
        ClientProjectSession clientProjectSession;
        Intrinsics.checkNotNullParameter((Object)infoEx, (String)"infoEx");
        ExtCreationInfo info = infoEx.component1();
        boolean isLocal = infoEx.component2();
        String solutionId = this$0.tryGetSolutionId(info.getRName());
        if (solutionId != null) {
            Object object = this$0.lock;
            synchronized (object) {
                ClientProjectSession projectSession;
                block11: {
                    Object object2;
                    void $this$getOrPut$iv;
                    block12: {
                        boolean bl = false;
                        projectSession = this$0.projectSessions.get(solutionId);
                        if (projectSession != null) break block11;
                        Boolean closedLongTimeAgo = this$0.recentlyClosedProjectSessions.get(solutionId);
                        if (closedLongTimeAgo == null) break block12;
                        if (closedLongTimeAgo.booleanValue()) {
                            logger.error("Solution: " + solutionId + " has long been closed, but ext: " + infoEx + " is still trying to be created");
                        }
                        Unit unit = Unit.INSTANCE;
                        return unit;
                    }
                    this$0.beforeAccumulateExcCreationSignal(info, isLocal);
                    Map<String, List<ExtCreationInfoEx>> map = this$0.accumulatedMessages;
                    String key$iv = solutionId;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ((List)object2).add(infoEx);
                    if (isLocal) break block11;
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                ClientProjectSession clientProjectSession2 = projectSession;
                // MONITOREXIT @DISABLED, blocks:[2, 3, 10] lbl44 : MonitorExitStatement: MONITOREXIT : var7_6
                clientProjectSession = clientProjectSession2;
            }
        }
        clientProjectSession = localProjectSession = null;
        if (isLocal) {
            this$0.handleMessage(this$0.protocol, localProjectSession, info, isLocal);
        } else {
            $scheduler.getBackgroundScheduler().invokeOrQueue(() -> ProtocolExtListenerManagerBase.adviseOnProtocol$lambda$0$1(this$0, localProjectSession, info, isLocal));
        }
        return Unit.INSTANCE;
    }

    private static final String adviseOnSolutionsMap$lambda$0$0(ProtocolExtListenerManagerBase this$0, Map.Entry $solution) {
        String string = this$0.tryGetSolutionId(((Solution)$solution.getValue()).getLocation());
        if (string == null) {
            throw new IllegalStateException(("Failed to get solution location from solution: " + $solution).toString());
        }
        return string;
    }

    private static final Unit adviseOnSolutionsMap$lambda$0$1(ProtocolExtListenerManagerBase this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stopDeliveringMessages(it);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSolutionsMap$lambda$0(ProtocolExtListenerManagerBase this$0, Lifetime solutionLifetime, Map.Entry solution) {
        Intrinsics.checkNotNullParameter((Object)solutionLifetime, (String)"solutionLifetime");
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        solutionLifetime.bracketIfAliveEx(() -> ProtocolExtListenerManagerBase.adviseOnSolutionsMap$lambda$0$0(this$0, solution), arg_0 -> ProtocolExtListenerManagerBase.adviseOnSolutionsMap$lambda$0$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final CharSequence handleMessage$lambda$2$1$0(ProtocolExtListenerAdapterBase it) {
        String string = it.getExtClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    private static final Unit handleMessage$lambda$2$2$0(ProtocolExtListener $handler, ClientProjectSession $projectSession, Lifetime $bindLifetime, RdBindableBase $parent, RdExtBase $boundExt, ProtocolExtListenerManagerBase this$0) {
        if ($handler instanceof ProjectExtListener && $projectSession != null) {
            if ($projectSession.isDisposed()) {
                return Unit.INSTANCE;
            }
            ((ProjectExtListener)$handler).extensionCreated(RLifetimeKt.intersect((Lifetime)$bindLifetime, (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$projectSession))), $projectSession, $parent, $boundExt);
        } else if ($handler instanceof AppExtListener) {
            ((AppExtListener)$handler).extensionCreated($bindLifetime, this$0.appSession, $parent, $boundExt);
        }
        return Unit.INSTANCE;
    }

    private static final RdExtBase createExtInstance$lambda$0(RdExtBase $newInstance) {
        return $newInstance;
    }

    private static final RdExtBase createExtInstance$lambda$1(RdExtBase $newInstance) {
        return $newInstance;
    }

    public static final /* synthetic */ Object access$getLock$p(ProtocolExtListenerManagerBase $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Map access$getRecentlyClosedProjectSessions$p(ProtocolExtListenerManagerBase $this) {
        return $this.recentlyClosedProjectSessions;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$onExtensionAdded(ProtocolExtListenerManagerBase $this, BaseExtListenerDescriptor extension, PluginDescriptor descriptor) {
        $this.onExtensionAdded(extension, descriptor);
    }

    public static final /* synthetic */ void access$onExtensionRemoved(ProtocolExtListenerManagerBase $this, BaseExtListenerDescriptor extension, PluginDescriptor pluginDescriptor) {
        $this.onExtensionRemoved(extension, pluginDescriptor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolExtListenerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolExtListenerManagerBase.logger = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\u0014\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001e\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00140\u0013*\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u00020\b*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00140\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "toLocation", "", "Lcom/jetbrains/rd/util/string/RName;", "removePrefix", "prefix", "findParent", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "Lcom/jetbrains/rd/framework/Protocol;", "rdId", "Lcom/jetbrains/rd/framework/RdId;", "findParent-v_l8LFs", "(Lcom/jetbrains/rd/framework/Protocol;J)Lcom/jetbrains/rd/framework/base/RdBindableBase;", "toReversedChain", "", "Lkotlin/Pair;", "reversedChainToRName", "", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nProtocolExtListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String toLocation(RName $this$toLocation) {
            List<Pair<String, String>> chain = this.toReversedChain($this$toLocation);
            chain.removeLast();
            chain.set(chain.size() - 1, (Pair<String, String>)TuplesKt.to((Object)"", (Object)((Pair)CollectionsKt.last(chain)).getSecond()));
            chain.removeIf(arg_0 -> Companion.toLocation$lambda$1(Companion::toLocation$lambda$0, arg_0));
            chain.removeIf(arg_0 -> Companion.toLocation$lambda$3(Companion::toLocation$lambda$2, arg_0));
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable(chain), (CharSequence)"", null, null, (int)0, null, Companion::toLocation$lambda$4, (int)30, null);
        }

        private final RName removePrefix(RName $this$removePrefix, RName prefix2) {
            List<Pair<String, String>> nameChain = this.toReversedChain($this$removePrefix);
            List<Pair<String, String>> prefixChain = this.toReversedChain(prefix2);
            nameChain.removeLast();
            prefixChain.removeLast();
            while (!((Collection)nameChain).isEmpty() && !((Collection)prefixChain).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last(prefixChain), (Object)CollectionsKt.last(nameChain))) {
                nameChain.removeLast();
                prefixChain.removeLast();
            }
            if (!prefixChain.isEmpty()) {
                boolean bl = false;
                String string = prefix2 + " is not a prefix of " + $this$removePrefix;
                throw new IllegalStateException(string.toString());
            }
            return this.reversedChainToRName(nameChain);
        }

        private final RdBindableBase findParent-v_l8LFs(Protocol $this$findParent_u2dv_l8LFs, long rdId) {
            IRdDynamic iRdDynamic = $this$findParent_u2dv_l8LFs.getRdEntitiesRegistrar().tryGetDynamic-s1GeQ58(rdId);
            RdBindableBase rdBindableBase = iRdDynamic instanceof RdBindableBase ? (RdBindableBase)iRdDynamic : null;
            if (rdBindableBase == null) {
                return null;
            }
            return rdBindableBase;
        }

        private final List<Pair<String, String>> toReversedChain(RName $this$toReversedChain) {
            List chain = new ArrayList();
            for (RName current = $this$toReversedChain; current != null && !Intrinsics.areEqual((Object)current, (Object)RName.Companion.getEmpty()); current = current.getParent()) {
                chain.add(TuplesKt.to((Object)current.getSeparator(), (Object)current.getLocalName()));
            }
            return chain;
        }

        private final RName reversedChainToRName(List<Pair<String, String>> $this$reversedChainToRName) {
            RName current = RName.Companion.getEmpty();
            for (Pair pair : CollectionsKt.asReversed($this$reversedChainToRName)) {
                String separator = (String)pair.component1();
                String localName = (String)pair.component2();
                current = current.sub(localName, separator);
            }
            return current;
        }

        private static final boolean toLocation$lambda$0(Pair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
            String name = (String)pair.component2();
            return StringsKt.startsWith$default((String)name, (String)"[", (boolean)false, (int)2, null);
        }

        private static final boolean toLocation$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean toLocation$lambda$2(Pair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
            String name = (String)pair.component2();
            return Intrinsics.areEqual((Object)name, (Object)"$");
        }

        private static final boolean toLocation$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final CharSequence toLocation$lambda$4(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "" + it.getFirst() + it.getSecond();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase$SolutionModelListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "manager", "Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase;", "<init>", "(Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase;)V", "getManager", "()Lcom/jetbrains/rd/protocol/ProtocolExtListenerManagerBase;", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.platform"})
    private static final class SolutionModelListener
    implements RootExtListener<SolutionModel> {
        @NotNull
        private final ProtocolExtListenerManagerBase manager;

        public SolutionModelListener(@NotNull ProtocolExtListenerManagerBase manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            this.manager = manager;
        }

        @NotNull
        public final ProtocolExtListenerManagerBase getManager() {
            return this.manager;
        }

        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull SolutionModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.manager.adviseOnSolutionsMap(lifetime, model);
        }
    }
}

