/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events;

import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.ProvenanceEvent;
import com.intellij.code.provenance.core.events.ProvenanceEventsKt;
import com.intellij.code.provenance.core.events.storage.ProvenanceStorage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/code/provenance/core/events/ProvenanceEvents;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "processChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/code/provenance/core/events/ProvenanceEvent;", "getProcessChannel", "()Lkotlinx/coroutines/channels/Channel;", "deferred", "Lcom/intellij/code/provenance/core/events/ProvenanceEvent$Mergeable;", "add", "", "event", "flushDeferred", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "saveDeferred", "storeEvent", "doStoreEntry", "entry", "Lcom/intellij/code/provenance/core/ProvenanceEntry;", "Companion", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nProvenanceEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceEvents.kt\ncom/intellij/code/provenance/core/events/ProvenanceEvents\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n426#2,11:188\n1915#3,2:199\n13#4:201\n*S KotlinDebug\n*F\n+ 1 ProvenanceEvents.kt\ncom/intellij/code/provenance/core/events/ProvenanceEvents\n*L\n47#1:188,11\n93#1:199,2\n22#1:201\n*E\n"})
public final class ProvenanceEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Channel<ProvenanceEvent> processChannel;
    @Nullable
    private ProvenanceEvent.Mergeable deferred;
    @NotNull
    private static final Logger log;

    public ProvenanceEvents(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.processChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProvenanceEvents this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.this$0.getProcessChannel())).collect(new FlowCollector(){

                            public final Object emit(ProvenanceEvent it, Continuation<? super Unit> $completion) {
                                try {
                                    this$0.process(it);
                                }
                                catch (Throwable e) {
                                    log.error(e);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final Channel<ProvenanceEvent> getProcessChannel() {
        return this.processChannel;
    }

    public final void add(@NotNull ProvenanceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processChannel.trySend-JP2dKIU((Object)event);
    }

    @Nullable
    public final Object flushDeferred(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Object result = this.getProcessChannel().trySend-JP2dKIU((Object)new ProvenanceEvent.Flush((CancellableContinuation<? super Unit>)continuation));
        if (!ChannelResult.isSuccess-impl((Object)result)) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void process(ProvenanceEvent event) {
        ProvenanceEvent provenanceEvent = event;
        if (provenanceEvent instanceof ProvenanceEvent.Flush) {
            this.saveDeferred();
            ((Continuation)((ProvenanceEvent.Flush)event).getContinuation()).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
        } else if (provenanceEvent instanceof ProvenanceEvent.Deferred || provenanceEvent instanceof ProvenanceEvent.Atomic) {
            this.saveDeferred();
            this.storeEvent(event);
        } else if (provenanceEvent instanceof ProvenanceEvent.Mergeable) {
            ProvenanceEvent.Mergeable deferredEvent = this.deferred;
            boolean bl = false;
            if (deferredEvent == null) {
                this.deferred = (ProvenanceEvent.Mergeable)event;
                return;
            }
            if (!deferredEvent.tryMerge((ProvenanceEvent.Mergeable)event)) {
                this.saveDeferred();
                this.deferred = (ProvenanceEvent.Mergeable)event;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void saveDeferred() {
        ProvenanceEvent.Mergeable mergeable = this.deferred;
        if (mergeable != null) {
            ProvenanceEvent.Mergeable it = mergeable;
            boolean bl = false;
            this.storeEvent(it);
        }
        this.deferred = null;
    }

    private final void storeEvent(ProvenanceEvent event) {
        ProvenanceEntry entry = event.getEntry();
        if (entry instanceof ProvenanceEntry.DocumentChange && ProvenanceEventsKt.requiresSplitting$default((ProvenanceEntry.DocumentChange)entry, 0, 2, null)) {
            Iterable $this$forEach$iv = ProvenanceEventsKt.splitChanges$default((ProvenanceEntry.DocumentChange)entry, 0, 2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProvenanceEntry p0 = (ProvenanceEntry)element$iv;
                boolean bl = false;
                this.doStoreEntry(p0);
            }
        } else {
            this.doStoreEntry(entry);
        }
    }

    private final void doStoreEntry(ProvenanceEntry entry) {
        ProvenanceStorage.Companion.getInstance(this.project).add(entry);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProvenanceEvents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/events/ProvenanceEvents$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/code/provenance/core/events/ProvenanceEvents;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core"})
    @SourceDebugExtension(value={"SMAP\nProvenanceEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceEvents.kt\ncom/intellij/code/provenance/core/events/ProvenanceEvents$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,187:1\n30#2,2:188\n*S KotlinDebug\n*F\n+ 1 ProvenanceEvents.kt\ncom/intellij/code/provenance/core/events/ProvenanceEvents$Companion\n*L\n23#1:188,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceEvents getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProvenanceEvents> serviceClass$iv = ProvenanceEvents.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ProvenanceEvents)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

