/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.listeners.ProvenanceListenersKt;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceTypedActionListener;", "Lcom/intellij/codeInsight/template/impl/editorActions/TypedActionHandlerBase;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;)V", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "charTyped", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.code.provenance.core"})
public final class ProvenanceTypedActionListener
extends TypedActionHandlerBase {
    public ProvenanceTypedActionListener(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        PsiFile file;
        Project project;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            TypedActionHandler typedActionHandler = this.myOriginalHandler;
            if (typedActionHandler != null) {
                typedActionHandler.execute(editor, charTyped, dataContext);
            }
            return;
        }
        Project project2 = project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = file = project2 == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (file == null) {
            TypedActionHandler typedActionHandler = this.myOriginalHandler;
            if (typedActionHandler != null) {
                typedActionHandler.execute(editor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        try {
            editor.putUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY(), (Object)DocumentChangesKind.TYPING);
            TypedActionHandler typedActionHandler = this.myOriginalHandler;
            if (typedActionHandler != null) {
                typedActionHandler.execute(editor, charTyped, dataContext);
            }
        }
        finally {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor), ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
        }
    }
}

