/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.entries;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.storage.ProvenanceEventExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 $2\u00020\u0001:\u0001$B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013JR\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\"H\u00d6\u0081\u0004J\n\u0010#\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/code/provenance/core/events/storage/entries/ProvenanceMetadataEntryDTO;", "", "timestamp", "", "type", "", "filePath", "kind", "oldContentHash", "newContentHash", "<init>", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)V", "getTimestamp", "()J", "getType", "()Ljava/lang/String;", "getFilePath", "getKind", "getOldContentHash", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getNewContentHash", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lcom/intellij/code/provenance/core/events/storage/entries/ProvenanceMetadataEntryDTO;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.code.provenance.core"})
public final class ProvenanceMetadataEntryDTO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timestamp;
    @NotNull
    private final String type;
    @Nullable
    private final String filePath;
    @Nullable
    private final String kind;
    @Nullable
    private final Long oldContentHash;
    @Nullable
    private final Long newContentHash;

    public ProvenanceMetadataEntryDTO(long timestamp, @NotNull String type, @Nullable String filePath, @Nullable String kind, @Nullable Long oldContentHash, @Nullable Long newContentHash) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.timestamp = timestamp;
        this.type = type;
        this.filePath = filePath;
        this.kind = kind;
        this.oldContentHash = oldContentHash;
        this.newContentHash = newContentHash;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @Nullable
    public final String getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final String getKind() {
        return this.kind;
    }

    @Nullable
    public final Long getOldContentHash() {
        return this.oldContentHash;
    }

    @Nullable
    public final Long getNewContentHash() {
        return this.newContentHash;
    }

    public final long component1() {
        return this.timestamp;
    }

    @NotNull
    public final String component2() {
        return this.type;
    }

    @Nullable
    public final String component3() {
        return this.filePath;
    }

    @Nullable
    public final String component4() {
        return this.kind;
    }

    @Nullable
    public final Long component5() {
        return this.oldContentHash;
    }

    @Nullable
    public final Long component6() {
        return this.newContentHash;
    }

    @NotNull
    public final ProvenanceMetadataEntryDTO copy(long timestamp, @NotNull String type, @Nullable String filePath, @Nullable String kind, @Nullable Long oldContentHash, @Nullable Long newContentHash) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new ProvenanceMetadataEntryDTO(timestamp, type, filePath, kind, oldContentHash, newContentHash);
    }

    public static /* synthetic */ ProvenanceMetadataEntryDTO copy$default(ProvenanceMetadataEntryDTO provenanceMetadataEntryDTO, long l, String string, String string2, String string3, Long l2, Long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l = provenanceMetadataEntryDTO.timestamp;
        }
        if ((n & 2) != 0) {
            string = provenanceMetadataEntryDTO.type;
        }
        if ((n & 4) != 0) {
            string2 = provenanceMetadataEntryDTO.filePath;
        }
        if ((n & 8) != 0) {
            string3 = provenanceMetadataEntryDTO.kind;
        }
        if ((n & 0x10) != 0) {
            l2 = provenanceMetadataEntryDTO.oldContentHash;
        }
        if ((n & 0x20) != 0) {
            l3 = provenanceMetadataEntryDTO.newContentHash;
        }
        return provenanceMetadataEntryDTO.copy(l, string, string2, string3, l2, l3);
    }

    @NotNull
    public String toString() {
        return "ProvenanceMetadataEntryDTO(timestamp=" + this.timestamp + ", type=" + this.type + ", filePath=" + this.filePath + ", kind=" + this.kind + ", oldContentHash=" + this.oldContentHash + ", newContentHash=" + this.newContentHash + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.timestamp);
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.oldContentHash == null ? 0 : ((Object)this.oldContentHash).hashCode());
        result = result * 31 + (this.newContentHash == null ? 0 : ((Object)this.newContentHash).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProvenanceMetadataEntryDTO)) {
            return false;
        }
        ProvenanceMetadataEntryDTO provenanceMetadataEntryDTO = (ProvenanceMetadataEntryDTO)other;
        if (this.timestamp != provenanceMetadataEntryDTO.timestamp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)provenanceMetadataEntryDTO.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)provenanceMetadataEntryDTO.filePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kind, (Object)provenanceMetadataEntryDTO.kind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.oldContentHash, (Object)provenanceMetadataEntryDTO.oldContentHash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.newContentHash, (Object)provenanceMetadataEntryDTO.newContentHash);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\b\u001a\u00020\u0007*\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/code/provenance/core/events/storage/entries/ProvenanceMetadataEntryDTO$Companion;", "", "<init>", "()V", "fromProvenanceEntry", "Lcom/intellij/code/provenance/core/events/storage/entries/ProvenanceMetadataEntryDTO;", "entry", "Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "toProvenanceEntry", "intellij.code.provenance.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceMetadataEntryDTO fromProvenanceEntry(@NotNull ProvenanceEntry.MetadataEntryOfDocumentChange entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            long l = entry.getTimestamp();
            String string = entry.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return new ProvenanceMetadataEntryDTO(l, string, ProvenanceEventExtensionsKt.getDocumentPath(entry), entry.getKind().name(), entry.getOldContentHash(), entry.getNewContentHash());
        }

        @NotNull
        public final ProvenanceEntry.MetadataEntryOfDocumentChange toProvenanceEntry(@NotNull ProvenanceMetadataEntryDTO $this$toProvenanceEntry) {
            Intrinsics.checkNotNullParameter((Object)$this$toProvenanceEntry, (String)"<this>");
            String string = $this$toProvenanceEntry.getFilePath();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            DocumentChangesKind documentChangesKind = DocumentChangesKind.Companion.fromString($this$toProvenanceEntry.getKind());
            long l = $this$toProvenanceEntry.getTimestamp();
            Long l2 = $this$toProvenanceEntry.getOldContentHash();
            Long l3 = $this$toProvenanceEntry.getNewContentHash();
            return new ProvenanceEntry.MetadataEntryOfDocumentChange(string2, l, documentChangesKind, l2, l3, 0L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

