/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSGenerateMemberChooser;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionConstructorFunction;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSGenerateHandler
implements LanguageCodeInsightActionHandler {
    protected boolean mySkipMemberChooserDialog;
    private final ElementsToSelect mySelectAllElements;

    public void setSkipMemberChooserDialog(boolean skipMemberChooserDialog) {
        this.mySkipMemberChooserDialog = skipMemberChooserDialog;
    }

    public BaseJSGenerateHandler() {
        this.mySkipMemberChooserDialog = false;
        this.mySelectAllElements = ElementsToSelect.None;
    }

    public BaseJSGenerateHandler(boolean skipMemberChooserDialog) {
        this.mySkipMemberChooserDialog = skipMemberChooserDialog;
        this.mySelectAllElements = ElementsToSelect.None;
    }

    public BaseJSGenerateHandler(boolean skipMemberChooserDialog, ElementsToSelect selectAllElements) {
        this.mySkipMemberChooserDialog = skipMemberChooserDialog;
        this.mySelectAllElements = selectAllElements;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(2);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        PsiElement jsClass = BaseJSGenerateHandler.findClassOrObjectLiteral(psiFile, editor, null);
        if (jsClass == null) {
            return;
        }
        this.invokeOnElement(editor, jsClass, psiFile);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invokeOnElement(@NotNull Editor editor, @NotNull PsiElement jsClass, @NotNull PsiFile file) {
        List<Object> selectedElements;
        block17: {
            if (editor == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(3);
            }
            if (jsClass == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(4);
            }
            if (file == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(5);
            }
            assert (jsClass instanceof JSClass || jsClass instanceof JSObjectLiteralExpression);
            if (this.collectCandidatesAndShowDialog()) {
                ArrayList<JSChooserElementNode> candidates = new ArrayList<JSChooserElementNode>();
                this.collectCandidates(jsClass, candidates);
                if (candidates.isEmpty()) {
                    if (this.canHaveEmptySelectedElements()) {
                        selectedElements = Collections.emptyList();
                        break block17;
                    } else {
                        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            HintManager.getInstance().showErrorHint(editor, this.getNoCandidatesMessage());
                        }
                        return;
                    }
                }
                boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
                if (unitTestMode) {
                    Iterator i = candidates.iterator();
                    while (i.hasNext()) {
                        PsiElement psiElement;
                        JSChooserElementNode next = (JSChooserElementNode)i.next();
                        if (!(next instanceof JSNamedElementNode) || !((psiElement = ((JSNamedElementNode)next.getParentNodeDelegate()).getPsiElement()) instanceof JSClass) || !"Object".equals(((JSClass)psiElement).getQualifiedName())) continue;
                        i.remove();
                    }
                }
                if (this.mySkipMemberChooserDialog || unitTestMode) {
                    selectedElements = this.getCandidatesToSelect(candidates, true);
                } else {
                    MemberChooser<JSChooserElementNode> chooser = this.createMemberChooserDialog(jsClass.getProject(), jsClass, candidates, this.canHaveEmptySelectedElements(), true, this.getTitle());
                    chooser.show();
                    if (chooser.getExitCode() != 0) {
                        return;
                    }
                    List<Object> selected = chooser.getSelectedElements();
                    selectedElements = selected == null ? Collections.emptyList() : selected;
                }
            } else {
                selectedElements = Collections.emptyList();
            }
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        BaseCreateMembersFix createMethodsFix = this.createFix(jsClass);
        this.doInvoke(jsClass.getProject(), editor, file, selectedElements, (BaseCreateMembersFix<JSElement>)createMethodsFix);
        if (jsClass.isValid()) {
            JSimportUtilKt.applyUnambiguousImportsAsync((Project)jsClass.getProject(), (TextRange)jsClass.getTextRange(), (Document)editor.getDocument(), (Editor)editor);
        }
    }

    protected void doInvoke(final Project project, final Editor editor, final PsiFile file, final Collection<JSChooserElementNode> selectedElements, final BaseCreateMembersFix<JSElement> createMethodsFix) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (JSChooserElementNode el : selectedElements) {
                    createMethodsFix.addElementToProcess((JSElement)el.getPsiElement());
                }
                createMethodsFix.beforeInvoke(project, editor, file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            createMethodsFix.invoke(project, editor, file);
                        }
                        catch (IncorrectOperationException ex) {
                            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        };
        if (!CommandProcessor.getInstance().isCommandInProgress()) {
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getTitle(), null);
        } else {
            runnable.run();
        }
    }

    protected MemberChooser<JSChooserElementNode> createMemberChooserDialog(Project project, PsiElement jsClass, Collection<JSChooserElementNode> candidates, boolean allowEmptySelection, boolean allowMultipleSelection, @NlsContexts.DialogTitle String title) {
        JSGenerateMemberChooser chooser = new JSGenerateMemberChooser(candidates, allowEmptySelection, allowMultipleSelection, project, this.getOptionsComponent(jsClass, candidates));
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        Collection<JSChooserElementNode> candidatesToSelect = this.getCandidatesToSelect(candidates, false);
        if (!candidatesToSelect.isEmpty()) {
            chooser.selectElements((ClassMember[])ContainerUtil.toArray(candidatesToSelect, JSChooserElementNode[]::new));
        }
        return chooser;
    }

    @NotNull
    private Collection<JSChooserElementNode> getCandidatesToSelect(@NotNull Collection<JSChooserElementNode> candidates, boolean forceSelect) {
        if (candidates == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(6);
        }
        Collection<Object> candidatesToSelect = ContainerUtil.emptyList();
        if (this.mySelectAllElements == ElementsToSelect.All || forceSelect && this.mySelectAllElements == ElementsToSelect.None) {
            candidatesToSelect = candidates;
        } else if (this.mySelectAllElements == ElementsToSelect.OnlyRequired) {
            candidatesToSelect = ContainerUtil.filter(candidates, c -> {
                PsiElement element = c.getPsiElement();
                return !(element instanceof JSOptionalOwner) || !((JSOptionalOwner)element).isOptional();
            });
        }
        Collection<Object> collection = candidatesToSelect;
        if (collection == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    protected JComponent getOptionsComponent(PsiElement jsClass, Collection<JSChooserElementNode> candidates) {
        return null;
    }

    protected boolean canHaveEmptySelectedElements() {
        return false;
    }

    @Nullable
    public static PsiElement findClassOrObjectLiteral(@NotNull PsiFile file, @NotNull Editor editor, @Nullable Condition<? super PsiElement> dialectCheck) {
        JSObjectLiteralExpression literalExpression;
        if (file == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(9);
        }
        if (file instanceof XmlFile && FlexSupportLoader.isFlexMxmFile((PsiFile)file)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)file));
        }
        PsiElement at = BaseJSGenerateHandler.getMeaningfulElementAtCaret(file, editor);
        if (at == null || !at.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || dialectCheck != null && !dialectCheck.value((Object)at)) {
            return null;
        }
        Object clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)at, JSClass.class, (boolean)false);
        if (clazz == null) {
            PsiFile containingFile = at.getContainingFile();
            PsiElement element = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)containingFile);
            if (element instanceof JSClass) {
                clazz = (JSClass)element;
            }
        } else if (JSResolveUtil.isArtificialClassUsedForReferenceList((JSClass)clazz)) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)clazz);
            clazz = context != null && context.getContainingFile() instanceof XmlFile ? XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)context.getContainingFile())) : null;
        }
        if (clazz == null && (literalExpression = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)at, JSObjectLiteralExpression.class, (boolean)false)) != null) {
            return literalExpression;
        }
        return clazz;
    }

    @NlsContexts.DialogTitle
    @Nullable
    protected abstract String getTitle();

    @NlsContexts.HintText
    @NotNull
    protected String getNoCandidatesMessage() {
        String string = JavaScriptBundle.message((String)"no.candidates", (Object[])new Object[0]);
        if (string == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected abstract BaseCreateMembersFix createFix(PsiElement var1);

    protected boolean collectCandidatesAndShowDialog() {
        return true;
    }

    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
    }

    protected static boolean indexedPropertyAccessCheck(@NotNull JSNamedElementBase element, @NotNull PairProcessor<? super String, ? super String> secondPartConsumer) {
        if (element == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(11);
        }
        if (secondPartConsumer == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(12);
        }
        if (element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getExpression() instanceof JSIndexedPropertyAccessExpression) {
            String first;
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)((JSDefinitionExpression)element).getExpression()).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
                String innerText = StringUtil.unquoteString((String)indexExpression.getText());
                if (innerText.startsWith("_")) {
                    char quote = indexExpression.getText().charAt(0);
                    return secondPartConsumer.process((Object)("[" + indexExpression.getText() + "]"), (Object)("[" + quote + innerText.substring(1) + quote + "]"));
                }
                return true;
            }
            if (indexExpression instanceof JSBinaryExpression && JSTokenTypes.PLUS.equals(((JSBinaryExpression)indexExpression).getOperationSign()) && ((JSBinaryExpression)indexExpression).getLOperand() instanceof JSLiteralExpression && ((JSLiteralExpression)((JSBinaryExpression)indexExpression).getLOperand()).isQuotedLiteral() && "_".equals(first = StringUtil.unquoteString((String)((JSBinaryExpression)indexExpression).getLOperand().getText()))) {
                JSExpression rOperand = ((JSBinaryExpression)indexExpression).getROperand();
                rOperand = rOperand instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)rOperand).getInnerExpression() : rOperand;
                return secondPartConsumer.process((Object)("[" + indexExpression.getText() + "]"), (Object)("[" + rOperand.getText() + "]"));
            }
        }
        return true;
    }

    protected static void collectJSVariables(PsiElement clazz, Collection<? super JSChooserElementNode> candidates, final boolean skipThatHaveGetters, final boolean skipThatHaveSetters, final boolean skipStatics, final boolean skipConstructorParameters, final boolean skipSymbolProperties, final boolean skipConstantFields, final boolean skipAbstractFields) {
        final HashMap<String, JSPsiNamedElementBase> candidatesMap = new HashMap<String, JSPsiNamedElementBase>();
        final HashSet<String> accessors = new HashSet<String>();
        Processor duplicatesChecker = accessorName -> {
            if (accessors.contains(accessorName)) {
                return false;
            }
            JSPsiNamedElementBase element = (JSPsiNamedElementBase)candidatesMap.get(accessorName);
            return element == null || BaseJSGenerateHandler.indexedPropertyAccessCheck((JSNamedElementBase)element, (PairProcessor<? super String, ? super String>)((PairProcessor)(existing, future) -> !accessors.contains(existing.replace('\'', '\"')) && !accessors.contains(future.replace('\'', '\"'))));
        };
        final ArrayList constructorParameters = new ArrayList();
        final JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)clazz);
        ResolveProcessor processor = new ResolveProcessor(null){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                String name;
                JSAttributeList attributeList;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                JSPsiNamedElementBase namedElement = (JSPsiNamedElementBase)element;
                if (skipStatics && element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    return true;
                }
                if (!(element instanceof JSVariable)) {
                    if (element instanceof JSFunction) {
                        JSFunction function = (JSFunction)element;
                        if (skipThatHaveGetters && function.isGetProperty() || skipThatHaveSetters && function.isSetProperty()) {
                            accessors.add(StringUtil.notNullize((String)function.getName()).replace('\'', '\"'));
                        }
                        if (!skipConstructorParameters && function.isConstructor()) {
                            Collections.addAll(constructorParameters, function.getParameterVariables());
                        }
                    }
                    return true;
                }
                if (skipConstantFields && ((JSVariable)element).isConst()) {
                    return true;
                }
                if (skipAbstractFields && (attributeList = ((JSVariable)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    return true;
                }
                if (namedElement instanceof JSComputedPropertyNameOwner) {
                    JSExpression expr;
                    ES6ComputedName propName = ((JSComputedPropertyNameOwner)namedElement).getComputedPropertyName();
                    JSExpression jSExpression = expr = propName == null ? null : propName.getExpression();
                    if (!(expr == null || expr instanceof JSLiteralExpression || !skipSymbolProperties && JSPsiImplUtils.isSymbolRef((JSExpression)expr))) {
                        return true;
                    }
                }
                if ((name = namedElement.getName()) == null) {
                    return true;
                }
                String accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)name, (JSCodeStyleSettings)codeStyleSettings);
                candidatesMap.put(accessorName, namedElement);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateHandler$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setToProcessMembers(true);
        processor.setToProcessHierarchy(false);
        processor.setLocalResolve(true);
        clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), clazz, clazz);
        BaseJSGenerateHandler.appendUnnamedComputedProperties(clazz, skipThatHaveGetters, skipThatHaveSetters, accessors);
        if (!skipConstructorParameters && clazz instanceof JSClass) {
            JSFunction constructor = ((JSClass)clazz).getConstructor();
            if (constructor != null) {
                JSToClassConversionConstructorFunction function = new JSToClassConversionConstructorFunction(constructor, null);
                Collection<JSAssignmentExpression> definitions = function.getOnlyPropertyDefinitions();
                ContainerUtil.process(definitions, definition -> {
                    Object accessorName;
                    PsiElement resolve;
                    if (definition.getDefinitionExpression() == null) {
                        return true;
                    }
                    JSExpression initializer = definition.getDefinitionExpression().getInitializer();
                    if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) instanceof JSParameter) {
                        return true;
                    }
                    JSExpression expression = definition.getDefinitionExpression().getExpression();
                    if (expression instanceof JSReferenceExpression) {
                        String name = ((JSReferenceExpression)expression).getReferenceName();
                        accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)name, (JSCodeStyleSettings)codeStyleSettings);
                    } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                        String value;
                        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                        accessorName = null;
                        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
                            accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)value, (JSCodeStyleSettings)codeStyleSettings);
                        }
                        if (indexExpression instanceof JSBinaryExpression) {
                            String first;
                            JSExpression lOperand = ((JSBinaryExpression)indexExpression).getLOperand();
                            String string = first = lOperand == null ? "" : StringUtil.unquoteString((String)lOperand.getText());
                            if ("_".equals(first)) {
                                JSExpression rOperand = ((JSBinaryExpression)indexExpression).getROperand();
                                JSExpression jSExpression = rOperand = rOperand instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)rOperand).getInnerExpression() : rOperand;
                                if (rOperand != null) {
                                    accessorName = "[" + rOperand.getText() + "]";
                                }
                            }
                        }
                        if (accessorName == null) {
                            accessorName = "[" + indexExpression.getText() + "]";
                        }
                    } else {
                        return true;
                    }
                    if (duplicatesChecker.process(accessorName)) {
                        candidatesMap.put((String)accessorName, (JSPsiNamedElementBase)definition.getDefinitionExpression());
                    }
                    return true;
                });
            }
            for (JSPsiNamedElementBase parameter : constructorParameters) {
                String name = parameter.getName();
                String accessorName2 = JSFormatterUtil.transformVarNameToAccessorName((String)name, (JSCodeStyleSettings)codeStyleSettings);
                if (!duplicatesChecker.process((Object)accessorName2)) continue;
                candidatesMap.put(accessorName2, parameter);
            }
        }
        for (JSPsiNamedElementBase n : ContainerUtil.filter(candidatesMap, s -> duplicatesChecker.process(s)).values()) {
            if (!(n instanceof JSNamedElement)) continue;
            candidates.add((JSChooserElementNode)new JSNamedElementNode(n));
        }
    }

    private static void appendUnnamedComputedProperties(PsiElement clazz, boolean skipThatHaveGetters, boolean skipThatHaveSetters, Set<String> accessors) {
        JSFunction[] children = (JSFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)clazz, JSFunction.class);
        if (children != null) {
            for (JSFunction jSFunction : children) {
                ASTNode identifier;
                if (jSFunction.getName() != null || (!skipThatHaveGetters || !jSFunction.isGetProperty()) && (!skipThatHaveSetters || !jSFunction.isSetProperty()) || (identifier = JSPsiImplUtils.getComputedNameOfFunction((ASTNode)jSFunction.getNode(), (boolean)false)) == null) continue;
                accessors.add(identifier.getText());
            }
        }
        if (clazz instanceof JSClass) {
            for (JSFunction jSFunction : ((JSClass)clazz).getSuperClasses()) {
                BaseJSGenerateHandler.appendUnnamedComputedProperties((PsiElement)jSFunction, skipThatHaveGetters, skipThatHaveSetters, accessors);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        PsiElement jsClass = BaseJSGenerateHandler.findClassOrObjectLiteral(file, editor, null);
        return this.isValidForTarget(jsClass);
    }

    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSObjectLiteralExpression || BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass);
    }

    private static PsiElement getMeaningfulElementAtCaret(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiElement at;
        if (file == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(14);
        }
        if ((at = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        if (at instanceof PsiWhiteSpace || at instanceof PsiComment) {
            at = PsiTreeUtil.findFirstParent((PsiElement)at, (Condition)Conditions.not(el -> el instanceof PsiWhiteSpace || el instanceof PsiComment));
        }
        return at;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/generation/BaseJSGenerateHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPartConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesToSelect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoCandidatesMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesToSelect";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClassOrObjectLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indexedPropertyAccessCheck";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulElementAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }

    public static enum ElementsToSelect {
        None,
        All,
        OnlyRequired;

    }
}

