/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSNonASCIINamesInspection
extends JSInspection {
    private static final Key<Map<String, String>> WARNING_TEXTS = Key.create((String)"Javascript.Non.ASCII.Identifiers.Cache");
    public boolean myAllowOnlyAscii;

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myAllowOnlyAscii", (String)JavaScriptBundle.message((String)"non.ascii.identifiers.only.ascii", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSElement(@NotNull JSElement node) {
                PsiElement identifier;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)node).getNameIdentifier()) != null && !(identifier instanceof JSReferenceExpression) && !(identifier.getParent() instanceof JSReferenceExpression)) {
                    this.checkIdentifier(identifier);
                }
            }

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.checkIdentifier(node.getReferenceNameElement());
            }

            public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
                JSExpression expression;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((expression = node.getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isQuotedLiteral()) {
                    this.checkIdentifier((PsiElement)expression);
                }
            }

            private void checkIdentifier(PsiElement identifier) {
                String warning;
                if (identifier == null || identifier instanceof JSReferenceExpression) {
                    return;
                }
                String text = identifier.getText();
                HashMap<String, String> map = (HashMap<String, String>)session.getUserData(WARNING_TEXTS);
                String string = warning = map == null ? null : (String)map.get(text);
                String problemDescription = warning != null ? (warning.isEmpty() ? null : warning) : new Checker(JSNonASCIINamesInspection.this.myAllowOnlyAscii, text).process();
                if (!StringUtil.isEmptyOrSpaces((String)text) && problemDescription != null) {
                    if (map == null) {
                        map = new HashMap<String, String>();
                        session.putUserData(WARNING_TEXTS, map);
                    }
                    map.put(text, problemDescription);
                    holder.registerProblem(identifier, JSNonASCIINamesInspection.this.myAllowOnlyAscii ? JavaScriptBundle.message((String)"non.ascii.identifiers.non.ascii.found", (Object[])new Object[]{problemDescription}) : JavaScriptBundle.message((String)"non.ascii.identifiers.mixed.set", (Object[])new Object[]{problemDescription}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSIndexedPropertyAccessExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class Checker {
        private final boolean myOnlyASCII;
        private final String myText;
        private boolean containNonAscii = false;
        private boolean containAscii = false;
        private StringBuilder myResult;

        Checker(boolean onlyASCII, String text) {
            this.myOnlyASCII = onlyASCII;
            this.myText = text;
        }

        private void iterateText(@NotNull Processor<Integer> processor) {
            int point;
            if (processor == null) {
                Checker.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < this.myText.length() && processor.process((Object)(point = this.myText.codePointAt(i))); ++i) {
            }
        }

        public String process() {
            this.iterateText((Processor<Integer>)((Processor)point -> {
                if (point < 128) {
                    if (Character.isLetter(point)) {
                        this.containAscii = true;
                    }
                } else {
                    this.containNonAscii = true;
                }
                return !this.errorFound();
            }));
            if (this.errorFound()) {
                this.myResult = new StringBuilder("<span>");
                this.iterateText((Processor<Integer>)((Processor)point -> {
                    if (point >= 128) {
                        this.myResult.append("<span style=\"color: red\">").append(Character.toChars(point)).append("</span>");
                    } else {
                        this.myResult.append(Character.toChars(point));
                    }
                    return true;
                }));
            }
            return this.myResult == null ? null : this.myResult.toString();
        }

        private boolean errorFound() {
            return this.myOnlyASCII && this.containNonAscii || this.containAscii && this.containNonAscii;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection$Checker", "iterateText"));
        }
    }
}

