/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSuperInvocationFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @Nullable
    private final SmartPsiElementPointer<JSFunction> mySuperConstructorPointer;

    public AddSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        super((PsiElement)constructor);
        this.mySuperConstructorPointer = superConstructor != null ? SmartPointerManager.createPointer((PsiElement)superConstructor) : null;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"javascript.fix.create.invoke.super", (Object[])new Object[0]);
        if (string == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSFunction superConstructor;
        if (project == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(5);
        }
        JSFunction constructor = (JSFunction)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        JSFunction jSFunction = superConstructor = this.mySuperConstructorPointer != null ? (JSFunction)this.mySuperConstructorPointer.getElement() : null;
        if (editor == null) {
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        AddSuperInvocationFix.addToTemplate(template, (PsiElement)constructor, superConstructor);
        JSBlockStatement body = constructor.getBlock();
        if (body != null) {
            PsiElement firstChild = body.getFirstChild();
            editor.getCaretModel().moveToOffset(firstChild.getTextRange().getEndOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }
    }

    public static void addToTemplate(@NotNull Template template, @NotNull PsiElement context, @Nullable JSFunction superConstructor) {
        JSParameterListElement[] parameters;
        if (template == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(7);
        }
        template.addTextSegment("super(");
        boolean first = true;
        for (JSParameterListElement p : parameters = superConstructor != null ? superConstructor.getParameters() : JSParameterListElement.EMPTY_ARRAY) {
            if (p.isRest()) break;
            if (!first) {
                template.addTextSegment(", ");
            }
            first = false;
            template.addVariable((Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        }
        template.addTextSegment(")");
        String s = JSCodeStyleSettings.getSemicolon((PsiElement)context);
        template.addTextSegment(s);
        template.addEndVariable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

