/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.control.TrivialConditionalFix;
import com.sixrr.inspectjs.control.TrivialConditionalJSInspectionKt;
import com.sixrr.inspectjs.utils.BoolUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/sixrr/inspectjs/control/UnnecessaryConditionalExpressionVisitor;", "Lcom/sixrr/inspectjs/BaseInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitJSConditionalExpression", "", "exp", "Lcom/intellij/lang/javascript/psi/JSConditionalExpression;", "intellij.javascript.ultimate"})
final class UnnecessaryConditionalExpressionVisitor
extends BaseInspectionVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public UnnecessaryConditionalExpressionVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitJSConditionalExpression(@NotNull JSConditionalExpression exp) {
        Intrinsics.checkNotNullParameter((Object)exp, (String)"exp");
        super.visitJSConditionalExpression(exp);
        if (exp.getCondition() == null) {
            return;
        }
        JSExpression jSExpression = (JSExpression)exp.getThenBranch();
        if (jSExpression == null) {
            return;
        }
        JSExpression thenExpression = jSExpression;
        JSExpression jSExpression2 = (JSExpression)exp.getElseBranch();
        if (jSExpression2 == null) {
            return;
        }
        JSExpression elseExpression = jSExpression2;
        if (BoolUtils.isFalseLiteral(thenExpression) && BoolUtils.isTrueLiteral(elseExpression) || BoolUtils.isTrueLiteral(thenExpression) && BoolUtils.isFalseLiteral(elseExpression)) {
            Object[] objectArray = new Object[]{exp.getText(), TrivialConditionalJSInspectionKt.access$calculateReplacementExpression(exp)};
            String string = JavaScriptBundle.message((String)"trivial.conditional.error.string", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{TrivialConditionalFix.INSTANCE};
            this.holder.registerProblem((PsiElement)exp, message, localQuickFixArray);
        }
    }
}

