/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/analysis/customization/console/ClassInfoResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "mySearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "resolveClasses", "Lcom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo;", "className", "", "packageName", "Companion", "ClassResolveInfo", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nClassInfoResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassInfoResolver.kt\ncom/intellij/analysis/customization/console/ClassInfoResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n777#2:110\n873#2,2:111\n1586#2:113\n1661#2,3:114\n777#2:117\n873#2,2:118\n*S KotlinDebug\n*F\n+ 1 ClassInfoResolver.kt\ncom/intellij/analysis/customization/console/ClassInfoResolver\n*L\n90#1:110\n90#1:111,2\n91#1:113\n91#1:114,3\n92#1:117\n92#1:118,2\n*E\n"})
public final class ClassInfoResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope mySearchScope;

    public ClassInfoResolver(@NotNull Project project, @NotNull GlobalSearchScope mySearchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mySearchScope, (String)"mySearchScope");
        this.project = project;
        this.mySearchScope = mySearchScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassResolveInfo resolveClasses(@NotNull String className, @NotNull String packageName) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        PsiClass it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (DumbService.Companion.isDumb(this.project)) {
            return ClassResolveInfo.Companion.getEMPTY();
        }
        List classes = ClassInfoResolver.Companion.findClasses(this.project, this.mySearchScope, className, packageName);
        Iterable $this$filter$iv = classes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiClass)element$iv$iv;
            boolean bl = false;
            if (!(it.isValid() && it.getContainingFile() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it, (Object)it.getContainingFile().getVirtualFile()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map mapWithClasses = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ClassResolveInfo result = mapWithClasses.isEmpty() ? ClassResolveInfo.Companion.getEMPTY() : new ClassResolveInfo(mapWithClasses);
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo;", "", "classes", "", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/Map;)V", "getClasses", "()Ljava/util/Map;", "isValid", "", "()Z", "Companion", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nClassInfoResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassInfoResolver.kt\ncom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1786#2,3:110\n*S KotlinDebug\n*F\n+ 1 ClassInfoResolver.kt\ncom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo\n*L\n102#1:110,3\n*E\n"})
    public static final class ClassResolveInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<PsiClass, VirtualFile> classes;
        @NotNull
        private static final ClassResolveInfo EMPTY = new ClassResolveInfo(MapsKt.emptyMap());

        public ClassResolveInfo(@NotNull Map<PsiClass, ? extends VirtualFile> classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            this.classes = classes;
        }

        @NotNull
        public final Map<PsiClass, VirtualFile> getClasses() {
            return this.classes;
        }

        public final boolean isValid() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.classes.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement obj = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (obj.isValid()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo;", "getEMPTY", "()Lcom/intellij/analysis/customization/console/ClassInfoResolver$ClassResolveInfo;", "intellij.jvm.analysis.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ClassResolveInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0007J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/analysis/customization/console/ClassInfoResolver$Companion;", "", "<init>", "()V", "findSubclassName", "", "className", "findSubclassName$intellij_jvm_analysis_impl", "findClasses", "", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "shortClassName", "targetPackageName", "canBeShortenedPackages", "", "qualifiedName", "intellij.jvm.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String findSubclassName$intellij_jvm_analysis_impl(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            int probablySubclassIndex = StringsKt.lastIndexOf$default((CharSequence)className, (char)'$', (int)0, (boolean)false, (int)6, null);
            if (probablySubclassIndex != -1 && probablySubclassIndex != 0 && className.length() > probablySubclassIndex + 1) {
                String string = className.substring(probablySubclassIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return null;
        }

        private final List<PsiClass> findClasses(Project project, GlobalSearchScope scope, String shortClassName, String targetPackageName) {
            Set result = new LinkedHashSet();
            List list = PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)project);
            for (PsiShortNamesCache cache : list) {
                PsiClass[] classes;
                Intrinsics.checkNotNullExpressionValue((Object)cache.getClassesByName(shortClassName, scope), (String)"getClassesByName(...)");
                for (PsiClass psiClass : classes) {
                    Intrinsics.checkNotNull((Object)psiClass);
                    PsiClass clazz = psiClass;
                    String qualifiedName = clazz.getQualifiedName();
                    if (!this.canBeShortenedPackages(qualifiedName, targetPackageName)) {
                        if (!StringsKt.contains$default((CharSequence)targetPackageName, (CharSequence)"$", (boolean)false, (int)2, null)) continue;
                        String string = qualifiedName;
                        if (!this.canBeShortenedPackages(string != null ? StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null) : null, StringsKt.replace$default((String)targetPackageName, (char)'$', (char)'.', (boolean)false, (int)4, null))) continue;
                    }
                    result.add(clazz);
                }
            }
            if (result.isEmpty()) {
                String newShortClassName;
                String string = newShortClassName = this.findSubclassName$intellij_jvm_analysis_impl(shortClassName);
                boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
                if (bl) {
                    if (!Character.isDigit(newShortClassName.charAt(0))) {
                        String string2 = shortClassName.substring(0, shortClassName.length() - newShortClassName.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String newTargetPackageName = targetPackageName + "." + string2;
                        return this.findClasses(project, scope, newShortClassName, newTargetPackageName);
                    }
                    newShortClassName = StringsKt.take((String)shortClassName, (int)(shortClassName.length() - newShortClassName.length() - 1));
                    return this.findClasses(project, scope, newShortClassName, targetPackageName);
                }
            }
            return CollectionsKt.toList((Iterable)result);
        }

        private final boolean canBeShortenedPackages(String qualifiedName, String targetPackageName) {
            if (qualifiedName == null) {
                return false;
            }
            String string = StringUtil.getPackageName((String)qualifiedName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            String actualPackageName = string;
            if (StringsKt.endsWith$default((String)actualPackageName, (String)targetPackageName, (boolean)false, (int)2, null)) {
                return true;
            }
            String[] stringArray = new String[]{"."};
            List actualPackageNames = StringsKt.split$default((CharSequence)actualPackageName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String[] stringArray2 = new String[]{"."};
            List targetPackageNames = StringsKt.split$default((CharSequence)targetPackageName, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (actualPackageNames.size() != targetPackageNames.size()) {
                return false;
            }
            int n = ((Collection)actualPackageNames).size();
            for (int i = 0; i < n; ++i) {
                if (StringsKt.startsWith$default((String)((String)actualPackageNames.get(i)), (String)((String)targetPackageNames.get(i)), (boolean)false, (int)2, null)) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

