/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.toolwindow.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.frontend.editor.TerminalViewVirtualFile;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0006\u0012\u0002\b\u00030\rH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0006\u0012\u0002\b\u00030\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/frontend/toolwindow/impl/TerminalDockContainer;", "Lcom/intellij/ui/docking/DockContainer;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;)V", "getAcceptArea", "Lcom/intellij/ui/awt/RelativeRectangle;", "getContentResponse", "Lcom/intellij/ui/docking/DockContainer$ContentResponse;", "content", "Lcom/intellij/ui/docking/DockableContent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "getContainerComponent", "add", "", "dropTarget", "findNearestContentManager", "Lcom/intellij/ui/content/ContentManager;", "Ljava/awt/Component;", "isEmpty", "", "isDisposeWhenEmpty", "getClassicTerminalFile", "Lorg/jetbrains/plugins/terminal/vfs/TerminalSessionVirtualFileImpl;", "getReworkedTerminalFile", "Lcom/intellij/terminal/frontend/editor/TerminalViewVirtualFile;", "Companion", "intellij.terminal.frontend"})
public final class TerminalDockContainer
implements DockContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JComponent component;

    private TerminalDockContainer(Project project, JComponent component2) {
        this.project = project;
        this.component = component2;
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle(this.component);
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent<?> content, @Nullable RelativePoint point) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        return this.getClassicTerminalFile(content) != null || this.getReworkedTerminalFile(content) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
    }

    @NotNull
    public JComponent getContainerComponent() {
        return this.component;
    }

    public void add(@NotNull DockableContent<?> content, @Nullable RelativePoint dropTarget) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        if (dropTarget == null) {
            return;
        }
        Component component2 = dropTarget.getOriginalComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getOriginalComponent(...)");
        Component component3 = component2;
        Point point = dropTarget.getOriginalPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getOriginalPoint(...)");
        Point point2 = point;
        Component deepestComponent = UIUtil.getDeepestComponentAt((Component)component3, (int)point2.x, (int)point2.y);
        ContentManager nearestManager = this.findNearestContentManager(deepestComponent);
        TerminalSessionVirtualFileImpl classicTerminalFile = this.getClassicTerminalFile(content);
        TerminalViewVirtualFile reworkedTerminalFile = this.getReworkedTerminalFile(content);
        if (reworkedTerminalFile != null) {
            TerminalToolWindowTabsManager manager = TerminalToolWindowTabsManager.Companion.getInstance(this.project);
            manager.attachTab(reworkedTerminalFile.getTerminalView(), nearestManager);
        } else if (classicTerminalFile != null) {
            TerminalEngine engine = TerminalEngine.CLASSIC;
            TerminalToolWindowManager manager = TerminalToolWindowManager.getInstance(this.project);
            Content content2 = manager.createNewTab(nearestManager, classicTerminalFile.getTerminalWidget(), manager.getTerminalRunner(), engine, null, true, true);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createNewTab(...)");
            Content newContent = content2;
            newContent.setDisplayName(classicTerminalFile.getName());
        }
    }

    private final ContentManager findNearestContentManager(Component component2) {
        if (component2 == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(component2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        return (ContentManager)dataContext2.getData(PlatformDataKeys.TOOL_WINDOW_CONTENT_MANAGER);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isDisposeWhenEmpty() {
        return false;
    }

    private final TerminalSessionVirtualFileImpl getClassicTerminalFile(DockableContent<?> $this$getClassicTerminalFile) {
        Object object = $this$getClassicTerminalFile.getKey();
        return object instanceof TerminalSessionVirtualFileImpl ? (TerminalSessionVirtualFileImpl)((Object)object) : null;
    }

    private final TerminalViewVirtualFile getReworkedTerminalFile(DockableContent<?> $this$getReworkedTerminalFile) {
        Object object = $this$getReworkedTerminalFile.getKey();
        return object instanceof TerminalViewVirtualFile ? (TerminalViewVirtualFile)((Object)object) : null;
    }

    @JvmStatic
    public static final void install(@NotNull Project project, @NotNull JComponent component2) {
        Companion.install(project, component2);
    }

    public /* synthetic */ TerminalDockContainer(Project project, JComponent component2, DefaultConstructorMarker $constructor_marker) {
        this(project, component2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/toolwindow/impl/TerminalDockContainer$Companion;", "", "<init>", "()V", "install", "", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljavax/swing/JComponent;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void install(@NotNull Project project, @NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            UiScopeKt.launchOnShow$default((Component)component2, (String)"TerminalDockContainer", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, component2, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ JComponent $component;
                {
                    this.$project = $project;
                    this.$component = $component;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            TerminalDockContainer container = new TerminalDockContainer(this.$project, this.$component, null);
                            Disposable disposable = Disposer.newDisposable((String)"TerminalDockContainer");
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                            Disposable disposable2 = disposable;
                            DockManager.getInstance((Project)this.$project).register((DockContainer)container, disposable2);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)container);
                            this.L$1 = disposable2;
                            this.label = 1;
                            Object object2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            Object object2;
                            Disposable disposable2 = (Disposable)this.L$1;
                            TerminalDockContainer container = (TerminalDockContainer)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                throw new KotlinNothingValueException();
                            }
                            catch (Throwable throwable) {
                                Disposer.dispose((Disposable)disposable2);
                                throw throwable;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

