/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.completion.spec.ShellCompletionSuggestion;
import com.intellij.terminal.completion.spec.ShellSuggestionType;
import com.intellij.terminal.frontend.view.completion.PowerShellCompletionContributor;
import com.intellij.terminal.frontend.view.completion.PowerShellCompletionContributorKt;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionContext;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionContributor;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionResult;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.completion.TerminalCommandCompletionShowingMode;
import org.jetbrains.plugins.terminal.block.completion.powershell.PowerShellCompletionItem;
import org.jetbrains.plugins.terminal.block.completion.powershell.PowerShellCompletionResultType;
import org.jetbrains.plugins.terminal.block.completion.powershell.PowerShellCompletionResultWithContext;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecApiKt;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellCompletionSuggestionContext;
import org.jetbrains.plugins.terminal.session.ShellName;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellBasedCompletionListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\n*\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/terminal/frontend/view/completion/PowerShellCompletionContributor;", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContributor;", "<init>", "()V", "getCompletionSuggestions", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionResult;", "context", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContext;", "(Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitCompletionResult", "", "shellIntegration", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "(Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBestPrefix", "typedPrefix", "matches", "", "Lorg/jetbrains/plugins/terminal/block/completion/powershell/PowerShellCompletionItem;", "toShellSuggestion", "Lcom/intellij/terminal/completion/spec/ShellCompletionSuggestion;", "item", "toShellSuggestionType", "Lcom/intellij/terminal/completion/spec/ShellSuggestionType;", "Lorg/jetbrains/plugins/terminal/block/completion/powershell/PowerShellCompletionResultType;", "getIcon", "Ljavax/swing/Icon;", "appendQuotesAware", "value", "Companion", "intellij.terminal.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPowerShellCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerShellCompletionContributor.kt\ncom/intellij/terminal/frontend/view/completion/PowerShellCompletionContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,222:1\n67#2,4:223\n13#2:243\n222#3:227\n1586#4:228\n1661#4,3:229\n426#5,11:232\n*S KotlinDebug\n*F\n+ 1 PowerShellCompletionContributor.kt\ncom/intellij/terminal/frontend/view/completion/PowerShellCompletionContributor\n*L\n43#1:223,4\n212#1:243\n47#1:227\n71#1:228\n71#1:229,3\n86#1:232,11\n*E\n"})
public final class PowerShellCompletionContributor
implements TerminalCommandCompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    @NotNull
    public static final String CALL_COMPLETION_SEQUENCE = "\u001b[24~e";
    @NotNull
    private static final Logger LOG;

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getCompletionSuggestions(@NotNull TerminalCommandCompletionContext context, @NotNull Continuation<? super TerminalCommandCompletionResult> $completion) {
        if (!($completion instanceof getCompletionSuggestions.1)) ** GOTO lbl-1000
        var22_3 = $completion;
        if ((var22_3.label & -2147483648) != 0) {
            var22_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PowerShellCompletionContributor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCompletionSuggestions(null, (Continuation<? super TerminalCommandCompletionResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!ShellName.Companion.isPowerShell(context.getShellName())) {
                    return null;
                }
                if (context.isAutoPopup() && TerminalOptionsProvider.Companion.getInstance().getCommandCompletionShowingMode() != TerminalCommandCompletionShowingMode.ALWAYS) {
                    return null;
                }
                context.getTerminalView().sendText("\u001b[24~e");
                $continuation.L$0 = context;
                $continuation.label = 1;
                v0 = this.awaitCompletionResult(context.getShellIntegration(), (Continuation<? super String>)$continuation);
                if (v0 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                context = (TerminalCommandCompletionContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                result = (String)v0;
                $this$trace$iv = PowerShellCompletionContributor.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var20_10 = $this$trace$iv;
                    $i$a$-trace-PowerShellCompletionContributor$getCompletionSuggestions$2 = false;
                    var20_10.trace("PowerShell completion result: " + result);
                }
                json = JsonKt.Json$default(null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCompletionSuggestions$lambda$1(kotlinx.serialization.json.JsonBuilder ), (Lkotlinx/serialization/json/JsonBuilder;)Lkotlin/Unit;)(), (int)1, null);
                try {
                    $i$a$-trace-PowerShellCompletionContributor$getCompletionSuggestions$2 = json;
                    string$iv = result;
                    $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    this_$iv = (PowerShellCompletionResultWithContext)this_$iv.decodeFromString((DeserializationStrategy)PowerShellCompletionResultWithContext.Companion.serializer(), string$iv);
                }
                catch (Exception ex) {
                    PowerShellCompletionContributor.LOG.error("Failed to parse PowerShell completion result: " + result, (Throwable)ex);
                    return null;
                }
                completionResult = this_$iv;
                if (completionResult.getMatches().isEmpty()) {
                    return null;
                }
                v1 = completionResult.getCommandText().substring(completionResult.getReplacementIndex(), completionResult.getCursorIndex());
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                powerShellPrefix = v1;
                prefixLength = powerShellPrefix.length();
                localCursorOffset = (int)context.getInitialCursorOffset().minus(context.getCommandStartOffset());
                v2 = context.getCommandText().substring(localCursorOffset - prefixLength, localCursorOffset);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                typedPrefix = v2;
                if (!Intrinsics.areEqual((Object)powerShellPrefix, (Object)typedPrefix)) {
                    return null;
                }
                $this$map$iv = completionResult.getMatches();
                $i$f$map = false;
                var13_20 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_26 = (PowerShellCompletionItem)item$iv$iv;
                    var20_10 = destination$iv$iv;
                    $i$a$-map-PowerShellCompletionContributor$getCompletionSuggestions$suggestions$1 = false;
                    var20_10.add(this.toShellSuggestion((PowerShellCompletionItem)it));
                }
                suggestions = (List)destination$iv$iv;
                prefix = this.findBestPrefix(typedPrefix, completionResult.getMatches());
                beforePrefixReplacementLength = StringsKt.removeSuffix((String)typedPrefix, (CharSequence)prefix).length();
                afterPrefixReplacementLength = completionResult.getReplacementIndex() + completionResult.getReplacementLength() - completionResult.getCursorIndex();
                return new TerminalCommandCompletionResult(suggestions, prefix, beforePrefixReplacementLength, afterPrefixReplacementLength);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object awaitCompletionResult(TerminalShellIntegration shellIntegration, Continuation<? super String> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super String> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(disposable2){
            final /* synthetic */ Disposable $disposable;
            {
                this.$disposable = $disposable;
            }

            public final void invoke(Throwable it) {
                Disposer.dispose((Disposable)this.$disposable);
            }
        });
        shellIntegration.addShellBasedCompletionListener(disposable2, new TerminalShellBasedCompletionListener(disposable2, (CancellableContinuation<? super String>)continuation){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ CancellableContinuation<String> $continuation;
            {
                this.$disposable = $disposable;
                this.$continuation = $continuation;
            }

            public void completionFinished(String result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                Disposer.dispose((Disposable)this.$disposable);
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)result2));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final String findBestPrefix(String typedPrefix, List<PowerShellCompletionItem> matches) {
        if (!(!((Collection)matches).isEmpty())) {
            throw new IllegalStateException("Check failed.");
        }
        PowerShellCompletionItem firstMatch = matches.get(0);
        String string = firstMatch.getPresentableText();
        if (string == null) {
            string = firstMatch.getValue();
        }
        String label = string;
        int n = typedPrefix.length();
        for (int i = 0; i < n; ++i) {
            String candidate;
            Intrinsics.checkNotNullExpressionValue((Object)typedPrefix.substring(i), (String)"substring(...)");
            if (!StringsKt.startsWith((String)label, (String)candidate, (boolean)true)) continue;
            return candidate;
        }
        return "";
    }

    private final ShellCompletionSuggestion toShellSuggestion(PowerShellCompletionItem item) {
        String string = item.getPresentableText();
        if (string == null) {
            string = item.getValue();
        }
        String lookupString = string;
        Ref.ObjectRef insertValue = new Ref.ObjectRef();
        insertValue.element = item.getValue();
        if (item.getType() == PowerShellCompletionResultType.PROVIDER_CONTAINER) {
            String separator = File.separator;
            Intrinsics.checkNotNull((Object)separator);
            lookupString = StringsKt.endsWith$default((String)lookupString, (String)separator, (boolean)false, (int)2, null) ? lookupString : lookupString + separator;
            insertValue.element = this.appendQuotesAware((String)insertValue.element, separator);
        }
        insertValue.element = this.appendQuotesAware((String)insertValue.element, "{cursor}");
        return ShellCommandSpecApiKt.ShellCompletionSuggestion(lookupString, (Function1<? super ShellCompletionSuggestionContext, Unit>)((Function1)arg_0 -> PowerShellCompletionContributor.toShellSuggestion$lambda$0(insertValue, this, item, arg_0)));
    }

    private final ShellSuggestionType toShellSuggestionType(PowerShellCompletionResultType $this$toShellSuggestionType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toShellSuggestionType.ordinal()]) {
            case 1 -> ShellSuggestionType.FILE;
            case 2 -> ShellSuggestionType.FOLDER;
            default -> ShellSuggestionType.ARGUMENT;
        };
    }

    private final Icon getIcon(PowerShellCompletionResultType $this$getIcon) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getIcon.ordinal()]) {
            case 3, 4, 5 -> TerminalIcons.Command;
            case 6 -> TerminalIcons.Option;
            case 1, 2 -> null;
            default -> TerminalIcons.Other;
        };
    }

    private final String appendQuotesAware(String $this$appendQuotesAware, String value) {
        Object object;
        String str = $this$appendQuotesAware;
        String invocationPrefix = "& ";
        boolean shouldAddInvocationPrefix = false;
        if (StringsKt.startsWith$default((String)str, (String)invocationPrefix, (boolean)false, (int)2, null)) {
            str = StringsKt.removePrefix((String)str, (CharSequence)invocationPrefix);
            shouldAddInvocationPrefix = true;
        }
        if (PowerShellCompletionContributorKt.isSurroundedByQuotes(str)) {
            String quote = String.valueOf(StringsKt.first((CharSequence)str));
            String withoutQuotes = StringsKt.removeSurrounding((String)str, (CharSequence)quote);
            String withAddedValue = StringsKt.endsWith$default((String)withoutQuotes, (String)value, (boolean)false, (int)2, null) ? withoutQuotes : withoutQuotes + value;
            object = quote + withAddedValue + quote;
        } else {
            object = StringsKt.endsWith$default((String)str, (String)value, (boolean)false, (int)2, null) ? str : str + value;
        }
        str = object;
        return shouldAddInvocationPrefix ? invocationPrefix + str : str;
    }

    private static final Unit getCompletionSuggestions$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Unit toShellSuggestion$lambda$0(Ref.ObjectRef $insertValue, PowerShellCompletionContributor this$0, PowerShellCompletionItem $item, ShellCompletionSuggestionContext $this$ShellCompletionSuggestion) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCompletionSuggestion, (String)"$this$ShellCompletionSuggestion");
        $this$ShellCompletionSuggestion.insertValue((String)$insertValue.element);
        $this$ShellCompletionSuggestion.type(this$0.toShellSuggestionType($item.getType()));
        Icon typeIcon = this$0.getIcon($item.getType());
        if (typeIcon != null) {
            $this$ShellCompletionSuggestion.icon(typeIcon);
        }
        $this$ShellCompletionSuggestion.noEscaping();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$awaitCompletionResult(PowerShellCompletionContributor $this, TerminalShellIntegration shellIntegration, Continuation $completion) {
        return $this.awaitCompletionResult(shellIntegration, (Continuation<? super String>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PowerShellCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/view/completion/PowerShellCompletionContributor$Companion;", "", "<init>", "()V", "CALL_COMPLETION_SEQUENCE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PowerShellCompletionResultType.values().length];
            try {
                nArray[PowerShellCompletionResultType.PROVIDER_ITEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowerShellCompletionResultType.PROVIDER_CONTAINER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowerShellCompletionResultType.COMMAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowerShellCompletionResultType.METHOD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowerShellCompletionResultType.HISTORY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowerShellCompletionResultType.PARAMETER_NAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

